/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.api;

public class Version {
    public int major;
    public int minor;
    public int patch;
    public int build;

    public Version(int majorNum, int minorNum, int patchNum, int buildNum) {
        this.major = majorNum;
        this.minor = minorNum;
        this.patch = patchNum;
        this.build = buildNum;
    }

    public static Version get(String s) {
        String[] split = s.replace('.', ':').split(":");
        if (split.length != 4) {
            return null;
        }
        for (String i : split) {
            char[] cArray = i.toCharArray();
            int n = cArray.length;
            for (int j = 0; j < n; ++j) {
                Character c = Character.valueOf(cArray[j]);
                if (Character.isDigit(c.charValue())) continue;
                return null;
            }
        }
        int[] digits = new int[4];
        for (int i = 0; i < 4; ++i) {
            digits[i] = Integer.parseInt(split[i]);
        }
        return new Version(digits[0], digits[1], digits[2], digits[3]);
    }

    public void reset() {
        this.major = 0;
        this.minor = 0;
        this.patch = 0;
        this.build = 0;
    }

    public byte comparedState(Version version) {
        if (version.major > this.major) {
            return -1;
        }
        if (version.major == this.major) {
            if (version.minor > this.minor) {
                return -1;
            }
            if (version.minor == this.minor) {
                if (version.patch > this.patch) {
                    return -1;
                }
                if (version.patch == this.patch) {
                    return (byte)Integer.compare(this.build, version.build);
                }
                return 1;
            }
            return 1;
        }
        return 1;
    }

    public String toString() {
        if (this.major == 0 && this.minor == 0 && this.patch == 0 && this.build == 0) {
            return "";
        }
        return this.major + "." + this.minor + "." + this.patch + "." + this.build;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.build;
        result = 31 * result + this.patch;
        result = 31 * result + this.major;
        result = 31 * result + this.minor;
        return result;
    }

    public boolean equals(Object obj) {
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Version other = (Version)obj;
        return this.build == other.build && this.patch == other.patch && this.major == other.major && this.minor == other.minor;
    }
}

