/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core;

import java.awt.Color;
import java.util.ArrayList;
import java.util.EnumSet;
import micdoodle8.mods.galacticraft.api.GalacticraftRegistry;
import micdoodle8.mods.galacticraft.api.galaxies.CelestialBody;
import micdoodle8.mods.galacticraft.api.galaxies.GalaxyRegistry;
import micdoodle8.mods.galacticraft.api.galaxies.Moon;
import micdoodle8.mods.galacticraft.api.galaxies.Planet;
import micdoodle8.mods.galacticraft.api.galaxies.Satellite;
import micdoodle8.mods.galacticraft.api.galaxies.SolarSystem;
import micdoodle8.mods.galacticraft.api.galaxies.Star;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import micdoodle8.mods.galacticraft.api.world.AtmosphereInfo;
import micdoodle8.mods.galacticraft.api.world.EnumAtmosphericGas;
import micdoodle8.mods.galacticraft.core.GCItems;
import micdoodle8.mods.galacticraft.core.dimension.GCDimensions;
import micdoodle8.mods.galacticraft.core.dimension.TeleportTypeMoon;
import micdoodle8.mods.galacticraft.core.dimension.TeleportTypeOrbit;
import micdoodle8.mods.galacticraft.core.dimension.TeleportTypeOverworld;
import micdoodle8.mods.galacticraft.core.dimension.WorldProviderMoon;
import micdoodle8.mods.galacticraft.core.dimension.WorldProviderOverworldOrbit;
import micdoodle8.mods.galacticraft.core.entities.EntityEvolvedCreeper;
import micdoodle8.mods.galacticraft.core.entities.EntityEvolvedEnderman;
import micdoodle8.mods.galacticraft.core.entities.EntityEvolvedSkeleton;
import micdoodle8.mods.galacticraft.core.entities.EntityEvolvedSpider;
import micdoodle8.mods.galacticraft.core.entities.EntityEvolvedZombie;
import micdoodle8.mods.galacticraft.core.util.ConfigManagerCore;
import micdoodle8.mods.galacticraft.core.util.GCLog;
import micdoodle8.mods.galacticraft.core.world.gen.BiomeMoon;
import micdoodle8.mods.galacticraft.core.world.gen.BiomeOrbit;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.WorldProviderSurface;
import net.minecraft.world.biome.Biome;

public class GCBodies {
    private static final GCBodies INSTANCE = new GCBodies();
    public static SolarSystem solarSystemSol = new SolarSystem("sol", "milky_way");
    public static Star starSol = new Star("sol");
    public static Planet planetOverworld = new Planet("overworld");
    public static Moon moonMoon = new Moon("moon");
    public static Satellite satelliteSpaceStation = new Satellite("spacestation.overworld");
    public static Planet planetMercury = GCBodies.makeDummyPlanet("mercury");
    public static Planet planetJupiter = GCBodies.makeDummyPlanet("jupiter");
    public static Planet planetSaturn = GCBodies.makeDummyPlanet("saturn");
    public static Planet planetUranus = GCBodies.makeDummyPlanet("uranus");
    public static Planet planetNeptune = GCBodies.makeDummyPlanet("neptune");
    public static Color TEAL = new Color(25, 229, 153);
    public static Color RED = new Color(170, 25, 25);

    public static GCBodies instance() {
        return INSTANCE;
    }

    public void preInit() {
        solarSystemSol.setMapPosition(new Vector3(0.0, 0.0, 0.0));
        planetOverworld.setParentSolarSystem(solarSystemSol).setRingColorRGB(TEAL).setPhaseShift(0.0f);
        moonMoon.setParentPlanet(planetOverworld).setRelativeSize(0.2667f).setRelativeDistanceFromCenter(this.scaleDist(13.0f)).setRelativeOrbitTime(100.0f);
        satelliteSpaceStation.setParentBody(planetOverworld).setRelativeSize(0.2667f).setRelativeDistanceFromCenter(this.scaleDist(9.0f)).setRelativeOrbitTime(20.0f);
    }

    public void setBiomes() {
        satelliteSpaceStation.setBiomeInfo(BiomeOrbit.space);
        moonMoon.setBiomeInfo(BiomeMoon.moonFlat);
    }

    public void init() {
        starSol.setParentSolarSystem(solarSystemSol).setTierRequired(-1);
        starSol.setBodyIcon(new ResourceLocation("galacticraftcore", "textures/gui/celestialbodies/sun.png"));
        solarSystemSol.setMainStar(starSol);
        planetOverworld.setBodyIcon(new ResourceLocation("galacticraftcore", "textures/gui/celestialbodies/earth.png"));
        planetOverworld.setDimensionInfo(ConfigManagerCore.idDimensionOverworld, WorldProvider.class, false).setTierRequired(1);
        planetOverworld.atmosphereComponents(EnumSet.of(EnumAtmosphericGas.OXYGEN, EnumAtmosphericGas.ARGON, EnumAtmosphericGas.WATER));
        planetOverworld.addChecklistKeys("equip_parachute");
        moonMoon.setDimensionInfo(ConfigManagerCore.idDimensionMoon, WorldProviderMoon.class).setTierRequired(1);
        moonMoon.setBodyIcon(new ResourceLocation("galacticraftcore", "textures/gui/celestialbodies/moon.png"));
        moonMoon.setAtmosphere(new AtmosphereInfo(false, false, false, 0.0f, 0.0f, 0.0f));
        moonMoon.addMobInfo(new Biome.SpawnListEntry(EntityEvolvedZombie.class, 8, 2, 3));
        moonMoon.addMobInfo(new Biome.SpawnListEntry(EntityEvolvedSpider.class, 8, 2, 3));
        moonMoon.addMobInfo(new Biome.SpawnListEntry(EntityEvolvedSkeleton.class, 8, 2, 3));
        moonMoon.addMobInfo(new Biome.SpawnListEntry(EntityEvolvedCreeper.class, 8, 2, 3));
        moonMoon.addMobInfo(new Biome.SpawnListEntry(EntityEvolvedEnderman.class, 10, 1, 4));
        moonMoon.addChecklistKeys("equip_oxygen_suit");
        satelliteSpaceStation.setDimensionInfo(ConfigManagerCore.idDimensionOverworldOrbit, ConfigManagerCore.idDimensionOverworldOrbitStatic, WorldProviderOverworldOrbit.class).setTierRequired(1);
        satelliteSpaceStation.setBodyIcon(new ResourceLocation("galacticraftcore", "textures/gui/celestialbodies/space_station.png"));
        satelliteSpaceStation.setAtmosphere(new AtmosphereInfo(false, false, false, 0.0f, 0.1f, 0.02f));
        satelliteSpaceStation.addChecklistKeys("equip_oxygen_suit", "create_grapple");
    }

    public void registerBodies() {
        GalaxyRegistry.registerSolarSystem(solarSystemSol);
        GalaxyRegistry.registerPlanet(planetOverworld);
        GalaxyRegistry.registerMoon(moonMoon);
        GalaxyRegistry.registerSatellite(satelliteSpaceStation);
        GCDimensions.ORBIT = GalacticraftRegistry.registerDimension("Space Station", "_orbit", ConfigManagerCore.idDimensionOverworldOrbit, WorldProviderOverworldOrbit.class, false);
        if (GCDimensions.ORBIT == null) {
            GCLog.error("Failed to register space station dimension type with ID " + ConfigManagerCore.idDimensionOverworldOrbit, new Object[0]);
        }
        if ((GCDimensions.ORBIT_KEEPLOADED = GalacticraftRegistry.registerDimension("Space Station", "_orbit", ConfigManagerCore.idDimensionOverworldOrbitStatic, WorldProviderOverworldOrbit.class, true)) == null) {
            GCLog.error("Failed to register space station dimension type with ID " + ConfigManagerCore.idDimensionOverworldOrbitStatic, new Object[0]);
        }
        GalacticraftRegistry.registerTeleportType(WorldProviderSurface.class, new TeleportTypeOverworld());
        GalacticraftRegistry.registerTeleportType(WorldProviderOverworldOrbit.class, new TeleportTypeOrbit());
        GalacticraftRegistry.registerTeleportType(WorldProviderMoon.class, new TeleportTypeMoon());
        GalacticraftRegistry.registerRocketGui(WorldProviderOverworldOrbit.class, new ResourceLocation("galacticraftcore", "textures/gui/overworld_rocket_gui.png"));
        GalacticraftRegistry.registerRocketGui(WorldProviderSurface.class, new ResourceLocation("galacticraftcore", "textures/gui/overworld_rocket_gui.png"));
        GalacticraftRegistry.registerRocketGui(WorldProviderMoon.class, new ResourceLocation("galacticraftcore", "textures/gui/moon_rocket_gui.png"));
        GalacticraftRegistry.addDungeonLoot(1, new ItemStack(GCItems.schematic, 1, 0));
        GalacticraftRegistry.addDungeonLoot(1, new ItemStack(GCItems.schematic, 1, 1));
    }

    public void postInit() {
        if (planetMercury != null) {
            planetMercury.setRingColorRGB(TEAL).setPhaseShift(1.45f).setRelativeDistanceFromCenter(this.scaleDist(0.5f)).setRelativeOrbitTime(0.24096386f);
        }
        if (planetJupiter != null) {
            planetJupiter.setRingColorRGB(TEAL).setPhaseShift((float)Math.PI).setRelativeDistanceFromCenter(this.scaleDist(1.5f)).setRelativeOrbitTime(11.861994f);
        }
        if (planetSaturn != null) {
            planetSaturn.setRingColorRGB(TEAL).setPhaseShift(5.45f).setRelativeDistanceFromCenter(this.scaleDist(1.75f)).setRelativeOrbitTime(29.463308f);
        }
        if (planetUranus != null) {
            planetUranus.setRingColorRGB(TEAL).setPhaseShift(1.38f).setRelativeDistanceFromCenter(this.scaleDist(2.0f)).setRelativeOrbitTime(84.06353f);
        }
        if (planetNeptune != null) {
            planetNeptune.setRingColorRGB(TEAL).setPhaseShift(1.0f).setRelativeDistanceFromCenter(this.scaleDist(2.25f)).setRelativeOrbitTime(164.84119f);
        }
    }

    private static Planet makeDummyPlanet(String name) {
        for (CelestialBody celestialBody : new ArrayList<Planet>(GalaxyRegistry.getRegisteredPlanets().values())) {
            if (!(celestialBody instanceof Planet) || !name.equals(celestialBody.getName())) continue;
            return null;
        }
        Planet planet = new Planet(name).setParentSolarSystem(solarSystemSol);
        planet.setBodyIcon(new ResourceLocation("galacticraftcore", "textures/gui/celestialbodies/" + name + ".png"));
        GalaxyRegistry.registerPlanet(planet);
        return planet;
    }

    private CelestialBody.ScalableDistance scaleDist(float var) {
        return new CelestialBody.ScalableDistance(var, var);
    }
}

