/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.blocks;

import java.util.Random;
import micdoodle8.mods.galacticraft.core.blocks.BlockMachineBase;
import micdoodle8.mods.galacticraft.core.tile.TileEntityCoalGenerator;
import micdoodle8.mods.galacticraft.core.tile.TileEntityIngotCompressor;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockMachine
extends BlockMachineBase {
    public static final PropertyEnum<EnumMachineType> TYPE = PropertyEnum.func_177709_a((String)"type", EnumMachineType.class);

    public BlockMachine(String assetName) {
        super(assetName);
    }

    @Override
    protected void initialiseTypes() {
        this.types = EnumMachineType.values;
        this.typeBase = EnumMachineType.values[0];
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        TileEntity tile = worldIn.func_175625_s(pos);
        if (tile instanceof TileEntityCoalGenerator) {
            TileEntityCoalGenerator tileEntity = (TileEntityCoalGenerator)tile;
            if (tileEntity.heatGJperTick > 0.0f) {
                float particlePosX = (float)pos.func_177958_n() + 0.5f;
                float particlePosY = (float)pos.func_177956_o() + 0.0f + rand.nextFloat() * 6.0f / 16.0f;
                float particlePosZ = (float)pos.func_177952_p() + 0.5f;
                float particleSize0 = 0.52f;
                float particleSize1 = rand.nextFloat() * 0.6f - 0.3f;
                switch ((EnumFacing)stateIn.func_177229_b((IProperty)FACING)) {
                    case NORTH: {
                        worldIn.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, (double)(particlePosX + particleSize1), (double)particlePosY, (double)(particlePosZ - particleSize0), 0.0, 0.0, 0.0, new int[0]);
                        worldIn.func_175688_a(EnumParticleTypes.FLAME, (double)(particlePosX + particleSize1), (double)particlePosY, (double)(particlePosZ - particleSize0), 0.0, 0.0, 0.0, new int[0]);
                        break;
                    }
                    case EAST: {
                        worldIn.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, (double)(particlePosX + particleSize0), (double)particlePosY, (double)(particlePosZ + particleSize1), 0.0, 0.0, 0.0, new int[0]);
                        worldIn.func_175688_a(EnumParticleTypes.FLAME, (double)(particlePosX + particleSize0), (double)particlePosY, (double)(particlePosZ + particleSize1), 0.0, 0.0, 0.0, new int[0]);
                        break;
                    }
                    case SOUTH: {
                        worldIn.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, (double)(particlePosX + particleSize1), (double)particlePosY, (double)(particlePosZ + particleSize0), 0.0, 0.0, 0.0, new int[0]);
                        worldIn.func_175688_a(EnumParticleTypes.FLAME, (double)(particlePosX + particleSize1), (double)particlePosY, (double)(particlePosZ + particleSize0), 0.0, 0.0, 0.0, new int[0]);
                        break;
                    }
                    case WEST: {
                        worldIn.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, (double)(particlePosX - particleSize0), (double)particlePosY, (double)(particlePosZ + particleSize1), 0.0, 0.0, 0.0, new int[0]);
                        worldIn.func_175688_a(EnumParticleTypes.FLAME, (double)(particlePosX - particleSize0), (double)particlePosY, (double)(particlePosZ + particleSize1), 0.0, 0.0, 0.0, new int[0]);
                    }
                }
            }
        }
    }

    public IBlockState func_176203_a(int meta) {
        EnumFacing enumfacing = EnumFacing.func_176731_b((int)(meta % 4));
        EnumMachineType type = (EnumMachineType)this.typeBase.fromMetadata(meta);
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)enumfacing).func_177226_a(TYPE, (Comparable)((Object)type));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176736_b() + ((EnumMachineType)((Object)state.func_177229_b(TYPE))).getMetadata();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, TYPE});
    }

    public static enum EnumMachineType implements BlockMachineBase.EnumMachineBase,
    IStringSerializable
    {
        COAL_GENERATOR(0, "coal_generator", TileEntityCoalGenerator::new, "tile.coal_generator.description", "tile.machine.0"),
        COMPRESSOR(12, "ingot_compressor", TileEntityIngotCompressor::new, "tile.compressor.description", "tile.machine.3");

        private final int meta;
        private final String name;
        private final TileConstructor tile;
        private final String shiftDescriptionKey;
        private final String blockName;
        private static final EnumMachineType[] values;

        private EnumMachineType(int meta, String name, TileConstructor tile, String key, String blockName) {
            this.meta = meta;
            this.name = name;
            this.tile = tile;
            this.shiftDescriptionKey = key;
            this.blockName = blockName;
        }

        @Override
        public int getMetadata() {
            return this.meta;
        }

        @Override
        public EnumMachineType fromMetadata(int meta) {
            switch (meta / 4) {
                case 3: {
                    return COMPRESSOR;
                }
            }
            return COAL_GENERATOR;
        }

        public String func_176610_l() {
            return this.name;
        }

        @Override
        public TileEntity tileConstructor() {
            return this.tile.create();
        }

        @Override
        public String getShiftDescriptionKey() {
            return this.shiftDescriptionKey;
        }

        @Override
        public String getUnlocalizedName() {
            return this.blockName;
        }

        static {
            values = EnumMachineType.values();
        }

        @FunctionalInterface
        private static interface TileConstructor {
            public TileEntity create();
        }
    }
}

