/*
 * Decompiled with CFR 0.152.
 */
package lumien.randomthings.handler.spectre;

import java.util.HashMap;
import java.util.UUID;
import lumien.randomthings.handler.ModDimensions;
import lumien.randomthings.handler.spectre.SpectreCube;
import lumien.randomthings.util.PlayerUtil;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.storage.WorldSavedData;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class SpectreHandler
extends WorldSavedData {
    public static final String ID = "SpectreHandler";
    private World worldObj;
    private HashMap<UUID, SpectreCube> cubes = new HashMap();
    private int positionCounter = 0;

    public SpectreHandler(String name) {
        super(name);
        this.worldObj = DimensionManager.getWorld((int)ModDimensions.SPECTRE_ID);
    }

    public SpectreHandler() {
        this(ID);
        this.cubes = new HashMap();
        this.worldObj = DimensionManager.getWorld((int)ModDimensions.SPECTRE_ID);
        this.positionCounter = 0;
    }

    public SpectreCube getSpectreCubeFromPos(World worldObj, BlockPos pos) {
        if (worldObj.field_73011_w.getDimension() != ModDimensions.SPECTRE_ID) {
            return null;
        }
        if (pos.func_177952_p() > 16 || pos.func_177952_p() < 0) {
            return null;
        }
        Chunk c = worldObj.func_175726_f(pos);
        int position = c.field_76635_g / 16;
        for (SpectreCube cube : this.cubes.values()) {
            if (cube.position / 16 != position) continue;
            if (pos.func_177956_o() <= 0 || pos.func_177956_o() > cube.height + 1 || pos.func_177958_n() < position * 16 || pos.func_177958_n() > cube.position * 16 + 15) {
                return null;
            }
            return cube;
        }
        return null;
    }

    public void teleportPlayerToSpectreCube(EntityPlayerMP player) {
        NBTTagCompound compound = player.getEntityData();
        compound.func_74780_a("spectrePosX", player.field_70165_t);
        compound.func_74780_a("spectrePosY", player.field_70163_u);
        compound.func_74780_a("spectrePosZ", player.field_70161_v);
        compound.func_74768_a("spectreDimension", player.field_71093_bK);
        UUID uuid = player.func_146103_bH().getId();
        SpectreCube spectreCube = this.cubes.containsKey(uuid) ? this.cubes.get(uuid) : this.generateSpectreCube(uuid);
        BlockPos spawn = spectreCube.getSpawnBlock();
        if (player.field_71093_bK != ModDimensions.SPECTRE_ID) {
            PlayerUtil.teleportPlayerToDimension(player, ModDimensions.SPECTRE_ID);
        }
        player.field_71135_a.func_147364_a((double)spawn.func_177958_n() + 0.5, (double)(spawn.func_177956_o() + 1), (double)spawn.func_177952_p() + 0.5, player.field_70177_z, player.field_70125_A);
    }

    private SpectreCube generateSpectreCube(UUID uuid) {
        SpectreCube cube = new SpectreCube(this, uuid, this.positionCounter);
        this.increaseNextPosition();
        cube.generate(this.worldObj);
        this.cubes.put(uuid, cube);
        this.func_76185_a();
        return cube;
    }

    private void increaseNextPosition() {
        this.positionCounter += 16;
    }

    public void func_76184_a(NBTTagCompound nbt) {
        NBTTagList cubeTags = nbt.func_150295_c("cubes", 10);
        for (int i = 0; i < cubeTags.func_74745_c(); ++i) {
            NBTTagCompound cubeCompound = cubeTags.func_150305_b(i);
            SpectreCube cube = new SpectreCube(this);
            cube.readFromNBT(cubeCompound);
            this.cubes.put(cube.getOwner(), cube);
        }
        this.positionCounter = nbt.func_74762_e("positionCounter");
    }

    public NBTTagCompound func_189551_b(NBTTagCompound nbt) {
        NBTTagList cubeTags = new NBTTagList();
        for (SpectreCube cube : this.cubes.values()) {
            NBTTagCompound cubeCompound = new NBTTagCompound();
            cube.writeToNBT(cubeCompound);
            cubeTags.func_74742_a((NBTBase)cubeCompound);
        }
        nbt.func_74782_a("cubes", (NBTBase)cubeTags);
        nbt.func_74768_a("positionCounter", this.positionCounter);
        return nbt;
    }

    public static SpectreHandler getInstance() {
        WorldServer world = DimensionManager.getWorld((int)ModDimensions.SPECTRE_ID);
        if (world != null) {
            WorldSavedData handler = world.getPerWorldStorage().func_75742_a(SpectreHandler.class, ID);
            if (handler == null) {
                handler = new SpectreHandler();
                world.getPerWorldStorage().func_75745_a(ID, handler);
            }
            return (SpectreHandler)handler;
        }
        return null;
    }

    public static void reset() {
        WorldServer world = DimensionManager.getWorld((int)ModDimensions.SPECTRE_ID);
        if (world != null) {
            world.func_175693_T().func_75745_a(ID, (WorldSavedData)new SpectreHandler());
        }
    }

    public void teleportPlayerBack(EntityPlayerMP player) {
        NBTTagCompound compound = player.getEntityData();
        if (compound.func_74764_b("spectrePosX")) {
            double spectrePosX = compound.func_74769_h("spectrePosX");
            double spectrePosY = compound.func_74769_h("spectrePosY");
            double spectrePosZ = compound.func_74769_h("spectrePosZ");
            int spectreDimension = compound.func_74762_e("spectreDimension");
            player.field_70165_t = spectrePosX;
            player.field_70163_u = spectrePosY;
            player.field_70161_v = spectrePosZ;
            if (player.field_71093_bK != spectreDimension) {
                PlayerUtil.teleportPlayerToDimension(player, spectreDimension);
            }
            player.field_71135_a.func_147364_a(spectrePosX, spectrePosY, spectrePosZ, player.field_70177_z, player.field_70125_A);
            while (!player.field_70170_p.func_184144_a((Entity)player, player.func_174813_aQ()).isEmpty() && player.field_70163_u < 256.0) {
                player.func_70107_b(player.field_70165_t, player.field_70163_u + 1.0, player.field_70161_v);
            }
            PlayerUtil.capturePosition(player.field_71135_a);
        } else {
            FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_72368_a(player, player.field_71093_bK, true);
        }
    }

    public void checkPosition(EntityPlayerMP player) {
        SpectreCube cube = this.getSpectreCubeFromPos(player.field_70170_p, player.func_180425_c());
        if (!(player.field_71075_bZ.field_75098_d || cube != null && cube.getOwner().equals(player.func_146103_bH().getId()))) {
            SpectreCube playerCube = this.cubes.get(player.func_146103_bH().getId());
            if (playerCube != null) {
                BlockPos spawn = playerCube.getSpawnBlock();
                player.field_71135_a.func_147364_a((double)spawn.func_177958_n() + 0.5, (double)(spawn.func_177956_o() + 1), (double)spawn.func_177952_p() + 0.5, player.field_70177_z, player.field_70125_A);
            } else {
                this.teleportPlayerBack(player);
            }
        }
    }

    public World getWorld() {
        return this.worldObj;
    }
}

