/*
 * Decompiled with CFR 0.152.
 */
package lumien.randomthings.item;

import java.util.List;
import java.util.Optional;
import lumien.randomthings.entitys.EntityTimeAccelerator;
import lumien.randomthings.item.ItemBase;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemTimeInABottle
extends ItemBase {
    public ItemTimeInABottle() {
        super("timeInABottle");
        this.func_77625_d(1);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        NBTTagCompound timeData = stack.func_190925_c("timeData");
        int storedTime = timeData.func_74762_e("storedTime");
        int storedSeconds = storedTime / 20;
        int hours = storedSeconds / 3600;
        int minutes = storedSeconds % 3600 / 60;
        int seconds = storedSeconds % 60;
        tooltip.add(I18n.func_135052_a((String)"tooltip.timeInABottle", (Object[])new Object[]{hours, minutes, seconds}));
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return !ItemStack.func_179545_c((ItemStack)oldStack, (ItemStack)newStack);
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        if (!worldIn.field_72995_K) {
            NBTTagCompound timeData;
            if (worldIn.func_82737_E() % 20L == 0L && (timeData = stack.func_190925_c("timeData")).func_74762_e("storedTime") < 622080000) {
                timeData.func_74768_a("storedTime", timeData.func_74762_e("storedTime") + 20);
            }
            if (worldIn.func_82737_E() % 60L == 0L && entityIn instanceof EntityPlayer) {
                EntityPlayer player = (EntityPlayer)entityIn;
                for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
                    int theirTime;
                    ItemStack invStack = player.field_71071_by.func_70301_a(i);
                    if (invStack.func_77973_b() != this || invStack == stack) continue;
                    NBTTagCompound otherTimeData = invStack.func_190925_c("timeData");
                    NBTTagCompound myTimeData = stack.func_190925_c("timeData");
                    int myTime = myTimeData.func_74762_e("storedTime");
                    if (myTime >= (theirTime = otherTimeData.func_74762_e("storedTime"))) continue;
                    myTimeData.func_74768_a("storedTime", 0);
                }
            }
        }
    }

    public EnumActionResult onItemUseFirst(EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand) {
        if (!world.field_72995_K) {
            ItemStack me = player.func_184586_b(hand);
            Optional o = world.func_72872_a(EntityTimeAccelerator.class, new AxisAlignedBB(pos).func_186664_h(0.2)).stream().findFirst();
            if (o.isPresent()) {
                EntityTimeAccelerator eta = (EntityTimeAccelerator)((Object)o.get());
                int currentRate = eta.getTimeRate();
                int usedUpTime = 600 - eta.getRemainingTime();
                if (currentRate < 32) {
                    int nextRate = currentRate * 2;
                    int timeRequired = nextRate / 2 * 20 * 30;
                    NBTTagCompound timeData = me.func_179543_a("timeData");
                    int timeAvailable = timeData.func_74762_e("storedTime");
                    if (timeAvailable >= timeRequired || player.field_71075_bZ.field_75098_d) {
                        int timeAdded = (nextRate * usedUpTime - currentRate * usedUpTime) / nextRate;
                        if (!player.field_71075_bZ.field_75098_d) {
                            timeData.func_74768_a("storedTime", timeAvailable - timeRequired);
                        }
                        eta.setTimeRate(nextRate);
                        eta.setRemainingTime(eta.getRemainingTime() + timeAdded);
                        return EnumActionResult.SUCCESS;
                    }
                }
            } else {
                NBTTagCompound timeData = me.func_179543_a("timeData");
                int timeAvailable = timeData.func_74762_e("storedTime");
                if (timeAvailable >= 600 || player.field_71075_bZ.field_75098_d) {
                    if (!player.field_71075_bZ.field_75098_d) {
                        timeData.func_74768_a("storedTime", timeAvailable - 600);
                    }
                    EntityTimeAccelerator n = new EntityTimeAccelerator(world, pos, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5);
                    n.setTimeRate(1);
                    n.setRemainingTime(600);
                    world.func_72838_d((Entity)n);
                    return EnumActionResult.SUCCESS;
                }
            }
        }
        return EnumActionResult.SUCCESS;
    }
}

