/*
 * Decompiled with CFR 0.152.
 */
package lumien.randomthings.network.messages;

import io.netty.buffer.ByteBuf;
import lumien.randomthings.network.IRTMessage;
import lumien.randomthings.network.MessageUtil;
import lumien.randomthings.tileentity.TileEntityNotificationInterface;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;

public class MessageNotificationInterface
implements IRTMessage {
    String newTitle;
    String newDescription;
    BlockPos tePos;

    public MessageNotificationInterface(String newTitle, String newDescription, BlockPos tePos) {
        this.newTitle = newTitle;
        this.newDescription = newDescription;
        this.tePos = tePos;
    }

    public MessageNotificationInterface() {
    }

    public void fromBytes(ByteBuf buf) {
        this.newTitle = ByteBufUtils.readUTF8String((ByteBuf)buf);
        this.newDescription = ByteBufUtils.readUTF8String((ByteBuf)buf);
        this.tePos = MessageUtil.readBlockPos(buf);
    }

    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.newTitle);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.newDescription);
        MessageUtil.writeBlockPos(this.tePos, buf);
    }

    @Override
    public void onMessage(MessageContext context) {
        TileEntity te;
        World world = context.getServerHandler().field_147369_b.field_70170_p;
        if (world != null && (te = world.func_175625_s(this.tePos)) instanceof TileEntityNotificationInterface) {
            TileEntityNotificationInterface notInterface = (TileEntityNotificationInterface)te;
            notInterface.setData(this.newTitle, this.newDescription);
        }
    }

    @Override
    public Side getHandlingSide() {
        return Side.SERVER;
    }
}

