/*
 * Decompiled with CFR 0.152.
 */
package lumien.randomthings.tileentity.redstoneinterface;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.WeakHashMap;
import lumien.randomthings.tileentity.TileEntityBase;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public abstract class TileEntityRedstoneInterface
extends TileEntityBase
implements ITickable {
    public static Set<TileEntityRedstoneInterface> interfaces = Collections.newSetFromMap(new WeakHashMap());
    public static Object lock = new Object();
    HashMap<EnumFacing, Integer> weakPower;
    HashMap<EnumFacing, Integer> strongPower;
    boolean firstTick = true;
    static HashSet<BlockPos> checkedWeakPositions = new HashSet();
    static HashSet<BlockPos> checkedStrongPositions = new HashSet();
    static HashSet<BlockPos> notifiedPositions = new HashSet();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TileEntityRedstoneInterface() {
        EnumFacing[] enumFacingArray = lock;
        synchronized (lock) {
            interfaces.add(this);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            this.weakPower = new HashMap();
            this.strongPower = new HashMap();
            for (EnumFacing facing : EnumFacing.values()) {
                this.strongPower.put(facing, -1);
            }
            for (EnumFacing facing : EnumFacing.values()) {
                this.weakPower.put(facing, -1);
            }
            return;
        }
    }

    public void func_73660_a() {
        if (this.firstTick) {
            this.firstTick = false;
            if (this.weakPower.get(EnumFacing.DOWN) == -1) {
                this.updateRedstoneState(Blocks.field_150451_bX);
            }
        }
    }

    public void onChunkUnload() {
        this.func_145843_s();
    }

    @Override
    public void writeDataToNBT(NBTTagCompound compound, boolean sync) {
        NBTTagCompound weakPowerCompound = new NBTTagCompound();
        NBTTagCompound strongPowerCompound = new NBTTagCompound();
        for (EnumFacing facing : EnumFacing.values()) {
            weakPowerCompound.func_74768_a(facing.ordinal() + "", this.weakPower.get(facing).intValue());
            strongPowerCompound.func_74768_a(facing.ordinal() + "", this.strongPower.get(facing).intValue());
        }
        compound.func_74782_a("weakPowerCompound", (NBTBase)weakPowerCompound);
        compound.func_74782_a("strongPowerCompound", (NBTBase)strongPowerCompound);
    }

    @Override
    public void readDataFromNBT(NBTTagCompound compound, boolean sync) {
        NBTTagCompound weakPowerCompound = compound.func_74775_l("weakPowerCompound");
        NBTTagCompound strongPowerCompound = compound.func_74775_l("strongPowerCompound");
        for (EnumFacing facing : EnumFacing.values()) {
            this.weakPower.put(facing, weakPowerCompound.func_74762_e(facing.ordinal() + ""));
            this.strongPower.put(facing, strongPowerCompound.func_74762_e(facing.ordinal() + ""));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getRedstonePower(World blockWorld, BlockPos pos, EnumFacing facing) {
        Object object = lock;
        synchronized (object) {
            if (checkedWeakPositions.contains(pos)) {
                return 0;
            }
            checkedWeakPositions.add(pos);
            int totalPower = 0;
            BlockPos checkingBlock = pos.func_177972_a(facing.func_176734_d());
            for (TileEntityRedstoneInterface redstoneInterface : interfaces) {
                if (redstoneInterface.func_145837_r() || redstoneInterface.field_145850_b != blockWorld || !redstoneInterface.isTargeting(checkingBlock)) continue;
                int remotePower = redstoneInterface.weakPower.get(facing);
                checkedWeakPositions.remove(pos);
                if (remotePower <= totalPower) continue;
                totalPower = remotePower;
            }
            checkedWeakPositions.remove(pos);
            return totalPower;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getStrongPower(World blockWorld, BlockPos pos, EnumFacing facing) {
        Object object = lock;
        synchronized (object) {
            if (checkedStrongPositions.contains(pos)) {
                return 0;
            }
            checkedStrongPositions.add(pos);
            int totalPower = 0;
            BlockPos checkingBlock = pos.func_177972_a(facing.func_176734_d());
            for (TileEntityRedstoneInterface redstoneInterface : interfaces) {
                if (redstoneInterface.func_145837_r() || redstoneInterface.field_145850_b != blockWorld || !redstoneInterface.isTargeting(checkingBlock)) continue;
                int remotePower = redstoneInterface.strongPower.get(facing);
                checkedStrongPositions.remove(pos);
                if (remotePower <= totalPower) continue;
                totalPower = remotePower;
            }
            checkedStrongPositions.remove(pos);
            return totalPower;
        }
    }

    protected abstract void notifyTargets(Block var1);

    @Override
    public void neighborChanged(IBlockState state, World worldIn, BlockPos pos, Block neighborBlock, BlockPos changedPos) {
        if (notifiedPositions.contains(this.field_174879_c)) {
            return;
        }
        notifiedPositions.add(this.field_174879_c);
        this.updateRedstoneState(neighborBlock);
        notifiedPositions.remove(this.field_174879_c);
    }

    private void updateRedstoneState(Block neighbor) {
        boolean changed = false;
        for (EnumFacing facing : EnumFacing.values()) {
            int oldStrong = this.strongPower.get(facing);
            int newStrong = this.field_145850_b.func_175627_a(this.field_174879_c.func_177972_a(facing), facing);
            this.strongPower.put(facing, newStrong);
            if (oldStrong != newStrong) {
                changed = true;
            }
            int oldWeak = this.weakPower.get(facing);
            int newWeak = this.field_145850_b.func_175651_c(this.field_174879_c.func_177972_a(facing), facing);
            this.weakPower.put(facing, newWeak);
            if (oldWeak == newWeak) continue;
            changed = true;
        }
        if (changed) {
            this.notifyTargets(neighbor);
        }
    }

    @Override
    public void breakBlock(World worldIn, BlockPos pos, IBlockState state) {
        super.breakBlock(worldIn, pos, state);
        this.func_145843_s();
        this.notifyTargets(Blocks.field_150451_bX);
    }

    protected abstract boolean isTargeting(BlockPos var1);
}

