/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.blocks.renderer;

import java.util.Random;
import net.malisis.blocks.MalisisBlocksSettings;
import net.malisis.blocks.ProxyAccess;
import net.malisis.blocks.tileentity.VanishingTileEntity;
import net.malisis.core.block.MalisisBlock;
import net.malisis.core.renderer.MalisisRenderer;
import net.malisis.core.renderer.RenderParameters;
import net.malisis.core.renderer.RenderType;
import net.malisis.core.renderer.element.Shape;
import net.malisis.core.renderer.element.shape.Cube;
import net.malisis.core.util.BlockPosUtils;
import net.malisis.core.util.TileEntityUtils;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.ForgeHooksClient;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL14;

public class VanishingBlockRenderer
extends MalisisRenderer<VanishingTileEntity> {
    private Shape cube = new Cube();
    public Random rand = new Random();

    public VanishingBlockRenderer() {
        this.registerFor(VanishingTileEntity.class);
    }

    public void render() {
        if (this.tileEntity == null) {
            return;
        }
        this.cube.resetState();
        if (this.renderType == RenderType.TILE_ENTITY) {
            this.renderVanishingTileEntity();
        }
        if (this.renderType == RenderType.BLOCK) {
            this.renderVanishingBlock();
        }
    }

    private void renderVanishingBlock() {
        if (((VanishingTileEntity)this.tileEntity).isPowered() || ((VanishingTileEntity)this.tileEntity).isInTransition() || ((VanishingTileEntity)this.tileEntity).isVibrating()) {
            return;
        }
        ((VanishingTileEntity)this.tileEntity).blockDrawn = true;
        if (((VanishingTileEntity)this.tileEntity).getCopiedState() == null) {
            if (VanishingBlockRenderer.getRenderLayer() == BlockRenderLayer.CUTOUT_MIPPED) {
                this.drawShape(this.cube);
            }
            return;
        }
        BlockRendererDispatcher blockRenderer = Minecraft.func_71410_x().func_175602_ab();
        try {
            if (((VanishingTileEntity)this.tileEntity).getCopiedState().func_177230_c().canRenderInLayer(this.blockState, VanishingBlockRenderer.getRenderLayer())) {
                if (((VanishingTileEntity)this.tileEntity).getCopiedState().func_177230_c() instanceof MalisisBlock) {
                    this.vertexDrawn |= blockRenderer.func_175018_a(((VanishingTileEntity)this.tileEntity).getCopiedState(), this.pos, ProxyAccess.get(this.world), this.buffer);
                } else {
                    IBlockState copiedState = ((VanishingTileEntity)this.tileEntity).getCopiedState().func_177230_c().getExtendedState(((VanishingTileEntity)this.tileEntity).getCopiedState(), ProxyAccess.get(this.world), this.pos);
                    IBakedModel model = blockRenderer.func_184389_a(((VanishingTileEntity)this.tileEntity).getCopiedState());
                    this.vertexDrawn |= blockRenderer.func_175019_b().func_178267_a(ProxyAccess.get(this.world), model, copiedState, this.pos, this.buffer, true);
                }
            }
        }
        catch (Exception e) {
            this.drawShape(this.cube);
        }
    }

    private void renderVanishingTileEntity() {
        this.tileEntity = (TileEntity)TileEntityUtils.getTileEntity(VanishingTileEntity.class, (IBlockAccess)this.world, (BlockPos)this.pos);
        if (this.tileEntity == null) {
            return;
        }
        this.enableBlending();
        float fx = 0.0f;
        float fy = 0.0f;
        float fz = 0.0f;
        float scale = (float)(((VanishingTileEntity)this.tileEntity).getDuration() - ((VanishingTileEntity)this.tileEntity).getTransitionTimer()) / (float)((VanishingTileEntity)this.tileEntity).getDuration();
        boolean rendered = ((VanishingTileEntity)this.tileEntity).getCopiedState() != null;
        RenderParameters rp = new RenderParameters();
        rp.useBlockBounds.set((Object)false);
        rp.interpolateUV.set((Object)false);
        if (((VanishingTileEntity)this.tileEntity).isVibrating()) {
            rp.alpha.set((Object)200);
            fx = this.rand.nextFloat() * 0.05f;
            fy = this.rand.nextFloat() * 0.05f;
            fz = this.rand.nextFloat() * 0.05f;
            if (this.rand.nextBoolean()) {
                GL11.glTranslated((double)fx, (double)fy, (double)fz);
            } else {
                GL11.glRotatef((float)this.rand.nextInt(5), (float)1.0f, (float)1.0f, (float)1.0f);
            }
        } else if (((VanishingTileEntity)this.tileEntity).isInTransition()) {
            int alpha = ((VanishingTileEntity)this.tileEntity).getCopiedState() != null ? 255 - (int)(scale * 255.0f) : (int)(scale * 255.0f);
            rp.alpha.set((Object)alpha);
            this.cube.scale(scale - 0.001f);
        } else if (((VanishingTileEntity)this.tileEntity).blockDrawn) {
            return;
        }
        if (((VanishingTileEntity)this.tileEntity).getCopiedState() == null) {
            this.drawShape(this.cube, rp);
            return;
        }
        this.next(DefaultVertexFormats.field_176600_a);
        BlockRendererDispatcher blockRenderer = Minecraft.func_71410_x().func_175602_ab();
        try {
            boolean smbr = (Boolean)MalisisBlocksSettings.simpleMixedBlockRendering.get();
            MalisisBlocksSettings.simpleMixedBlockRendering.set((Object)true);
            BlockPos translate = BlockPosUtils.chunkPosition((BlockPos)this.pos);
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)0.5f, (float)0.5f, (float)0.5f);
            GlStateManager.func_179152_a((float)scale, (float)scale, (float)scale);
            if (((VanishingTileEntity)this.tileEntity).getCopiedState().func_177230_c() instanceof MalisisBlock) {
                GlStateManager.func_179109_b((float)(-translate.func_177958_n()), (float)(-translate.func_177956_o()), (float)(-translate.func_177952_p()));
            } else {
                GlStateManager.func_179109_b((float)(-this.pos.func_177958_n()), (float)(-this.pos.func_177956_o()), (float)(-this.pos.func_177952_p()));
            }
            GlStateManager.func_179109_b((float)-0.5f, (float)-0.5f, (float)-0.5f);
            GL11.glBlendFunc((int)32771, (int)32772);
            GL14.glBlendColor((float)0.0f, (float)0.0f, (float)0.0f, (float)scale);
            for (BlockRenderLayer layer : BlockRenderLayer.values()) {
                if (!((VanishingTileEntity)this.tileEntity).getCopiedState().func_177230_c().canRenderInLayer(this.blockState, layer)) continue;
                ForgeHooksClient.setRenderLayer((BlockRenderLayer)layer);
                if (layer == BlockRenderLayer.TRANSLUCENT) {
                    GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
                }
                if (((VanishingTileEntity)this.tileEntity).getCopiedState().func_177230_c() instanceof MalisisBlock) {
                    rendered |= blockRenderer.func_175018_a(((VanishingTileEntity)this.tileEntity).getCopiedState(), this.pos, ProxyAccess.get(this.world), this.buffer);
                } else {
                    IBlockState copiedState = ((VanishingTileEntity)this.tileEntity).getCopiedState().func_177230_c().getExtendedState(((VanishingTileEntity)this.tileEntity).getCopiedState(), ProxyAccess.get(this.world), this.pos);
                    IBakedModel model = blockRenderer.func_184389_a(((VanishingTileEntity)this.tileEntity).getCopiedState());
                    this.vertexDrawn |= blockRenderer.func_175019_b().func_178267_a(ProxyAccess.get(this.world), model, copiedState, this.pos, this.buffer, false);
                }
                this.next();
            }
            ForgeHooksClient.setRenderLayer(null);
            if (!rendered) {
                this.drawShape(this.cube, rp);
            }
            GlStateManager.func_179121_F();
            if (((VanishingTileEntity)this.tileEntity).getCopiedTileEntity() != null) {
                TileEntity te = ((VanishingTileEntity)this.tileEntity).getCopiedTileEntity();
                this.clean();
                TileEntityRendererDispatcher.field_147556_a.func_180546_a(te, this.partialTick, 0);
            }
            MalisisBlocksSettings.simpleMixedBlockRendering.set((Object)smbr);
        }
        catch (Exception e) {
            System.out.println("Fail to render " + ((VanishingTileEntity)this.tileEntity).getCopiedState());
            e.printStackTrace();
            this.drawShape(this.cube, rp);
        }
    }
}

