/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.planets.asteroids.blocks;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import micdoodle8.mods.galacticraft.api.block.IDetectableResource;
import micdoodle8.mods.galacticraft.api.block.IPlantableBlock;
import micdoodle8.mods.galacticraft.api.block.ITerraformableBlock;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.blocks.ISortableBlock;
import micdoodle8.mods.galacticraft.core.util.EnumSortCategoryBlock;
import micdoodle8.mods.galacticraft.planets.asteroids.items.AsteroidsItems;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockBasicAsteroids
extends Block
implements IDetectableResource,
IPlantableBlock,
ITerraformableBlock,
ISortableBlock {
    public static final PropertyEnum<EnumBlockBasic> BASIC_TYPE = PropertyEnum.func_177709_a((String)"basictypeasteroids", EnumBlockBasic.class);

    public BlockBasicAsteroids(String assetName) {
        super(Material.field_151576_e);
        this.field_149782_v = 3.0f;
        this.func_149663_c(assetName);
    }

    @SideOnly(value=Side.CLIENT)
    public CreativeTabs func_149708_J() {
        return GalacticraftCore.galacticraftBlocksTab;
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        if (state.func_177229_b(BASIC_TYPE) == EnumBlockBasic.ORE_ILMENITE && world instanceof World) {
            int i;
            ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
            int count = this.quantityDropped(state, fortune, ((World)world).field_73012_v);
            for (i = 0; i < count; ++i) {
                ret.add(new ItemStack(AsteroidsItems.basicItem, 1, 3));
            }
            count = this.quantityDropped(state, fortune, ((World)world).field_73012_v);
            for (i = 0; i < count; ++i) {
                ret.add(new ItemStack(AsteroidsItems.basicItem, 1, 4));
            }
            return ret;
        }
        return super.getDrops(world, pos, state, fortune);
    }

    public int func_180651_a(IBlockState state) {
        switch (this.func_176201_c(state)) {
            case 4: {
                return 0;
            }
        }
        return this.func_176201_c(state);
    }

    public int quantityDropped(IBlockState state, int fortune, Random random) {
        switch (this.func_176201_c(state)) {
            case 4: {
                if (fortune < 1) break;
                return random.nextFloat() < (float)fortune * 0.29f - 0.25f ? 2 : 1;
            }
        }
        return 1;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        for (int var4 = 0; var4 < EnumBlockBasic.values().length; ++var4) {
            list.add((Object)new ItemStack((Block)this, 1, var4));
        }
    }

    public boolean isValueable(IBlockState state) {
        switch (this.func_176201_c(state)) {
            case 3: 
            case 4: 
            case 5: {
                return true;
            }
        }
        return false;
    }

    public boolean canSustainPlant(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing direction, IPlantable plantable) {
        return false;
    }

    public int requiredLiquidBlocksNearby() {
        return 4;
    }

    public boolean isPlantable(IBlockState state) {
        return false;
    }

    public boolean isTerraformable(World world, BlockPos pos) {
        return false;
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        if (this.func_176201_c(state) == 4) {
            return new ItemStack(Item.func_150898_a((Block)this), 1, this.func_176201_c(state));
        }
        return super.getPickBlock(state, target, world, pos, player);
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(BASIC_TYPE, (Comparable)((Object)EnumBlockBasic.byMetadata(meta)));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumBlockBasic)((Object)state.func_177229_b(BASIC_TYPE))).getMeta();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{BASIC_TYPE});
    }

    public EnumSortCategoryBlock getCategory(int meta) {
        switch (meta) {
            case 3: 
            case 4: 
            case 5: {
                return EnumSortCategoryBlock.ORE;
            }
            case 6: {
                return EnumSortCategoryBlock.DECORATION;
            }
            case 7: {
                return EnumSortCategoryBlock.INGOT_BLOCK;
            }
        }
        return EnumSortCategoryBlock.GENERAL;
    }

    public int getExpDrop(IBlockState state, IBlockAccess world, BlockPos pos, int fortune) {
        if (state.func_177230_c() != this) {
            return 0;
        }
        int meta = this.func_176201_c(state);
        if (meta == 4) {
            Random rand = world instanceof World ? ((World)world).field_73012_v : new Random();
            return MathHelper.func_76136_a((Random)rand, (int)2, (int)3);
        }
        return 0;
    }

    public static enum EnumBlockBasic implements IStringSerializable
    {
        ASTEROID_0(0, "asteroid_rock_0"),
        ASTEROID_1(1, "asteroid_rock_1"),
        ASTEROID_2(2, "asteroid_rock_2"),
        ORE_ALUMINUM(3, "ore_aluminum_asteroids"),
        ORE_ILMENITE(4, "ore_ilmenite_asteroids"),
        ORE_IRON(5, "ore_iron_asteroids"),
        DECO(6, "asteroid_deco"),
        TITANIUM_BLOCK(7, "titanium_block");

        private final int meta;
        private final String name;

        private EnumBlockBasic(int meta, String name) {
            this.meta = meta;
            this.name = name;
        }

        public int getMeta() {
            return this.meta;
        }

        public static EnumBlockBasic byMetadata(int meta) {
            return EnumBlockBasic.values()[meta];
        }

        public String func_176610_l() {
            return this.name;
        }
    }
}

