/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.shared;

import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMapperBase;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fluids.Fluid;
import slimeknights.tconstruct.common.ClientProxy;
import slimeknights.tconstruct.library.Util;
import slimeknights.tconstruct.shared.TinkerFluids;

public class FluidsClientProxy
extends ClientProxy {
    @Override
    public void registerModels() {
        super.registerModels();
        this.registerFluidModels(TinkerFluids.searedStone);
        this.registerFluidModels(TinkerFluids.obsidian);
        this.registerFluidModels(TinkerFluids.clay);
        this.registerFluidModels(TinkerFluids.dirt);
        this.registerFluidModels(TinkerFluids.gold);
        this.registerFluidModels(TinkerFluids.emerald);
        this.registerFluidModels(TinkerFluids.glass);
        this.registerFluidModels(TinkerFluids.milk);
        this.registerFluidModels(TinkerFluids.blueslime);
        this.registerFluidModels(TinkerFluids.purpleSlime);
        this.registerFluidModels(TinkerFluids.blood);
    }

    @Override
    public void registerFluidModels(Fluid fluid) {
        if (fluid == null) {
            return;
        }
        Block block = fluid.getBlock();
        if (block != null) {
            Item item = Item.func_150898_a((Block)block);
            FluidStateMapper mapper = new FluidStateMapper(fluid);
            if (item != Items.field_190931_a) {
                ModelLoader.registerItemVariants((Item)item, (ResourceLocation[])new ResourceLocation[0]);
                ModelLoader.setCustomMeshDefinition((Item)item, (ItemMeshDefinition)mapper);
            }
            ModelLoader.setCustomStateMapper((Block)block, (IStateMapper)mapper);
        }
    }

    public static class FluidStateMapper
    extends StateMapperBase
    implements ItemMeshDefinition {
        public final Fluid fluid;
        public final ModelResourceLocation location;

        public FluidStateMapper(Fluid fluid) {
            this.fluid = fluid;
            this.location = new ModelResourceLocation(Util.getResource("fluid_block"), fluid.getName());
        }

        @Nonnull
        protected ModelResourceLocation func_178132_a(@Nonnull IBlockState state) {
            return this.location;
        }

        @Nonnull
        public ModelResourceLocation func_178113_a(@Nonnull ItemStack stack) {
            return this.location;
        }
    }
}

