/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modifiers;

import com.mojang.authlib.GameProfile;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntityWitherSkeleton;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.EnumHand;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import slimeknights.tconstruct.library.Util;
import slimeknights.tconstruct.library.capability.projectile.CapabilityTinkerProjectile;
import slimeknights.tconstruct.library.capability.projectile.ITinkerProjectile;
import slimeknights.tconstruct.library.modifiers.ModifierAspect;
import slimeknights.tconstruct.library.modifiers.ModifierNBT;
import slimeknights.tconstruct.library.utils.TagUtil;
import slimeknights.tconstruct.library.utils.TinkerUtil;
import slimeknights.tconstruct.tools.modifiers.ToolModifier;

public class ModBeheading
extends ToolModifier {
    private static String BEHEADING_ID = "beheading";
    private static String CLEAVER_MODIFIER_ID = BEHEADING_ID + "_cleaver";
    private static int BEHEADING_COLOR = 1070923;
    public static ModBeheading CLEAVER_BEHEADING_MOD = new ModBeheadingCleaver();

    public ModBeheading() {
        this("beheading");
        this.addAspects(ModifierAspect.freeModifier);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    ModBeheading(String traitBeheading) {
        super(traitBeheading, BEHEADING_COLOR);
        this.addAspects(new ModifierAspect.LevelAspect(this, 10), new ModifierAspect.DataAspect(this));
    }

    @Override
    public void applyEffect(NBTTagCompound rootCompound, NBTTagCompound modifierTag) {
        NBTTagCompound tag = TinkerUtil.getModifierTag(rootCompound, CLEAVER_MODIFIER_ID);
        if (!tag.func_82582_d()) {
            if (!modifierTag.func_74767_n("absorbedCleaver")) {
                ModifierNBT data = ModifierNBT.readTag(modifierTag);
                data.level += ModifierNBT.readTag((NBTTagCompound)tag).level;
                data.write(modifierTag);
                modifierTag.func_74757_a("absorbedCleaver", true);
            }
            NBTTagList tagList = TagUtil.getModifiersTagList(rootCompound);
            int index = TinkerUtil.getIndexInCompoundList(tagList, CLEAVER_MODIFIER_ID);
            tagList.func_74744_a(index);
            TagUtil.setModifiersTagList(rootCompound, tagList);
        }
    }

    @SubscribeEvent
    public void onLivingDrops(LivingDropsEvent event) {
        if (event.getSource().func_76346_g() instanceof EntityPlayer) {
            ItemStack head;
            ItemStack item = CapabilityTinkerProjectile.getTinkerProjectile(event.getSource()).map(ITinkerProjectile::getItemStack).orElse(((EntityPlayer)event.getSource().func_76346_g()).func_184586_b(EnumHand.MAIN_HAND));
            NBTTagCompound tag = TinkerUtil.getModifierTag(item, this.getIdentifier());
            int level = ModifierNBT.readTag((NBTTagCompound)tag).level;
            if (level == 0) {
                tag = TinkerUtil.getModifierTag(item, CLEAVER_MODIFIER_ID);
                level = ModifierNBT.readTag((NBTTagCompound)tag).level;
            }
            if (level > 0 && (head = this.getHeadDrop(event.getEntityLiving())) != null && !head.func_190926_b() && level > random.nextInt(10) && !this.alreadyContainsDrop(event, head)) {
                EntityItem entityitem = new EntityItem(event.getEntityLiving().func_130014_f_(), event.getEntityLiving().field_70165_t, event.getEntityLiving().field_70163_u, event.getEntityLiving().field_70161_v, head);
                entityitem.func_174869_p();
                event.getDrops().add(entityitem);
            }
        }
    }

    private boolean alreadyContainsDrop(LivingDropsEvent event, ItemStack head) {
        return event.getDrops().stream().map(EntityItem::func_92059_d).anyMatch(drop -> ItemStack.func_77989_b((ItemStack)drop, (ItemStack)head));
    }

    private ItemStack getHeadDrop(EntityLivingBase entity) {
        if (entity instanceof EntitySkeleton) {
            return new ItemStack(Items.field_151144_bL, 1, 0);
        }
        if (entity instanceof EntityWitherSkeleton) {
            return new ItemStack(Items.field_151144_bL, 1, 1);
        }
        if (entity instanceof EntityZombie) {
            return new ItemStack(Items.field_151144_bL, 1, 2);
        }
        if (entity instanceof EntityCreeper) {
            return new ItemStack(Items.field_151144_bL, 1, 4);
        }
        if (entity instanceof EntityPlayer) {
            ItemStack head = new ItemStack(Items.field_151144_bL, 1, 3);
            NBTUtil.func_180708_a((NBTTagCompound)head.func_190925_c("SkullOwner"), (GameProfile)((EntityPlayer)entity).func_146103_bH());
            return head;
        }
        return null;
    }

    private static class ModBeheadingCleaver
    extends ModBeheading {
        public ModBeheadingCleaver() {
            super(CLEAVER_MODIFIER_ID);
        }

        @Override
        public void applyEffect(NBTTagCompound rootCompound, NBTTagCompound modifierTag) {
        }

        @Override
        public String getLocalizedDesc() {
            return Util.translate("modifier.%s.desc", BEHEADING_ID);
        }

        @Override
        public String getLocalizedName() {
            return Util.translate("modifier.%s.name", BEHEADING_ID);
        }
    }
}

