/*
 * Decompiled with CFR 0.152.
 */
package c4.conarm.lib.materials;

import c4.conarm.lib.materials.ArmorMaterialType;
import c4.conarm.lib.materials.CoreMaterialStats;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import slimeknights.tconstruct.library.Util;
import slimeknights.tconstruct.library.client.CustomFontColor;
import slimeknights.tconstruct.library.materials.AbstractMaterialStats;

public class PlatesMaterialStats
extends AbstractMaterialStats {
    public static final String LOC_Durability = "stat.plates.durability.name";
    public static final String LOC_Modifier = "stat.plates.modifier.name";
    public static final String LOC_Toughness = "stat.plates.toughness.name";
    public static final String LOC_DurabilityDesc = "stat.plates.durability.desc";
    public static final String LOC_ModifierDesc = "stat.plates.modifier.desc";
    public static final String LOC_ToughnessDesc = "stat.plates.toughness.desc";
    public static final String COLOR_Durability = CoreMaterialStats.COLOR_Durability;
    public static final String COLOR_Modifier = CustomFontColor.encodeColor((int)185, (int)185, (int)90);
    public static final String COLOR_Toughness = CustomFontColor.encodeColor((int)120, (int)160, (int)205);
    public final float durability;
    public final float modifier;
    public final float toughness;

    public PlatesMaterialStats(float modifier, float durability, float toughness) {
        super(ArmorMaterialType.PLATES);
        this.durability = durability;
        this.modifier = modifier;
        this.toughness = toughness;
    }

    public List<String> getLocalizedInfo() {
        ArrayList info = Lists.newArrayList();
        info.add(PlatesMaterialStats.formatModifier(this.modifier));
        info.add(PlatesMaterialStats.formatDurability(this.durability));
        info.add(PlatesMaterialStats.formatToughness(this.toughness));
        return info;
    }

    public List<String> getLocalizedDesc() {
        ArrayList info = Lists.newArrayList();
        info.add(Util.translate((String)LOC_ModifierDesc, (Object[])new Object[0]));
        info.add(Util.translate((String)LOC_DurabilityDesc, (Object[])new Object[0]));
        info.add(Util.translate((String)LOC_ToughnessDesc, (Object[])new Object[0]));
        return info;
    }

    public static String formatToughness(float toughness) {
        return PlatesMaterialStats.formatNumber((String)LOC_Toughness, (String)COLOR_Toughness, (float)toughness);
    }

    public static String formatModifier(float quality) {
        return PlatesMaterialStats.formatNumber((String)LOC_Modifier, (String)COLOR_Modifier, (float)quality);
    }

    public static String formatDurability(float durability) {
        return PlatesMaterialStats.formatNumber((String)LOC_Durability, (String)COLOR_Durability, (float)durability);
    }
}

