/*
 * Decompiled with CFR 0.152.
 */
package gcewing.sg;

import gcewing.sg.BaseBlockUtils;
import gcewing.sg.SGBaseTE;
import gcewing.sg.Trans3;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufOutputStream;
import java.io.DataInput;
import java.io.DataOutput;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;

public class IrisEntity
extends Entity
implements IEntityAdditionalSpawnData {
    BlockPos blockPos;

    public IrisEntity(World world) {
        super(world);
    }

    public IrisEntity(SGBaseTE te) {
        this(te.func_145831_w());
        double radius = 2.0;
        double thickness = 0.2;
        double cx = 0.0;
        double cy = 2.0;
        double cz = 0.1;
        double hx = radius;
        double hy = radius;
        double hz = thickness;
        AxisAlignedBB localBox = new AxisAlignedBB(cx - hx, cy - hy, cz - hz, cx + hx, cy + hy, cz + hz);
        Trans3 t = te.localToGlobalTransformation();
        AxisAlignedBB globalBox = t.t(localBox);
        this.init(te.func_174877_v(), globalBox);
    }

    void init(BlockPos pos, AxisAlignedBB box) {
        this.blockPos = pos;
        this.func_70107_b(box.field_72340_a, box.field_72338_b, box.field_72339_c);
        this.func_174826_a(box);
    }

    protected void func_70088_a() {
    }

    SGBaseTE getBaseTE() {
        TileEntity te = this.field_70170_p.func_175625_s(this.blockPos);
        if (te instanceof SGBaseTE) {
            return (SGBaseTE)te;
        }
        return null;
    }

    public boolean func_70067_L() {
        SGBaseTE te = this.getBaseTE();
        boolean result = te != null ? te.irisIsClosed() : false;
        return result;
    }

    public AxisAlignedBB func_70046_E() {
        if (this.func_70067_L()) {
            return super.func_174813_aQ();
        }
        return null;
    }

    public boolean func_70104_M() {
        return false;
    }

    public void func_70037_a(NBTTagCompound nbt) {
        int blockX = nbt.func_74762_e("blockX");
        int blockY = nbt.func_74762_e("blockY");
        int blockZ = nbt.func_74762_e("blockZ");
        BlockPos pos = new BlockPos(blockX, blockY, blockZ);
        double minX = nbt.func_74769_h("minX");
        double minY = nbt.func_74769_h("minY");
        double minZ = nbt.func_74769_h("minZ");
        double maxX = nbt.func_74769_h("maxX");
        double maxY = nbt.func_74769_h("maxY");
        double maxZ = nbt.func_74769_h("maxZ");
        AxisAlignedBB box = new AxisAlignedBB(minX, minY, minZ, maxX, maxY, maxZ);
        this.init(pos, box);
    }

    public void func_70014_b(NBTTagCompound nbt) {
        nbt.func_74768_a("blockX", this.blockPos.func_177958_n());
        nbt.func_74768_a("blockY", this.blockPos.func_177956_o());
        nbt.func_74768_a("blockZ", this.blockPos.func_177952_p());
        AxisAlignedBB box = super.func_174813_aQ();
        nbt.func_74780_a("minX", box.field_72340_a);
        nbt.func_74780_a("minY", box.field_72338_b);
        nbt.func_74780_a("minZ", box.field_72339_c);
        nbt.func_74780_a("maxX", box.field_72336_d);
        nbt.func_74780_a("maxY", box.field_72337_e);
        nbt.func_74780_a("maxZ", box.field_72334_f);
    }

    protected boolean func_142008_O() {
        return false;
    }

    public void writeSpawnData(ByteBuf buffer) {
        try {
            ByteBufOutputStream data = new ByteBufOutputStream(buffer);
            BaseBlockUtils.writeBlockPos((DataOutput)data, this.blockPos);
            AxisAlignedBB box = super.func_174813_aQ();
            data.writeDouble(box.field_72340_a);
            data.writeDouble(box.field_72338_b);
            data.writeDouble(box.field_72339_c);
            data.writeDouble(box.field_72336_d);
            data.writeDouble(box.field_72337_e);
            data.writeDouble(box.field_72334_f);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void readSpawnData(ByteBuf buffer) {
        try {
            ByteBufInputStream data = new ByteBufInputStream(buffer);
            BlockPos pos = BaseBlockUtils.readBlockPos((DataInput)data);
            double minX = data.readDouble();
            double minY = data.readDouble();
            double minZ = data.readDouble();
            double maxX = data.readDouble();
            double maxY = data.readDouble();
            double maxZ = data.readDouble();
            AxisAlignedBB box = new AxisAlignedBB(minX, minY, minZ, maxX, maxY, maxZ);
            this.init(pos, box);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

