/*
 * Decompiled with CFR 0.152.
 */
package galaxyspace.core.client.gui.book.pages.bodies;

import asmodeuscore.api.IBookPage;
import asmodeuscore.core.utils.BookUtils;
import java.util.LinkedList;
import java.util.List;
import micdoodle8.mods.galacticraft.api.galaxies.CelestialBody;
import micdoodle8.mods.galacticraft.api.galaxies.GalaxyRegistry;
import micdoodle8.mods.galacticraft.api.galaxies.Moon;
import micdoodle8.mods.galacticraft.api.galaxies.Planet;
import micdoodle8.mods.galacticraft.api.galaxies.SolarSystem;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.util.ResourceLocation;

public class Page_Systems
implements IBookPage {
    private static ResourceLocation bookPageTexture = new ResourceLocation("galaxyspace", "textures/gui/tablet.png");
    private static ResourceLocation starTexture = new ResourceLocation("galaxyspace", "textures/gui/book/star_bg.png");
    private static Mode current_mode = Mode.LIST;
    private static List<CelestialBody> planets = new LinkedList<CelestialBody>();
    private Minecraft mc = Minecraft.func_71410_x();
    private int scroll = 0;
    private int maxscroll = 4;
    private int maxX = 0;
    private CelestialBody selected_body;
    private Moon selected_moon;
    private SolarSystem system;

    public Page_Systems(SolarSystem system) {
        this.system = system;
    }

    public String title() {
        return this.system.getUnlocalizedName();
    }

    public ResourceLocation iconTitle() {
        return this.system.getMainStar().getBodyIcon();
    }

    public void text(int x, int y, FontRenderer font, int mouseX, int mouseY) {
        if (current_mode == Mode.LIST) {
            planets.clear();
            for (Object planet : GalaxyRegistry.getPlanetsForSolarSystem((SolarSystem)this.system)) {
                planets.add((CelestialBody)planet);
            }
            int posY = 0;
            for (CelestialBody s : planets) {
                int currX = font.func_78256_a(s.getLocalizedName());
                this.maxX = this.maxX < currX ? currX : this.maxX;
            }
            int offsetX = 21;
            for (int i = this.scroll; i < planets.size(); ++i) {
                if (i >= 8 + this.scroll) continue;
                int yOffset = i - this.scroll;
                this.mc.func_110434_K().func_110577_a(bookPageTexture);
                posY = 0;
                if (mouseX >= x + 44 && mouseX < x + 40 + 25 + this.maxX && mouseY >= y + 41 + offsetX * yOffset && mouseY <= y + 41 + offsetX * yOffset + 16) {
                    posY = 17;
                }
                this.mc.func_110434_K().func_110577_a(bookPageTexture);
                this.drawTexturedModalRect(x + 20, y + 41 + offsetX * yOffset, 21.0f, 21.0f, 461.0f, 35.0f, 18.0f, 21.0f, false, false, 512.0f, 256.0f);
                this.mc.func_110434_K().func_110577_a(planets.get(i).getBodyIcon());
                this.drawTexturedModalRect(x + 25, y + 45 + offsetX * yOffset, 12.0f, 12.0f, 0.0f, 0.0f, 16.0f, 16.0f, false, false, 16.0f, 16.0f);
                this.mc.func_110434_K().func_110577_a(bookPageTexture);
                this.drawTexturedModalRect(x + 40, y + 41 + offsetX * yOffset, 25.0f, 16.0f, 400.0f, posY, 20.0f, 15.0f, false, false, 512.0f, 256.0f);
                this.drawTexturedModalRect(x + 40 + 16, y + 41 + offsetX * yOffset, this.maxX, 16.0f, 410.0f, posY, 70.0f, 15.0f, false, false, 512.0f, 256.0f);
                this.drawTexturedModalRect(x + 40 + this.maxX, y + 41 + offsetX * yOffset, 25.0f, 16.0f, 467.0f, posY, 20.0f, 15.0f, false, false, 512.0f, 256.0f);
                font.func_78276_b(planets.get(i).getLocalizedName(), x + 52, y + 46 + offsetX * yOffset, 0xFFFFFF);
            }
            if (planets.size() > 8) {
                this.mc.func_110434_K().func_110577_a(bookPageTexture);
                this.drawTexturedModalRect(x + 417, y + 36, 17.0f, 186.0f, 492.0f, 0.0f, 14.0f, 185.0f, false, false, 512.0f, 256.0f);
                this.drawTexturedModalRect(x + 417, y + 36, 17.0f, 28.0f, 400.0f, 68.0f, 15.0f, 28.0f, false, false, 512.0f, 256.0f);
                int pos = Math.round(116 / this.maxscroll);
                this.drawTexturedModalRect(x + 420, y + 58 + this.scroll * pos, 15.0f, 28.0f, 429.0f, 68.0f, 14.0f, 28.0f, false, false, 512.0f, 256.0f);
                this.drawTexturedModalRect(x + 419, y + 194, 16.0f, 28.0f, 400.0f, 68.0f, 14.0f, 28.0f, true, true, 512.0f, 256.0f);
            }
            this.mc.func_110434_K().func_110577_a(starTexture);
            this.drawTexturedModalRect(x + 150, y + 45, 60.0f, 60.0f, 0.0f, 0.0f, 256.0f, 256.0f, false, false, 256.0f, 256.0f);
            this.mc.func_110434_K().func_110577_a(this.system.getMainStar().getBodyIcon());
            this.drawTexturedModalRect(x + 150 + 30 - 6, y + 45 + 30 - 6, 12.0f, 12.0f, 0.0f, 0.0f, 16.0f, 16.0f, false, false, 16.0f, 16.0f);
            font.func_78276_b(GCCoreUtil.translate((String)("book.page." + this.system.getMainStar().getUnlocalizedName())), x + 220, y + 45, 0xFFFFFF);
        } else if (current_mode == Mode.BODY) {
            int offsetX = 0;
            int posY = 17;
            int i = 1;
            this.mc.func_110434_K().func_110577_a(bookPageTexture);
            this.drawTexturedModalRect(x + 20, y + 41 + offsetX, 21.0f, 21.0f, 461.0f, 35.0f, 18.0f, 21.0f, false, false, 512.0f, 256.0f);
            this.mc.func_110434_K().func_110577_a(this.selected_body.getBodyIcon());
            this.drawTexturedModalRect(x + 25, y + 45 + offsetX, 12.0f, 12.0f, 0.0f, 0.0f, 16.0f, 16.0f, false, false, 16.0f, 16.0f);
            this.mc.func_110434_K().func_110577_a(bookPageTexture);
            this.drawTexturedModalRect(x + 40, y + 41 + offsetX, 25.0f, 16.0f, 400.0f, posY, 20.0f, 15.0f, false, false, 512.0f, 256.0f);
            this.drawTexturedModalRect(x + 40 + 16, y + 41 + offsetX, this.maxX, 16.0f, 410.0f, posY, 70.0f, 15.0f, false, false, 512.0f, 256.0f);
            this.drawTexturedModalRect(x + 40 + this.maxX, y + 41 + offsetX, 25.0f, 16.0f, 467.0f, posY, 20.0f, 15.0f, false, false, 512.0f, 256.0f);
            font.func_78276_b(this.selected_body.getLocalizedName(), x + 52, y + 46 + offsetX, 0xFFFFFF);
            if (this.selected_body instanceof Planet) {
                offsetX = 21;
                for (Moon moon : GalaxyRegistry.getMoonsForPlanet((Planet)((Planet)this.selected_body))) {
                    posY = 0;
                    if (mouseX >= x + 44 && mouseX < x + 40 + 25 + this.maxX && mouseY >= y + 41 + offsetX * i && mouseY <= y + 41 + offsetX * i + 16) {
                        posY = 17;
                    }
                    this.mc.func_110434_K().func_110577_a(bookPageTexture);
                    this.drawTexturedModalRect(x + 20, y + 41 + offsetX * i, 21.0f, 21.0f, 461.0f, 35.0f, 18.0f, 21.0f, false, false, 512.0f, 256.0f);
                    this.mc.func_110434_K().func_110577_a(moon.getBodyIcon());
                    this.drawTexturedModalRect(x + 25, y + 45 + offsetX * i, 12.0f, 12.0f, 0.0f, 0.0f, 16.0f, 16.0f, false, false, 16.0f, 16.0f);
                    this.mc.func_110434_K().func_110577_a(bookPageTexture);
                    this.drawTexturedModalRect(x + 40, y + 41 + offsetX * i, 25.0f, 16.0f, 400.0f, posY, 20.0f, 15.0f, false, false, 512.0f, 256.0f);
                    this.drawTexturedModalRect(x + 40 + 16, y + 41 + offsetX * i, this.maxX, 16.0f, 410.0f, posY, 70.0f, 15.0f, false, false, 512.0f, 256.0f);
                    this.drawTexturedModalRect(x + 40 + this.maxX, y + 41 + offsetX * i, 25.0f, 16.0f, 467.0f, posY, 20.0f, 15.0f, false, false, 512.0f, 256.0f);
                    font.func_78279_b(moon.getLocalizedName(), x + 52, y + 46 + offsetX * i, 260, 0xFFFFFF);
                    ++i;
                }
            }
            if (this.selected_body != null) {
                font.func_78279_b(GCCoreUtil.translate((String)("book.page.solarsystem." + this.selected_body.getName().toLowerCase())), x + 152, y + 46, 260, 0xFFFFFF);
            }
        } else if (current_mode == Mode.MOON) {
            this.mc.func_110434_K().func_110577_a(bookPageTexture);
            this.drawTexturedModalRect(x + 20, y + 41, 21.0f, 21.0f, 461.0f, 35.0f, 18.0f, 21.0f, false, false, 512.0f, 256.0f);
            this.mc.func_110434_K().func_110577_a(this.selected_moon.getBodyIcon());
            this.drawTexturedModalRect(x + 25, y + 45, 12.0f, 12.0f, 0.0f, 0.0f, 16.0f, 16.0f, false, false, 16.0f, 16.0f);
            this.mc.func_110434_K().func_110577_a(bookPageTexture);
            this.drawTexturedModalRect(x + 40, y + 41, 25.0f, 16.0f, 400.0f, 17.0f, 20.0f, 15.0f, false, false, 512.0f, 256.0f);
            this.drawTexturedModalRect(x + 40 + 16, y + 41, this.maxX, 16.0f, 410.0f, 17.0f, 70.0f, 15.0f, false, false, 512.0f, 256.0f);
            this.drawTexturedModalRect(x + 40 + this.maxX, y + 41, 25.0f, 16.0f, 467.0f, 17.0f, 20.0f, 15.0f, false, false, 512.0f, 256.0f);
            font.func_78276_b(this.selected_moon.getLocalizedName(), x + 52, y + 46, 0xFFFFFF);
            if (this.selected_moon != null) {
                font.func_78276_b(GCCoreUtil.translate((String)("book.page.solarsystem." + this.selected_moon.getName().toLowerCase())), x + 152, y + 46, 0xFFFFFF);
            }
        }
    }

    public void mouseClick(int mouseX, int mouseY, int mouseButton, int x, int y) {
        block5: {
            int offsetX;
            block4: {
                if (this.checkClick(mouseX, mouseY, x + 420, y + 40, 10, 15) && this.scroll > 0) {
                    --this.scroll;
                }
                if (this.checkClick(mouseX, mouseY, x + 420, y + 198, 10, 20) && this.scroll < this.maxscroll) {
                    ++this.scroll;
                }
                offsetX = 21;
                if (current_mode != Mode.LIST) break block4;
                for (int i = this.scroll; i < planets.size(); ++i) {
                    if (i >= 8 + this.scroll) continue;
                    int yOffset = i - this.scroll;
                    if (mouseX < x + 44 || mouseX >= x + 40 + 25 + this.maxX || mouseY < y + 41 + offsetX * yOffset || mouseY > y + 41 + offsetX * yOffset + 16) continue;
                    this.selected_body = planets.get(i);
                    current_mode = Mode.BODY;
                }
                break block5;
            }
            if (current_mode != Mode.BODY) break block5;
            for (int i = 1; i < GalaxyRegistry.getMoonsForPlanet((Planet)((Planet)this.selected_body)).size() + 1; ++i) {
                if (mouseX < x + 44 || mouseX >= x + 40 + 25 + this.maxX || mouseY < y + 41 + offsetX * i || mouseY > y + 41 + offsetX * i + 16) continue;
                this.selected_moon = (Moon)GalaxyRegistry.getMoonsForPlanet((Planet)((Planet)this.selected_body)).get(i - 1);
                current_mode = Mode.MOON;
            }
        }
    }

    public boolean hookBackButton() {
        if (current_mode == Mode.BODY) {
            current_mode = Mode.LIST;
            return true;
        }
        if (current_mode == Mode.MOON) {
            current_mode = Mode.BODY;
            return true;
        }
        return false;
    }

    private boolean checkClick(int mouseX, int mouseY, int x, int y, int sizeX, int sizeY) {
        return mouseX >= x && mouseX <= x + sizeX && mouseY >= y && mouseY <= y + sizeY;
    }

    public String getCategory() {
        return BookUtils.Book_Cateroies.BODIES.getName();
    }

    static enum Mode {
        LIST,
        BODY,
        MOON;

    }
}

