/*
 * Decompiled with CFR 0.152.
 */
package galaxyspace.core.network.packet;

import galaxyspace.GalaxySpace;
import galaxyspace.api.tile.ITileEffects;
import galaxyspace.core.events.GSEventHandler;
import galaxyspace.core.util.GSUtils;
import galaxyspace.systems.SolarSystem.planets.overworld.items.armor.ItemSpaceSuit;
import galaxyspace.systems.SolarSystem.planets.overworld.tile.TileEntityGravitationModule;
import galaxyspace.systems.SolarSystem.planets.overworld.tile.TileEntityLiquidSeparator;
import galaxyspace.systems.SolarSystem.planets.overworld.tile.TileEntityModificationTable;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import micdoodle8.mods.galacticraft.api.vector.BlockVec3;
import micdoodle8.mods.galacticraft.core.entities.player.GCPlayerStats;
import micdoodle8.mods.galacticraft.core.entities.player.GCPlayerStatsClient;
import micdoodle8.mods.galacticraft.core.network.NetworkUtil;
import micdoodle8.mods.galacticraft.core.network.PacketBase;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import micdoodle8.mods.galacticraft.core.util.GCLog;
import micdoodle8.mods.galacticraft.core.util.PlayerUtil;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.network.INetHandler;
import net.minecraft.network.Packet;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class GSPacketSimple
extends PacketBase
implements Packet<INetHandler> {
    private GSEnumSimplePacket type;
    private List<Object> data;
    private static String spamCheckString;

    public GSPacketSimple() {
    }

    public GSPacketSimple(GSEnumSimplePacket packetType, int dimID, Object ... data) {
        this(packetType, dimID, Arrays.asList(data));
    }

    public GSPacketSimple(GSEnumSimplePacket packetType, World world, Object[] data) {
        this(packetType, GCCoreUtil.getDimensionID((World)world), Arrays.asList(data));
    }

    public GSPacketSimple(GSEnumSimplePacket packetType, int dimID, List<Object> data) {
        super(dimID);
        if (packetType.getDecodeClasses().length != data.size()) {
            GCLog.info((String)"Simple Packet Core found data length different than packet type");
            new RuntimeException().printStackTrace();
        }
        this.type = packetType;
        this.data = data;
    }

    public void encodeInto(ByteBuf buffer) {
        super.encodeInto(buffer);
        buffer.writeInt(this.type.ordinal());
        try {
            NetworkUtil.encodeData((ByteBuf)buffer, this.data);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void decodeInto(ByteBuf buffer) {
        super.decodeInto(buffer);
        this.type = GSEnumSimplePacket.values()[buffer.readInt()];
        try {
            if (this.type.getDecodeClasses().length > 0) {
                this.data = NetworkUtil.decodeData((Class[])this.type.getDecodeClasses(), (ByteBuf)buffer);
            }
            if (buffer.readableBytes() > 0) {
                GCLog.severe((String)("Galacticraft packet length problem for packet type " + this.type.toString()));
            }
        }
        catch (Exception e) {
            System.err.println("[Galacticraft] Error handling simple packet type: " + this.type.toString() + " " + buffer.toString());
            e.printStackTrace();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void handleClientSide(EntityPlayer player) {
        EntityPlayerSP playerBaseClient = null;
        GCPlayerStatsClient stats = null;
        if (player instanceof EntityPlayerSP) {
            playerBaseClient = (EntityPlayerSP)player;
            stats = GCPlayerStatsClient.get((Entity)playerBaseClient);
        }
        switch (this.type) {
            default: 
        }
    }

    public void handleServerSide(EntityPlayer player) {
        EntityPlayerMP playerBase = PlayerUtil.getPlayerBaseServerFromPlayer((EntityPlayer)player, (boolean)false);
        if (playerBase == null) {
            return;
        }
        GCPlayerStats stats = GCPlayerStats.get((Entity)playerBase);
        switch (this.type) {
            case S_CHANGE_FLIGHT_STATE: {
                boolean state = (Boolean)this.data.get(0);
                GSEventHandler.enableFlight(player, state);
                break;
            }
            case S_GRAVITY_RADIUS: {
                BlockVec3 pos = (BlockVec3)this.data.get(0);
                int strength = (Integer)this.data.get(1);
                TileEntity tileEntity = pos.getTileEntity((IBlockAccess)playerBase.field_70170_p);
                if (!(tileEntity instanceof TileEntityGravitationModule)) break;
                ((TileEntityGravitationModule)tileEntity).setGravityRadius(strength);
                tileEntity.func_70296_d();
                break;
            }
            case S_ON_ADVANCED_GUI_CLICKED_INT: {
                TileEntity tile1 = player.field_70170_p.func_175625_s(new BlockPos(((Integer)this.data.get(1)).intValue(), ((Integer)this.data.get(2)).intValue(), ((Integer)this.data.get(3)).intValue()));
                switch ((Integer)this.data.get(0)) {
                    case 6: {
                        if (!(tile1 instanceof ITileEffects)) break;
                        ITileEffects distributor = (ITileEffects)tile1;
                        distributor.setEffectsVisible((Integer)this.data.get(4) == 1);
                    }
                }
                break;
            }
            case S_REVERSE_SEPATATOR: {
                BlockVec3 posSep = (BlockVec3)this.data.get(0);
                TileEntity tileEntity = posSep.getTileEntity((IBlockAccess)playerBase.field_70170_p);
                if (!(tileEntity instanceof TileEntityLiquidSeparator)) break;
                ((TileEntityLiquidSeparator)tileEntity).setReverse(!((TileEntityLiquidSeparator)tileEntity).getReverse());
                tileEntity.func_70296_d();
                playerBase.field_70170_p.func_184138_a(tileEntity.func_174877_v(), tileEntity.func_145838_q().func_176223_P(), tileEntity.func_145838_q().func_176223_P(), 0);
                break;
            }
            case S_UPDATE_NBT_ITEM_ON_GUI: {
                ItemStack[] copied;
                BlockVec3 position = (BlockVec3)this.data.get(0);
                String tag = (String)this.data.get(1);
                boolean turn = (Boolean)this.data.get(2);
                boolean consumed = false;
                TileEntity tileEntity = position.getTileEntity((IBlockAccess)playerBase.field_70170_p);
                if (!(tileEntity instanceof TileEntityModificationTable)) break;
                ItemStack[] stack = ((TileEntityModificationTable)tileEntity).func_70301_a(0);
                boolean check = true;
                for (GSUtils.SpaceSuit_Modules s : GSUtils.SpaceSuit_Modules.values()) {
                    if (!s.getName().equals(tag)) continue;
                    for (String list : s.getForbiddenModules()) {
                        if (!stack.func_77978_p().func_74764_b(list)) continue;
                        check = false;
                    }
                }
                if (turn) {
                    if (!check || stack.func_77978_p().func_74762_e(ItemSpaceSuit.mod_count) <= 0) break;
                    for (Object con : GSUtils.getItemsForModules(tag)) {
                        if (!GSEventHandler.consumeItemStack((IInventory)playerBase.field_71071_by, con)) continue;
                        consumed = true;
                    }
                    if (!consumed && !playerBase.field_71075_bZ.field_75098_d) break;
                    copied = stack;
                    copied.func_77978_p().func_74757_a(tag, true);
                    copied.func_77978_p().func_74768_a(ItemSpaceSuit.mod_count, copied.func_77978_p().func_74762_e(ItemSpaceSuit.mod_count) - 1);
                    ((TileEntityModificationTable)tileEntity).func_70299_a(0, (ItemStack)copied);
                    tileEntity.func_70296_d();
                    playerBase.field_70170_p.func_175684_a(tileEntity.func_174877_v(), tileEntity.func_145838_q(), 0);
                    break;
                }
                if (!playerBase.field_71075_bZ.field_75098_d) {
                    for (Object con : GSUtils.getItemsForModules(tag)) {
                        playerBase.func_191521_c(con);
                    }
                }
                copied = stack;
                copied.func_77978_p().func_82580_o(tag);
                copied.func_77978_p().func_74768_a(ItemSpaceSuit.mod_count, copied.func_77978_p().func_74762_e(ItemSpaceSuit.mod_count) + 1);
                ((TileEntityModificationTable)tileEntity).func_70299_a(0, (ItemStack)copied);
                tileEntity.func_70296_d();
                playerBase.field_70170_p.func_175684_a(tileEntity.func_174877_v(), tileEntity.func_145838_q(), 0);
                break;
            }
            case S_UPDATE_NBT_ITEM_IN_ARMOR: {
                int armor_slot = (Integer)this.data.get(0);
                String tag = (String)this.data.get(1);
                ItemStack armor = (ItemStack)playerBase.field_71071_by.field_70460_b.get(armor_slot);
                if (armor == ItemStack.field_190927_a || !(armor.func_77973_b() instanceof ItemSpaceSuit)) break;
                ItemStack copied = armor;
                copied.func_77978_p().func_74757_a(tag, !copied.func_77978_p().func_74767_n(tag));
                playerBase.field_71071_by.field_70460_b.set(armor_slot, (Object)copied);
                GalaxySpace.debug(copied.func_77978_p().toString());
                break;
            }
        }
    }

    public void func_148837_a(PacketBuffer var1) {
        this.decodeInto((ByteBuf)var1);
    }

    public void func_148840_b(PacketBuffer var1) {
        this.encodeInto((ByteBuf)var1);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_148833_a(INetHandler var1) {
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
            this.handleClientSide((EntityPlayer)FMLClientHandler.instance().getClientPlayerEntity());
        }
    }

    public static enum GSEnumSimplePacket {
        S_GRAVITY_RADIUS(Side.SERVER, BlockVec3.class, Integer.class),
        S_ON_ADVANCED_GUI_CLICKED_INT(Side.SERVER, Integer.class, Integer.class, Integer.class, Integer.class, Integer.class),
        S_CHANGE_FLIGHT_STATE(Side.SERVER, Boolean.class),
        S_REVERSE_SEPATATOR(Side.SERVER, BlockVec3.class),
        S_UPDATE_NBT_ITEM_ON_GUI(Side.SERVER, BlockVec3.class, String.class, Boolean.class),
        S_UPDATE_NBT_ITEM_IN_ARMOR(Side.SERVER, Integer.class, String.class);

        private Side targetSide;
        private Class<?>[] decodeAs;

        private GSEnumSimplePacket(Side targetSide, Class<?> ... decodeAs) {
            this.targetSide = targetSide;
            this.decodeAs = decodeAs;
        }

        public Side getTargetSide() {
            return this.targetSide;
        }

        public Class<?>[] getDecodeClasses() {
            return this.decodeAs;
        }
    }
}

