/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.advert.tileentity;

import java.util.Arrays;
import net.malisis.advert.advert.AdvertSelection;
import net.malisis.advert.model.ModelVariantContainer;
import net.malisis.core.block.IBoundingBox;
import net.malisis.core.util.TileEntityUtils;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;

public class AdvertTileEntity
extends TileEntity {
    protected ModelVariantContainer<?> container;
    protected boolean wallMounted;
    protected AdvertSelection[] selectedAdverts = new AdvertSelection[0];

    public AdvertTileEntity() {
        this.container = ModelVariantContainer.getDefaultContainer(false);
    }

    public ModelVariantContainer<?> getModelContainer() {
        return this.container;
    }

    public void setModelContainer(ModelVariantContainer<?> container) {
        if (container == null) {
            container = ModelVariantContainer.getDefaultContainer(this.isWallMounted());
        }
        this.container = container;
        this.selectedAdverts = Arrays.copyOf(this.selectedAdverts, container.getModel().getAvailableSlots());
        TileEntityUtils.notifyUpdate((TileEntity)this);
    }

    public void setWallMounted(boolean wallMounted) {
        this.wallMounted = wallMounted;
    }

    public boolean isWallMounted() {
        return this.wallMounted;
    }

    public int availableSlots() {
        return 1;
    }

    public int selectedAdverts() {
        int c = 0;
        for (AdvertSelection as : this.selectedAdverts) {
            if (as == null) continue;
            ++c;
        }
        return c;
    }

    public AdvertSelection getSelection(int index) {
        if (this.selectedAdverts.length == 0) {
            return null;
        }
        if (index < 0 || index >= this.container.getModel().getAvailableSlots()) {
            return null;
        }
        return this.selectedAdverts[index];
    }

    public AdvertSelection[] getSelections() {
        return this.selectedAdverts;
    }

    public void addSelections(AdvertSelection[] selections) {
        for (int i = 0; i < selections.length; ++i) {
            this.addSelection(i, selections[i]);
        }
    }

    public void addSelection(int index, AdvertSelection advertSelection) {
        if (index < 0 || index >= this.container.getModel().getAvailableSlots()) {
            return;
        }
        this.selectedAdverts[index] = advertSelection;
    }

    public void removeSelection(int index) {
        this.addSelection(index, null);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tagCompound) {
        super.func_189515_b(tagCompound);
        tagCompound.func_74757_a("wall_mounted", this.wallMounted);
        this.container.toNBT(this, tagCompound);
        NBTTagList asList = new NBTTagList();
        for (int i = 0; i < this.selectedAdverts.length; ++i) {
            if (this.selectedAdverts[i] == null) continue;
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74774_a("index", (byte)i);
            this.selectedAdverts[i].toNBT(tag);
            asList.func_74742_a((NBTBase)tag);
        }
        tagCompound.func_74782_a("selections", (NBTBase)asList);
        return tagCompound;
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.wallMounted = tagCompound.func_74767_n("wall_mounted");
        this.setModelContainer(ModelVariantContainer.fromNBT(this, tagCompound));
        NBTTagList nbttaglist = tagCompound.func_150295_c("selections", 10);
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            NBTTagCompound tag = nbttaglist.func_150305_b(i);
            this.addSelection(tag.func_74771_c("index"), AdvertSelection.fromNBT(tag));
        }
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound nbt = new NBTTagCompound();
        this.func_189515_b(nbt);
        return new SPacketUpdateTileEntity(this.field_174879_c, 0, nbt);
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet) {
        this.func_145839_a(packet.func_148857_g());
        TileEntityUtils.updateGui((TileEntity)this);
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return IBoundingBox.getRenderingBounds((IBlockAccess)this.field_145850_b, (BlockPos)this.field_174879_c);
    }
}

