/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.element;

import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiElement;
import mekanism.common.util.MekanismUtils;
import net.minecraft.util.ResourceLocation;

public class GuiSlot
extends GuiElement {
    protected int xLocation;
    protected int yLocation;
    protected int textureX;
    protected int textureY;
    protected int width;
    protected int height;
    protected SlotOverlay overlay = null;

    public GuiSlot(SlotType type, IGuiWrapper gui, ResourceLocation def, int x, int y) {
        super(MekanismUtils.getResource(MekanismUtils.ResourceType.GUI_ELEMENT, "GuiSlot.png"), gui, def);
        this.xLocation = x;
        this.yLocation = y;
        this.width = type.width;
        this.height = type.height;
        this.textureX = type.textureX;
        this.textureY = type.textureY;
    }

    public GuiSlot with(SlotOverlay overlay) {
        this.overlay = overlay;
        return this;
    }

    @Override
    public GuiElement.Rectangle4i getBounds(int guiWidth, int guiHeight) {
        return new GuiElement.Rectangle4i(guiWidth + this.xLocation, guiHeight + this.yLocation, this.width, this.height);
    }

    @Override
    public void renderBackground(int xAxis, int yAxis, int guiWidth, int guiHeight) {
        GuiSlot.mc.field_71446_o.func_110577_a(this.RESOURCE);
        this.guiObj.drawTexturedRect(guiWidth + this.xLocation, guiHeight + this.yLocation, this.textureX, this.textureY, this.width, this.height);
        if (this.overlay != null) {
            int w = this.overlay.width;
            int h = this.overlay.height;
            int xLocationOverlay = this.xLocation + (this.width - w) / 2;
            int yLocationOverlay = this.yLocation + (this.height - h) / 2;
            this.guiObj.drawTexturedRect(guiWidth + xLocationOverlay, guiHeight + yLocationOverlay, this.overlay.textureX, this.overlay.textureY, w, h);
        }
        GuiSlot.mc.field_71446_o.func_110577_a(this.defaultLocation);
    }

    @Override
    public void renderForeground(int xAxis, int yAxis) {
    }

    @Override
    public void preMouseClicked(int xAxis, int yAxis, int button) {
    }

    @Override
    public void mouseClicked(int xAxis, int yAxis, int button) {
    }

    public static enum SlotOverlay {
        MINUS(18, 18, 0, 18),
        PLUS(18, 18, 18, 18),
        POWER(18, 18, 36, 18),
        INPUT(18, 18, 54, 18),
        OUTPUT(18, 18, 72, 18),
        CHECK(18, 18, 0, 36);

        public int width;
        public int height;
        public int textureX;
        public int textureY;

        private SlotOverlay(int w, int h, int x, int y) {
            this.width = w;
            this.height = h;
            this.textureX = x;
            this.textureY = y;
        }
    }

    public static enum SlotType {
        NORMAL(18, 18, 0, 0),
        POWER(18, 18, 18, 0),
        INPUT(18, 18, 36, 0),
        EXTRA(18, 18, 54, 0),
        OUTPUT(18, 18, 72, 0),
        OUTPUT_LARGE(26, 26, 90, 0),
        OUTPUT_WIDE(42, 26, 116, 0);

        public int width;
        public int height;
        public int textureX;
        public int textureY;

        private SlotType(int w, int h, int x, int y) {
            this.width = w;
            this.height = h;
            this.textureX = x;
            this.textureY = y;
        }
    }
}

