/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration;

import appeng.api.AEApi;
import appeng.api.definitions.IBlocks;
import appeng.api.definitions.IItems;
import appeng.api.definitions.IMaterials;
import dan200.computercraft.api.ComputerCraftAPI;
import dan200.computercraft.api.peripheral.IPeripheralProvider;
import ic2.api.recipe.IRecipeInput;
import ic2.api.recipe.MachineRecipe;
import ic2.api.recipe.Recipes;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import li.cil.oc.api.Driver;
import li.cil.oc.api.driver.DriverBlock;
import mekanism.api.transmitters.TransmissionType;
import mekanism.common.Mekanism;
import mekanism.common.MekanismBlocks;
import mekanism.common.MekanismItems;
import mekanism.common.Resource;
import mekanism.common.block.states.BlockStateTransmitter;
import mekanism.common.integration.computer.CCPeripheral;
import mekanism.common.integration.computer.OCDriver;
import mekanism.common.integration.crafttweaker.CrafttweakerIntegration;
import mekanism.common.integration.wrenches.Wrenches;
import mekanism.common.recipe.RecipeHandler;
import mekanism.common.util.MekanismUtils;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.common.event.FMLInterModComms;

public final class MekanismHooks {
    public static final String COFH_CORE_MOD_ID = "cofhcore";
    public static final String COFH_API_MOD_ID = "cofhapi";
    public static final String IC2_MOD_ID = "ic2";
    public static final String RAILCRAFT_MOD_ID = "railcraft";
    public static final String THERMALEXPANSION_MOD_ID = "thermalexpansion";
    public static final String COMPUTERCRAFT_MOD_ID = "computercraft";
    public static final String APPLIED_ENERGISTICS_2_MOD_ID = "appliedenergistics2";
    public static final String TESLA_MOD_ID = "tesla";
    public static final String MCMULTIPART_MOD_ID = "mcmultipart";
    public static final String REDSTONEFLUX_MOD_ID = "redstoneflux";
    public static final String METALLURGY_3_CORE_MOD_ID = "Metallurgy3Core";
    public static final String METALLURGY_3_BASE_MOD_ID = "Metallurgy3Base";
    public static final String OPENCOMPUTERS_MOD_ID = "opencomputers";
    public static final String GALACTICRAFT_MOD_ID = "Galacticraft API";
    public static final String WAILA_MOD_ID = "Waila";
    public static final String BUILDCRAFT_MOD_ID = "BuildCraft";
    public boolean IC2Loaded = false;
    public boolean RailcraftLoaded = false;
    public boolean CoFHCoreLoaded = false;
    public boolean TELoaded = false;
    public boolean CCLoaded = false;
    public boolean AE2Loaded = false;
    public boolean TeslaLoaded = false;
    public boolean MCMPLoaded = false;
    public boolean RFLoaded = false;
    public boolean MetallurgyCoreLoaded = false;
    public boolean MetallurgyBaseLoaded = false;

    public void hook() {
        if (Loader.isModLoaded((String)COFH_CORE_MOD_ID)) {
            this.CoFHCoreLoaded = true;
        }
        if (Loader.isModLoaded((String)IC2_MOD_ID)) {
            this.IC2Loaded = true;
        }
        if (Loader.isModLoaded((String)RAILCRAFT_MOD_ID)) {
            this.RailcraftLoaded = true;
        }
        if (Loader.isModLoaded((String)THERMALEXPANSION_MOD_ID)) {
            this.TELoaded = true;
        }
        if (Loader.isModLoaded((String)COMPUTERCRAFT_MOD_ID)) {
            this.CCLoaded = true;
        }
        if (Loader.isModLoaded((String)APPLIED_ENERGISTICS_2_MOD_ID)) {
            this.AE2Loaded = true;
        }
        if (Loader.isModLoaded((String)TESLA_MOD_ID)) {
            this.TeslaLoaded = true;
        }
        if (Loader.isModLoaded((String)MCMULTIPART_MOD_ID)) {
            this.MCMPLoaded = true;
        }
        if (Loader.isModLoaded((String)REDSTONEFLUX_MOD_ID)) {
            this.RFLoaded = true;
        }
        if (Loader.isModLoaded((String)METALLURGY_3_CORE_MOD_ID)) {
            this.MetallurgyCoreLoaded = true;
            if (Loader.isModLoaded((String)METALLURGY_3_BASE_MOD_ID)) {
                this.MetallurgyBaseLoaded = true;
            }
        }
        if (this.IC2Loaded) {
            this.hookIC2Recipes();
            Mekanism.logger.info("Hooked into IC2 successfully.");
        }
        if (this.CCLoaded) {
            this.loadCCPeripheralProviders();
        }
        if (this.AE2Loaded) {
            this.registerAE2Recipes();
        }
        if (Loader.isModLoaded((String)"crafttweaker")) {
            CrafttweakerIntegration.applyRecipeChanges();
        }
        Wrenches.initialise();
    }

    @Optional.Method(modid="ic2")
    public void hookIC2Recipes() {
        block6: for (MachineRecipe entry : Recipes.macerator.getRecipes()) {
            if (((IRecipeInput)entry.getInput()).getInputs().isEmpty() || RecipeHandler.Recipe.CRUSHER.containsRecipe((ItemStack)((IRecipeInput)entry.getInput()).getInputs().get(0))) continue;
            List<String> names = MekanismUtils.getOreDictName((ItemStack)((IRecipeInput)entry.getInput()).getInputs().get(0));
            for (String name : names) {
                if (!name.startsWith("ingot") && !name.startsWith("crystal")) continue;
                RecipeHandler.addCrusherRecipe((ItemStack)((IRecipeInput)entry.getInput()).getInputs().get(0), (ItemStack)((Collection)entry.getOutput()).iterator().next());
                continue block6;
            }
        }
        try {
            Recipes.macerator.addRecipe(Recipes.inputFactory.forOreDict("oreOsmium"), null, false, new ItemStack[]{new ItemStack(MekanismItems.Dust, 2, Resource.OSMIUM.ordinal())});
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            Recipes.macerator.addRecipe(Recipes.inputFactory.forOreDict("ingotOsmium"), null, false, new ItemStack[]{new ItemStack(MekanismItems.Dust, 1, Resource.OSMIUM.ordinal())});
            Recipes.macerator.addRecipe(Recipes.inputFactory.forOreDict("ingotRefinedObsidian"), null, false, new ItemStack[]{new ItemStack(MekanismItems.OtherDust, 1, 5)});
            Recipes.macerator.addRecipe(Recipes.inputFactory.forOreDict("ingotRefinedGlowstone"), null, false, new ItemStack[]{new ItemStack(Items.field_151114_aO)});
            Recipes.macerator.addRecipe(Recipes.inputFactory.forOreDict("ingotSteel"), null, false, new ItemStack[]{new ItemStack(MekanismItems.OtherDust, 1, 1)});
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            for (Resource resource : Resource.values()) {
                Recipes.macerator.addRecipe(Recipes.inputFactory.forOreDict("clump" + resource.getName()), null, false, new ItemStack[]{new ItemStack(MekanismItems.DirtyDust, 1, resource.ordinal())});
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Optional.Method(modid="computercraft")
    public void loadCCPeripheralProviders() {
        try {
            ComputerCraftAPI.registerPeripheralProvider((IPeripheralProvider)new CCPeripheral.CCPeripheralProvider());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Optional.Method(modid="opencomputers")
    public void loadOCDrivers() {
        try {
            Driver.add((DriverBlock)new OCDriver());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void addPulverizerRecipe(ItemStack input, ItemStack output, int energy) {
        NBTTagCompound nbtTags = new NBTTagCompound();
        nbtTags.func_74768_a("energy", energy);
        nbtTags.func_74782_a("input", (NBTBase)input.func_77955_b(new NBTTagCompound()));
        nbtTags.func_74782_a("primaryOutput", (NBTBase)output.func_77955_b(new NBTTagCompound()));
        FMLInterModComms.sendMessage((String)"mekanism", (String)"PulverizerRecipe", (NBTTagCompound)nbtTags);
    }

    public void registerAE2P2P() {
        for (BlockStateTransmitter.TransmitterType type : BlockStateTransmitter.TransmitterType.values()) {
            if (type.getTransmission().equals((Object)TransmissionType.ITEM)) {
                FMLInterModComms.sendMessage((String)APPLIED_ENERGISTICS_2_MOD_ID, (String)"add-p2p-attunement-item", (ItemStack)new ItemStack(MekanismBlocks.Transmitter, 1, type.ordinal()));
                continue;
            }
            if (type.getTransmission().equals((Object)TransmissionType.FLUID)) {
                FMLInterModComms.sendMessage((String)APPLIED_ENERGISTICS_2_MOD_ID, (String)"add-p2p-attunement-fluid", (ItemStack)new ItemStack(MekanismBlocks.Transmitter, 1, type.ordinal()));
                continue;
            }
            if (!type.getTransmission().equals((Object)TransmissionType.ENERGY)) continue;
            FMLInterModComms.sendMessage((String)APPLIED_ENERGISTICS_2_MOD_ID, (String)"add-p2p-attunement-forge-power", (ItemStack)new ItemStack(MekanismBlocks.Transmitter, 1, type.ordinal()));
        }
    }

    public void registerAE2Recipes() {
        try {
            ItemStack crystalOut;
            IItems itemApi = AEApi.instance().definitions().items();
            IMaterials materialsApi = AEApi.instance().definitions().materials();
            IBlocks blocksApi = AEApi.instance().definitions().blocks();
            Optional certusCrystal = materialsApi.certusQuartzCrystal().maybeStack(1);
            Optional certusDust = materialsApi.certusQuartzDust().maybeStack(1);
            Optional pureCertus = materialsApi.purifiedCertusQuartzCrystal().maybeStack(1);
            Optional chargedCrystal = materialsApi.certusQuartzCrystalCharged().maybeStack(1);
            Optional fluixCrystal = materialsApi.fluixCrystal().maybeStack(1);
            Optional pureFluix = materialsApi.purifiedFluixCrystal().maybeStack(1);
            Optional fluixDust = materialsApi.fluixDust().maybeStack(1);
            Optional certusOre = blocksApi.quartzOre().maybeStack(1);
            Optional chargedOre = blocksApi.quartzOreCharged().maybeStack(1);
            Optional crystalSeed = itemApi.crystalSeed().maybeItem();
            Optional pureNether = materialsApi.purifiedNetherQuartzCrystal().maybeStack(1);
            if (certusCrystal.isPresent() && certusDust.isPresent()) {
                RecipeHandler.addCrusherRecipe(((ItemStack)certusCrystal.get()).func_77946_l(), ((ItemStack)certusDust.get()).func_77946_l());
            }
            if (chargedCrystal.isPresent() && certusDust.isPresent()) {
                RecipeHandler.addCrusherRecipe(((ItemStack)chargedCrystal.get()).func_77946_l(), ((ItemStack)certusDust.get()).func_77946_l());
            }
            if (fluixCrystal.isPresent() && fluixDust.isPresent()) {
                RecipeHandler.addCrusherRecipe(((ItemStack)fluixCrystal.get()).func_77946_l(), ((ItemStack)fluixDust.get()).func_77946_l());
            }
            if (certusOre.isPresent() && certusCrystal.isPresent()) {
                crystalOut = ((ItemStack)certusCrystal.get()).func_77946_l();
                crystalOut.func_190920_e(4);
                RecipeHandler.addEnrichmentChamberRecipe(((ItemStack)certusOre.get()).func_77946_l(), crystalOut);
            }
            if (chargedOre.isPresent() && chargedCrystal.isPresent()) {
                crystalOut = ((ItemStack)chargedCrystal.get()).func_77946_l();
                crystalOut.func_190920_e(4);
                RecipeHandler.addEnrichmentChamberRecipe(((ItemStack)chargedOre.get()).func_77946_l(), crystalOut);
            }
            if (certusDust.isPresent() && pureCertus.isPresent()) {
                crystalOut = ((ItemStack)pureCertus.get()).func_77946_l();
                RecipeHandler.addEnrichmentChamberRecipe(((ItemStack)certusDust.get()).func_77946_l(), crystalOut);
            }
            if (fluixDust.isPresent() && pureFluix.isPresent()) {
                crystalOut = ((ItemStack)pureFluix.get()).func_77946_l();
                RecipeHandler.addEnrichmentChamberRecipe(((ItemStack)fluixDust.get()).func_77946_l(), crystalOut);
            }
            if (fluixCrystal.isPresent() && pureFluix.isPresent()) {
                RecipeHandler.addEnrichmentChamberRecipe(((ItemStack)fluixCrystal.get()).func_77946_l(), ((ItemStack)pureFluix.get()).func_77946_l());
            }
            if (certusCrystal.isPresent() && pureCertus.isPresent()) {
                RecipeHandler.addEnrichmentChamberRecipe(((ItemStack)certusCrystal.get()).func_77946_l(), ((ItemStack)pureCertus.get()).func_77946_l());
            }
            if (crystalSeed.isPresent()) {
                NonNullList seeds = NonNullList.func_191196_a();
                ((Item)crystalSeed.get()).func_150895_a(CreativeTabs.field_78027_g, seeds);
                for (ItemStack stack : seeds) {
                    String unloc = ((Item)crystalSeed.get()).func_77667_c(stack);
                    if (unloc.endsWith("certus") && pureCertus.isPresent()) {
                        RecipeHandler.addEnrichmentChamberRecipe(stack, ((ItemStack)pureCertus.get()).func_77946_l());
                        continue;
                    }
                    if (unloc.endsWith("nether") && pureNether.isPresent()) {
                        RecipeHandler.addEnrichmentChamberRecipe(stack, ((ItemStack)pureNether.get()).func_77946_l());
                        continue;
                    }
                    if (!unloc.endsWith("fluix") || !pureFluix.isPresent()) continue;
                    RecipeHandler.addEnrichmentChamberRecipe(stack, ((ItemStack)pureFluix.get()).func_77946_l());
                }
            }
        }
        catch (Exception e) {
            Mekanism.logger.error("Something went wrong with ae2 integration", (Throwable)e);
        }
        catch (IncompatibleClassChangeError e) {
            Mekanism.logger.error("AE2 api has changed unexpectedly", (Throwable)e);
        }
    }
}

