/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.util;

import cofh.redstoneflux.api.IEnergyContainerItem;
import ic2.api.item.ElectricItem;
import ic2.api.item.IElectricItem;
import ic2.api.item.IElectricItemManager;
import ic2.api.item.ISpecialElectricItem;
import mekanism.api.energy.EnergizedItemManager;
import mekanism.api.energy.IEnergizedItem;
import mekanism.api.energy.IStrictEnergyStorage;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.config.MekanismConfig;
import mekanism.common.tile.prefab.TileEntityContainerBlock;
import mekanism.common.util.MekanismUtils;
import net.darkhax.tesla.api.ITeslaConsumer;
import net.darkhax.tesla.api.ITeslaProducer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public final class ChargeUtils {
    public static void discharge(int slotID, IStrictEnergyStorage storer) {
        TileEntityContainerBlock inv = (TileEntityContainerBlock)((Object)storer);
        ItemStack stack = inv.func_70301_a(slotID);
        if (!stack.func_190926_b() && storer.getEnergy() < storer.getMaxEnergy()) {
            if (stack.func_77973_b() instanceof IEnergizedItem) {
                storer.setEnergy(storer.getEnergy() + EnergizedItemManager.discharge(stack, storer.getMaxEnergy() - storer.getEnergy()));
            } else if (MekanismUtils.useTesla() && stack.hasCapability(Capabilities.TESLA_PRODUCER_CAPABILITY, null)) {
                ITeslaProducer producer = (ITeslaProducer)stack.getCapability(Capabilities.TESLA_PRODUCER_CAPABILITY, null);
                long needed = Math.round((storer.getMaxEnergy() - storer.getEnergy()) * MekanismConfig.general.TO_TESLA);
                storer.setEnergy(storer.getEnergy() + (double)producer.takePower(needed, false) * MekanismConfig.general.FROM_TESLA);
            } else if (MekanismUtils.useForge() && stack.hasCapability(CapabilityEnergy.ENERGY, null)) {
                IEnergyStorage storage = (IEnergyStorage)stack.getCapability(CapabilityEnergy.ENERGY, null);
                if (storage.canExtract()) {
                    int needed = (int)Math.round(Math.min(2.147483647E9, (storer.getMaxEnergy() - storer.getEnergy()) * MekanismConfig.general.TO_FORGE));
                    storer.setEnergy(storer.getEnergy() + (double)storage.extractEnergy(needed, false) * MekanismConfig.general.FROM_FORGE);
                }
            } else if (MekanismUtils.useRF() && stack.func_77973_b() instanceof IEnergyContainerItem) {
                IEnergyContainerItem item = (IEnergyContainerItem)stack.func_77973_b();
                int needed = (int)Math.round(Math.min(2.147483647E9, (storer.getMaxEnergy() - storer.getEnergy()) * MekanismConfig.general.TO_RF));
                storer.setEnergy(storer.getEnergy() + (double)item.extractEnergy(stack, needed, false) * MekanismConfig.general.FROM_RF);
            } else if (MekanismUtils.useIC2() && stack.func_77973_b() instanceof IElectricItem) {
                IElectricItem item = (IElectricItem)stack.func_77973_b();
                if (item.canProvideEnergy(stack)) {
                    double gain = ElectricItem.manager.discharge(stack, (storer.getMaxEnergy() - storer.getEnergy()) * MekanismConfig.general.TO_IC2, 4, true, true, false) * MekanismConfig.general.FROM_IC2;
                    storer.setEnergy(storer.getEnergy() + gain);
                }
            } else if (stack.func_77973_b() == Items.field_151137_ax && storer.getEnergy() + MekanismConfig.general.ENERGY_PER_REDSTONE <= storer.getMaxEnergy()) {
                storer.setEnergy(storer.getEnergy() + MekanismConfig.general.ENERGY_PER_REDSTONE);
                stack.func_190918_g(1);
            }
        }
    }

    public static void charge(int slotID, IStrictEnergyStorage storer) {
        TileEntityContainerBlock inv = (TileEntityContainerBlock)((Object)storer);
        ItemStack stack = inv.func_70301_a(slotID);
        if (!stack.func_190926_b() && storer.getEnergy() > 0.0) {
            if (stack.func_77973_b() instanceof IEnergizedItem) {
                storer.setEnergy(storer.getEnergy() - EnergizedItemManager.charge(stack, storer.getEnergy()));
            } else if (MekanismUtils.useTesla() && stack.hasCapability(Capabilities.TESLA_CONSUMER_CAPABILITY, null)) {
                ITeslaConsumer consumer = (ITeslaConsumer)stack.getCapability(Capabilities.TESLA_CONSUMER_CAPABILITY, null);
                long stored = Math.round(storer.getEnergy() * MekanismConfig.general.TO_TESLA);
                storer.setEnergy(storer.getEnergy() - (double)consumer.givePower(stored, false) * MekanismConfig.general.FROM_TESLA);
            } else if (MekanismUtils.useForge() && stack.hasCapability(CapabilityEnergy.ENERGY, null)) {
                IEnergyStorage storage = (IEnergyStorage)stack.getCapability(CapabilityEnergy.ENERGY, null);
                if (storage.canReceive()) {
                    int stored = (int)Math.round(Math.min(2.147483647E9, storer.getEnergy() * MekanismConfig.general.TO_FORGE));
                    storer.setEnergy(storer.getEnergy() - (double)storage.receiveEnergy(stored, false) * MekanismConfig.general.FROM_FORGE);
                }
            } else if (MekanismUtils.useRF() && stack.func_77973_b() instanceof IEnergyContainerItem) {
                IEnergyContainerItem item = (IEnergyContainerItem)stack.func_77973_b();
                int toTransfer = (int)Math.round(storer.getEnergy() * MekanismConfig.general.TO_RF);
                storer.setEnergy(storer.getEnergy() - (double)item.receiveEnergy(stack, toTransfer, false) * MekanismConfig.general.FROM_RF);
            } else if (MekanismUtils.useIC2() && stack.func_77973_b() instanceof IElectricItem) {
                double sent = ElectricItem.manager.charge(stack, storer.getEnergy() * MekanismConfig.general.TO_IC2, 4, true, false) * MekanismConfig.general.FROM_IC2;
                storer.setEnergy(storer.getEnergy() - sent);
            }
        }
    }

    public static boolean canBeDischarged(ItemStack itemstack) {
        return MekanismUtils.useIC2() && itemstack.func_77973_b() instanceof IElectricItem && ((IElectricItem)itemstack.func_77973_b()).canProvideEnergy(itemstack) || itemstack.func_77973_b() instanceof IEnergizedItem && ((IEnergizedItem)itemstack.func_77973_b()).canSend(itemstack) || MekanismUtils.useRF() && itemstack.func_77973_b() instanceof IEnergyContainerItem && ((IEnergyContainerItem)itemstack.func_77973_b()).extractEnergy(itemstack, 1, true) != 0 || MekanismUtils.useTesla() && itemstack.hasCapability(Capabilities.TESLA_PRODUCER_CAPABILITY, null) && ((ITeslaProducer)itemstack.getCapability(Capabilities.TESLA_PRODUCER_CAPABILITY, null)).takePower(1L, true) > 0L || MekanismUtils.useForge() && itemstack.hasCapability(CapabilityEnergy.ENERGY, null) && ((IEnergyStorage)itemstack.getCapability(CapabilityEnergy.ENERGY, null)).canExtract() || itemstack.func_77973_b() == Items.field_151137_ax;
    }

    public static boolean canBeCharged(ItemStack itemstack) {
        return MekanismUtils.useIC2() && itemstack.func_77973_b() instanceof IElectricItem || itemstack.func_77973_b() instanceof IEnergizedItem && ((IEnergizedItem)itemstack.func_77973_b()).canReceive(itemstack) || MekanismUtils.useRF() && itemstack.func_77973_b() instanceof IEnergyContainerItem && ((IEnergyContainerItem)itemstack.func_77973_b()).receiveEnergy(itemstack, 1, true) != 0 || MekanismUtils.useTesla() && itemstack.hasCapability(Capabilities.TESLA_CONSUMER_CAPABILITY, null) && ((ITeslaConsumer)itemstack.getCapability(Capabilities.TESLA_CONSUMER_CAPABILITY, null)).givePower(1L, true) > 0L || MekanismUtils.useForge() && itemstack.hasCapability(CapabilityEnergy.ENERGY, null) && ((IEnergyStorage)itemstack.getCapability(CapabilityEnergy.ENERGY, null)).canReceive();
    }

    public static boolean canBeOutputted(ItemStack itemstack, boolean chargeSlot) {
        if (itemstack.func_77973_b() instanceof IEnergizedItem) {
            IEnergizedItem energized = (IEnergizedItem)itemstack.func_77973_b();
            if (chargeSlot) {
                return energized.getEnergy(itemstack) == energized.getMaxEnergy(itemstack);
            }
            return energized.getEnergy(itemstack) == 0.0;
        }
        if (MekanismUtils.useRF() && itemstack.func_77973_b() instanceof IEnergyContainerItem) {
            IEnergyContainerItem energyContainer = (IEnergyContainerItem)itemstack.func_77973_b();
            if (chargeSlot) {
                return energyContainer.receiveEnergy(itemstack, 1, true) == 0;
            }
            return energyContainer.extractEnergy(itemstack, 1, true) == 0;
        }
        if (MekanismUtils.useTesla()) {
            if (chargeSlot && itemstack.hasCapability(Capabilities.TESLA_CONSUMER_CAPABILITY, null)) {
                ITeslaConsumer consumer = (ITeslaConsumer)itemstack.getCapability(Capabilities.TESLA_CONSUMER_CAPABILITY, null);
                return consumer.givePower(1L, true) == 0L;
            }
            if (!chargeSlot && itemstack.hasCapability(Capabilities.TESLA_PRODUCER_CAPABILITY, null)) {
                ITeslaProducer producer = (ITeslaProducer)itemstack.getCapability(Capabilities.TESLA_PRODUCER_CAPABILITY, null);
                return producer.takePower(1L, true) == 0L;
            }
        } else {
            IElectricItemManager manager;
            if (MekanismUtils.useForge() && itemstack.hasCapability(CapabilityEnergy.ENERGY, null)) {
                IEnergyStorage storage = (IEnergyStorage)itemstack.getCapability(CapabilityEnergy.ENERGY, null);
                if (chargeSlot) {
                    return !storage.canReceive() || storage.receiveEnergy(1, true) == 0;
                }
                return !storage.canExtract() || storage.extractEnergy(1, true) == 0;
            }
            if (MekanismUtils.useIC2() && itemstack.func_77973_b() instanceof ISpecialElectricItem && (manager = ((ISpecialElectricItem)itemstack.func_77973_b()).getManager(itemstack)) != null) {
                if (chargeSlot) {
                    return manager.charge(itemstack, 1.0, 3, true, true) == 0.0;
                }
                return manager.discharge(itemstack, 1.0, 3, true, true, true) == 0.0;
            }
        }
        return true;
    }
}

