/*
 * Decompiled with CFR 0.152.
 */
package openmods.model.variant;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;

public class VariantSelectorData {
    private Map<String, Matcher> matchers = ImmutableMap.of();
    private Set<ResourceLocation> allModels = ImmutableSet.of();
    private static final Gson GSON = new GsonBuilder().registerTypeAdapter(VariantSelectorData.class, (Object)new Deserializer()).create();

    public Set<ResourceLocation> getAllModels() {
        return this.allModels;
    }

    public Set<ResourceLocation> getModels(Map<String, String> key) {
        HashSet result = Sets.newHashSet();
        for (Map.Entry<String, String> e : key.entrySet()) {
            Matcher m = this.matchers.get(e.getKey());
            if (m == null) continue;
            Set<ResourceLocation> match = m.match(e.getValue());
            result.addAll(match);
        }
        return ImmutableSet.copyOf((Collection)result);
    }

    public static VariantSelectorData parse(String flatJson) {
        return (VariantSelectorData)GSON.fromJson(flatJson, VariantSelectorData.class);
    }

    public static VariantSelectorData parse(JsonElement json) {
        return (VariantSelectorData)GSON.fromJson(json, VariantSelectorData.class);
    }

    private static class Deserializer
    implements JsonDeserializer<VariantSelectorData> {
        private Deserializer() {
        }

        public VariantSelectorData deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject jsonObject = json.getAsJsonObject();
            HashMap matchers = Maps.newHashMap();
            HashSet allModels = Sets.newHashSet();
            for (Map.Entry e : jsonObject.entrySet()) {
                String name = (String)e.getKey();
                JsonElement value = (JsonElement)e.getValue();
                Matcher matcher = value.isJsonObject() ? Deserializer.createKeyedMatcher(name, ((JsonElement)e.getValue()).getAsJsonObject()) : Deserializer.createUnconditionalMatcher(name, (JsonElement)e.getValue());
                allModels.addAll(matcher.getAllModels());
                matchers.put(name, matcher);
            }
            VariantSelectorData result = new VariantSelectorData();
            result.allModels = (Set)ImmutableSet.copyOf((Collection)allModels);
            result.matchers = (Map)ImmutableMap.copyOf((Map)matchers);
            return result;
        }

        private static Matcher createKeyedMatcher(String name, JsonObject value) {
            ImmutableMap.Builder locsBuilder = ImmutableMap.builder();
            ImmutableSet.Builder allModelsBuilder = ImmutableSet.builder();
            Optional maybeDefaultModels = Optional.absent();
            for (Map.Entry e : value.entrySet()) {
                String entryName = (String)e.getKey();
                Set<ResourceLocation> models = Deserializer.parseModels(entryName, (JsonElement)e.getValue());
                if (entryName.equals("<default>")) {
                    maybeDefaultModels = Optional.of(models);
                } else {
                    locsBuilder.put((Object)entryName, models);
                }
                allModelsBuilder.addAll(models);
            }
            ImmutableSet allModels = allModelsBuilder.build();
            ImmutableMap locs = locsBuilder.build();
            if (maybeDefaultModels.isPresent()) {
                ImmutableSet defaultModels = ImmutableSet.copyOf((Collection)((Collection)maybeDefaultModels.get()));
                return new Matcher((Map)locs, (Set)defaultModels, (Set)allModels){
                    final /* synthetic */ Map val$locs;
                    final /* synthetic */ Set val$defaultModels;
                    final /* synthetic */ Set val$allModels;
                    {
                        this.val$locs = map;
                        this.val$defaultModels = set;
                        this.val$allModels = set2;
                    }

                    @Override
                    public Set<ResourceLocation> match(String value) {
                        Set result = (Set)this.val$locs.get(value);
                        return result != null ? ImmutableSet.copyOf((Collection)result) : this.val$defaultModels;
                    }

                    @Override
                    public Set<ResourceLocation> getAllModels() {
                        return this.val$allModels;
                    }
                };
            }
            return new Matcher((Map)locs, (Set)allModels){
                final /* synthetic */ Map val$locs;
                final /* synthetic */ Set val$allModels;
                {
                    this.val$locs = map;
                    this.val$allModels = set;
                }

                @Override
                public Set<ResourceLocation> match(String value) {
                    Set result = (Set)this.val$locs.get(value);
                    return result != null ? ImmutableSet.copyOf((Collection)result) : ImmutableSet.of();
                }

                @Override
                public Set<ResourceLocation> getAllModels() {
                    return this.val$allModels;
                }
            };
        }

        private static Matcher createUnconditionalMatcher(String name, JsonElement value) {
            ImmutableSet models = ImmutableSet.copyOf(Deserializer.parseModels(name, value));
            return new Matcher((Set)models){
                final /* synthetic */ Set val$models;
                {
                    this.val$models = set;
                }

                @Override
                public Set<ResourceLocation> match(String value) {
                    return this.val$models;
                }

                @Override
                public Set<ResourceLocation> getAllModels() {
                    return this.val$models;
                }
            };
        }

        private static Set<ResourceLocation> parseModels(String name, JsonElement value) {
            if (value.isJsonArray()) {
                return Deserializer.parseArrayOfLocations(name, value);
            }
            if (value.isJsonPrimitive()) {
                return Deserializer.parseSingleLocation(value);
            }
            throw new JsonSyntaxException("Expected " + name + " to be a string, was " + JsonUtils.func_151222_d((JsonElement)value));
        }

        private static Set<ResourceLocation> parseSingleLocation(JsonElement value) {
            ModelResourceLocation loc = new ModelResourceLocation(value.getAsString());
            return ImmutableSet.of((Object)loc);
        }

        private static Set<ResourceLocation> parseArrayOfLocations(String name, JsonElement value) {
            ImmutableSet.Builder result = ImmutableSet.builder();
            for (JsonElement e : value.getAsJsonArray()) {
                if (e.isJsonPrimitive()) {
                    ModelResourceLocation loc = new ModelResourceLocation(value.getAsString());
                    result.add((Object)loc);
                    continue;
                }
                throw new JsonSyntaxException("Expected elements of " + name + " to be a string, was " + JsonUtils.func_151222_d((JsonElement)e));
            }
            return result.build();
        }
    }

    private static interface Matcher {
        public Set<ResourceLocation> match(String var1);

        public Set<ResourceLocation> getAllModels();
    }
}

