/*
 * Decompiled with CFR 0.152.
 */
package reborncore.common.items;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import org.apache.commons.lang3.Validate;

public class InventoryItem
implements IItemHandler,
IItemHandlerModifiable,
ICapabilityProvider {
    @Nonnull
    ItemStack stack;
    int size;

    private InventoryItem(@Nonnull ItemStack stack, int size) {
        Validate.notNull((Object)stack);
        Validate.isTrue((!stack.func_190926_b() ? 1 : 0) != 0);
        this.size = size;
        this.stack = stack;
    }

    public static InventoryItem getItemInvetory(ItemStack stack, int size) {
        return new InventoryItem(stack, size);
    }

    public ItemStack getStack() {
        return this.stack;
    }

    public NBTTagCompound getInvData() {
        Validate.isTrue((!this.stack.func_190926_b() ? 1 : 0) != 0);
        if (!this.stack.func_77942_o()) {
            this.stack.func_77982_d(new NBTTagCompound());
        }
        if (!this.stack.func_77978_p().func_74764_b("inventory")) {
            this.stack.func_77978_p().func_74782_a("inventory", (NBTBase)new NBTTagCompound());
        }
        return this.stack.func_77978_p().func_74775_l("inventory");
    }

    public NBTTagCompound getSlotData(int slot) {
        this.validateSlotIndex(slot);
        NBTTagCompound invData = this.getInvData();
        if (!invData.func_74764_b("slot_" + slot)) {
            invData.func_74782_a("slot_" + slot, (NBTBase)new NBTTagCompound());
        }
        return invData.func_74775_l("slot_" + slot);
    }

    public void setSlotData(int slot, NBTTagCompound tagCompound) {
        this.validateSlotIndex(slot);
        Validate.notNull((Object)tagCompound);
        NBTTagCompound invData = this.getInvData();
        invData.func_74782_a("slot_" + slot, (NBTBase)tagCompound);
    }

    public List<ItemStack> getAllStacks() {
        return IntStream.range(0, this.size).mapToObj(this::getStackInSlot).collect(Collectors.toList());
    }

    public int getSlots() {
        return this.size;
    }

    @Nonnull
    public ItemStack getStackInSlot(int slot) {
        return new ItemStack(this.getSlotData(slot));
    }

    public void setStackInSlot(int slot, @Nonnull ItemStack stack) {
        this.setSlotData(slot, stack.func_77955_b(new NBTTagCompound()));
    }

    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        boolean reachedLimit;
        if (stack.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        this.validateSlotIndex(slot);
        ItemStack existing = this.getStackInSlot(slot);
        int limit = this.getStackLimit(slot, stack);
        if (!existing.func_190926_b()) {
            if (!ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)existing)) {
                return stack;
            }
            limit -= existing.func_190916_E();
        }
        if (limit <= 0) {
            return stack;
        }
        boolean bl = reachedLimit = stack.func_190916_E() > limit;
        if (!simulate) {
            if (existing.func_190926_b()) {
                this.setStackInSlot(slot, reachedLimit ? ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)limit) : stack);
            } else {
                existing.func_190917_f(reachedLimit ? limit : stack.func_190916_E());
            }
        }
        return reachedLimit ? ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)(stack.func_190916_E() - limit)) : ItemStack.field_190927_a;
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (amount == 0) {
            return ItemStack.field_190927_a;
        }
        this.validateSlotIndex(slot);
        ItemStack existing = this.getStackInSlot(slot);
        if (existing.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        int toExtract = Math.min(amount, existing.func_77976_d());
        if (existing.func_190916_E() <= toExtract) {
            if (!simulate) {
                this.setStackInSlot(slot, ItemStack.field_190927_a);
            }
            return existing;
        }
        if (!simulate) {
            this.setStackInSlot(slot, ItemHandlerHelper.copyStackWithSize((ItemStack)existing, (int)(existing.func_190916_E() - toExtract)));
        }
        return ItemHandlerHelper.copyStackWithSize((ItemStack)existing, (int)toExtract);
    }

    public int getSlotLimit(int slot) {
        return 64;
    }

    public void validateSlotIndex(int slot) {
        if (slot < 0 || slot >= this.size) {
            throw new RuntimeException("Slot " + slot + " not in valid range - [0," + this.size + ")");
        }
    }

    public int getStackLimit(int slot, @Nonnull ItemStack stack) {
        return Math.min(this.getSlotLimit(slot), stack.func_77976_d());
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY;
    }

    @Nullable
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this);
        }
        return null;
    }
}

