/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.conduit.facade;

import com.enderio.core.api.client.gui.IAdvancedTooltipProvider;
import com.enderio.core.api.client.gui.IResourceTooltipProvider;
import com.enderio.core.client.handlers.SpecialTooltipHandler;
import com.enderio.core.common.util.NullHelper;
import crazypants.enderio.api.IModObject;
import crazypants.enderio.base.EnderIOTab;
import crazypants.enderio.base.conduit.ConduitUtil;
import crazypants.enderio.base.conduit.IConduitBundle;
import crazypants.enderio.base.conduit.facade.EnumFacadeType;
import crazypants.enderio.base.paint.PaintUtil;
import crazypants.enderio.base.recipe.MachineRecipeRegistry;
import crazypants.enderio.base.recipe.painter.FacadePainterRecipe;
import crazypants.enderio.base.registry.Registry;
import crazypants.enderio.base.render.IHaveRenderers;
import crazypants.enderio.base.render.registry.ItemModelRegistry;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemConduitFacade
extends Item
implements IAdvancedTooltipProvider,
IResourceTooltipProvider,
IHaveRenderers {
    public static ItemConduitFacade create(@Nonnull IModObject modObject) {
        ItemConduitFacade result = new ItemConduitFacade(modObject);
        MachineRecipeRegistry.instance.registerRecipe("painter", new FacadePainterRecipe(result));
        return result;
    }

    public ItemConduitFacade(@Nonnull IModObject modObject) {
        this.func_77637_a(EnderIOTab.tabEnderIOItems);
        this.func_77625_d(64);
        this.func_77627_a(true);
        modObject.apply(this);
    }

    public int func_77647_b(int damage) {
        return damage;
    }

    @Nonnull
    public String func_77667_c(@Nonnull ItemStack stack) {
        return EnumFacadeType.getTypeFromMeta(stack.func_77960_j()).getUnlocName(this);
    }

    @Nonnull
    public EnumActionResult func_180614_a(@Nonnull EntityPlayer player, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull EnumHand hand, @Nonnull EnumFacing side, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            return EnumActionResult.SUCCESS;
        }
        Block conduitBlock = Registry.getConduitBlock();
        if (conduitBlock != null) {
            ItemStack stack = player.func_184586_b(hand);
            BlockPos placeAt = pos.func_177972_a(side);
            if (player.func_175151_a(placeAt, side, stack) && PaintUtil.getSourceBlock(stack) != null) {
                if (world.func_175623_d(placeAt)) {
                    world.func_175656_a(placeAt, conduitBlock.func_176223_P());
                    IConduitBundle bundle = (IConduitBundle)NullHelper.notnullM((Object)((IConduitBundle)world.func_175625_s(placeAt)), (String)"placing block yielded no tileentity");
                    IBlockState bs = PaintUtil.getSourceBlock(stack);
                    bundle.setFacadeType(EnumFacadeType.getTypeFromMeta(stack.func_77952_i()));
                    bundle.setPaintSource(bs);
                    ConduitUtil.playPlaceSound(bs.func_177230_c().func_185467_w(), world, pos);
                    if (!player.field_71075_bZ.field_75098_d) {
                        stack.func_190918_g(1);
                    }
                    return EnumActionResult.SUCCESS;
                }
                TileEntity tileEntity = world.func_175625_s(placeAt);
                if (tileEntity instanceof IConduitBundle && ((IConduitBundle)tileEntity).handleFacadeClick(world, placeAt, player, side.func_176734_d(), stack, hand, hitX, hitY, hitZ)) {
                    return EnumActionResult.SUCCESS;
                }
            }
        }
        return EnumActionResult.PASS;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(@Nonnull ItemStack stack, @Nullable World worldIn, @Nonnull List<String> tooltip, @Nonnull ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
    }

    @Nonnull
    public String getUnlocalizedNameForTooltip(@Nonnull ItemStack itemStack) {
        return this.func_77658_a();
    }

    @SideOnly(value=Side.CLIENT)
    public void addCommonEntries(@Nonnull ItemStack itemstack, @Nullable EntityPlayer entityplayer, @Nonnull List<String> list, boolean flag) {
    }

    @SideOnly(value=Side.CLIENT)
    public void addBasicEntries(@Nonnull ItemStack itemstack, @Nullable EntityPlayer entityplayer, @Nonnull List<String> list, boolean flag) {
    }

    @SideOnly(value=Side.CLIENT)
    public void addDetailedEntries(@Nonnull ItemStack itemstack, @Nullable EntityPlayer entityplayer, @Nonnull List list, boolean flag) {
        SpecialTooltipHandler.addDetailedTooltipFromResources((List)list, (ItemStack)itemstack);
        if (EnumFacadeType.getTypeFromMeta(itemstack.func_77960_j()) != EnumFacadeType.BASIC) {
            list.add("");
            SpecialTooltipHandler.addDetailedTooltipFromResources((List)list, (String)this.func_77667_c(itemstack));
        }
    }

    public void func_150895_a(@Nonnull CreativeTabs tab, @Nonnull NonNullList<ItemStack> list) {
        if (this.func_194125_a(tab)) {
            for (EnumFacadeType type : EnumFacadeType.values()) {
                list.add((Object)new ItemStack((Item)this, 1, type.ordinal()));
            }
        }
    }

    @Override
    public void registerRenderers(@Nonnull IModObject modObject) {
        for (EnumFacadeType type : EnumFacadeType.values()) {
            ModelResourceLocation mrl = new ModelResourceLocation((ResourceLocation)NullHelper.notnull((Object)this.getRegistryName(), (String)"unregistered item?"), "type=" + type.func_176610_l());
            ModelLoader.setCustomModelResourceLocation((Item)this, (int)EnumFacadeType.getMetaFromType(type), (ModelResourceLocation)mrl);
            ItemModelRegistry.registerFacade(mrl);
        }
    }
}

