/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.conduit.item;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.util.ResourceLocation;

public enum FunctionUpgrade {
    INVENTORY_PANEL("inventory_panel_upgrade", "item.item_inventory_panel_upgrade", 1),
    EXTRACT_SPEED_UPGRADE("extract_speed_upgrade", "item.item_extract_speed_upgrade", 15){

        @Override
        public int getMaximumExtracted(int stackSize) {
            return 4 + Math.min(stackSize, this.maxStackSize) * 4;
        }
    }
    ,
    EXTRACT_SPEED_DOWNGRADE("extract_speed_downgrade", "item.item_extract_speed_downgrade", 1){

        @Override
        public int getMaximumExtracted(int stackSize) {
            return 1;
        }
    }
    ,
    RS_CRAFTING_UPGRADE("rs_crafting_upgrade", "item.item_rs_crafting_upgrade", 1),
    RS_CRAFTING_SPEED_UPGRADE("rs_crafting_upgrade", "item.item_rs_crafting_upgrade", 15){

        @Override
        public int getMaximumExtracted(int stackSize) {
            return 4 + Math.min(stackSize, this.maxStackSize) * 4;
        }
    }
    ,
    RS_CRAFTING_SPEED_DOWNGRADE("rs_crafting_speed_downgrade", "item.item_rs_crafting_speed_downgrade", 1){

        @Override
        public int getMaximumExtracted(int stackSize) {
            return 1;
        }
    };

    public static final int BASE_MAX_EXTRACTED = 4;
    public static final int LIQUID_MAX_EXTRACTED_SCALER = 2;
    @Nonnull
    public final String baseName;
    @Nonnull
    public final String iconName;
    @Nonnull
    public final String unlocName;
    public final int maxStackSize;

    public static List<ResourceLocation> resources() {
        ArrayList<ResourceLocation> res = new ArrayList<ResourceLocation>(FunctionUpgrade.values().length);
        for (FunctionUpgrade c : FunctionUpgrade.values()) {
            res.add(new ResourceLocation(c.iconName));
        }
        return res;
    }

    private FunctionUpgrade(String name, String unlocName, int maxStackSize) {
        this.baseName = name;
        this.iconName = "enderio:" + name;
        this.unlocName = unlocName;
        this.maxStackSize = maxStackSize;
    }

    public int getMaximumExtracted(int stackSize) {
        return 4;
    }
}

