/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.config.recipes.xml;

import com.enderio.core.common.util.NNList;
import crazypants.enderio.base.config.recipes.InvalidRecipeConfigException;
import crazypants.enderio.base.config.recipes.RecipeConfigElement;
import crazypants.enderio.base.config.recipes.StaxFactory;
import crazypants.enderio.base.config.recipes.xml.Item;
import crazypants.enderio.base.config.recipes.xml.ItemOptional;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import net.minecraft.item.crafting.Ingredient;

public class Shapeless
implements RecipeConfigElement {
    private List<Item> items;
    private transient boolean valid;

    @Override
    public Object readResolve() throws InvalidRecipeConfigException {
        try {
            if (this.items == null || this.items.isEmpty()) {
                throw new InvalidRecipeConfigException("Not enough items");
            }
            if (this.items.size() > 9) {
                throw new InvalidRecipeConfigException("Too many items");
            }
            this.valid = true;
            for (Item item : this.items) {
                this.valid = this.valid && item.isValid();
            }
        }
        catch (InvalidRecipeConfigException e) {
            throw new InvalidRecipeConfigException(e, "in <Shapeless>");
        }
        return this;
    }

    @Override
    public void enforceValidity() throws InvalidRecipeConfigException {
        for (Item item : this.items) {
            item.enforceValidity();
        }
    }

    @Override
    public boolean isValid() {
        return this.valid;
    }

    @Nonnull
    public NNList<Ingredient> getIngredients() {
        NNList result = new NNList();
        for (ItemOptional itemOptional : this.items) {
            Ingredient ingredient = itemOptional.getRecipeObject();
            if (ingredient == null) {
                result.add((Object)Ingredient.field_193370_a);
                continue;
            }
            result.add((Object)ingredient);
        }
        return result;
    }

    @Override
    public boolean setAttribute(StaxFactory factory, String name, String value) throws InvalidRecipeConfigException, XMLStreamException {
        return false;
    }

    @Override
    public boolean setElement(StaxFactory factory, String name, StartElement startElement) throws InvalidRecipeConfigException, XMLStreamException {
        if ("item".equals(name)) {
            if (this.items == null) {
                this.items = new ArrayList<Item>();
            }
            this.items.add((Item)factory.read(new Item().setAllowDelaying(false), startElement));
            return true;
        }
        return false;
    }
}

