/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.diagnostics;

import crazypants.enderio.base.Log;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.profiler.Profiler;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.fml.common.event.FMLServerAboutToStartEvent;
import net.minecraftforge.fml.relauncher.ReflectionHelper;

public class ProfilerDebugger
extends Profiler {
    private List<Element> stack = new LinkedList<Element>();
    private List<Element> discarded = new LinkedList<Element>();
    private List<Element> candidates = new LinkedList<Element>();

    public void func_76317_a() {
        this.stack.clear();
        this.discarded.clear();
        this.candidates.clear();
        super.func_76317_a();
    }

    public void func_76320_a(@Nonnull String name) {
        if (this.field_76327_a) {
            super.func_76320_a(name);
            if (this.stack.isEmpty() && name.equals("root")) {
                this.discarded.clear();
                this.candidates.clear();
            }
            this.stack.add(0, new Element(this.func_76322_c(), new RuntimeException()));
        }
    }

    public void func_76319_b() {
        if (this.field_76327_a) {
            if (this.stack.isEmpty()) {
                StringBuilder b = new StringBuilder();
                b.append("Profiler Underrun!\n");
                b.append("Special mismatching start/end pairs:\n");
                for (Element element : this.candidates) {
                    b.append("Section: " + element.name + "\n");
                    b.append("Starter: " + this.e2s(element.starter) + "\n");
                    b.append("Ender: " + this.e2s(element.ender) + "\n\n");
                }
                b.append("Last endSection()s:\n");
                for (Element element : this.discarded) {
                    b.append("Section: " + element.name + "\n");
                    b.append("Starter: " + this.e2s(element.starter) + "\n");
                    b.append("Ender: " + this.e2s(element.ender) + "\n\n");
                }
                Log.error(b.toString());
                throw new RuntimeException(b.toString());
            }
            Element element = this.stack.remove(0);
            element.ender = new RuntimeException();
            this.discarded.add(element);
            while (this.discarded.size() > 3000) {
                this.discarded.remove(0);
            }
            if (!this.getFirst(element.starter).equals(this.getFirst(element.ender))) {
                this.candidates.add(element);
                Log.warn("Mismatching startSection() and endSection() source for section " + element.name + "\nStarter: " + this.e2s(element.starter) + "\nEnder: " + this.e2s(element.ender));
                while (this.candidates.size() > 100) {
                    this.candidates.remove(0);
                }
            }
            super.func_76319_b();
        }
    }

    private String e2s(RuntimeException ex) {
        StringWriter errors = new StringWriter();
        ex.printStackTrace(new PrintWriter(errors));
        return errors.toString();
    }

    private String getFirst(RuntimeException ex) {
        StackTraceElement[] stackTrace = ex.getStackTrace();
        for (int i = 0; i < stackTrace.length; ++i) {
            StackTraceElement stackTraceElement = stackTrace[i];
            String className = stackTraceElement.getClassName();
            if (className.equals("crazypants.enderio.base.diagnostics.ProfilerEIO") || className.equals("net.minecraft.profiler.Profiler") || className.equals("crazypants.enderio.base.diagnostics.Prof")) continue;
            if (className.startsWith("net.minecraft")) {
                return "minecraft";
            }
            return className + "." + stackTraceElement.getMethodName();
        }
        return "";
    }

    public static void init(FMLServerAboutToStartEvent event) {
        ReflectionHelper.setPrivateValue(MinecraftServer.class, (Object)event.getServer(), (Object)((Object)new ProfilerDebugger()), (String[])new String[]{"profiler", "field_71304_b"});
    }

    private static class Element {
        String name;
        RuntimeException starter;
        RuntimeException ender;

        Element(String name, RuntimeException starter) {
            this.name = name;
            this.starter = starter;
        }
    }
}

