/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.enchantment;

import com.enderio.core.common.util.NullHelper;
import crazypants.enderio.base.Log;
import crazypants.enderio.base.init.ModObject;
import crazypants.enderio.base.integration.baubles.BaublesUtil;
import crazypants.enderio.base.integration.galacticraft.GalacticraftUtil;
import crazypants.enderio.util.NbtValue;
import crazypants.enderio.util.Prep;
import java.util.ListIterator;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.entity.player.PlayerDropsEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;

@Mod.EventBusSubscriber(modid="enderio")
public class HandlerSoulBound {
    @GameRegistry.ObjectHolder(value="enderio:soulbound")
    public static final Enchantment SOULBOUND = null;

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onPlayerDeath(PlayerDropsEvent evt) {
        IInventory galacticraft;
        if (evt.getEntityPlayer() == null || evt.getEntityPlayer() instanceof FakePlayer || evt.isCanceled()) {
            return;
        }
        if (evt.getEntityPlayer().field_70170_p.func_82736_K().func_82766_b("keepInventory")) {
            return;
        }
        Log.debug("Running onPlayerDeathEarly logic for " + evt.getEntityPlayer().func_70005_c_());
        ListIterator iter = evt.getDrops().listIterator();
        while (iter.hasNext()) {
            EntityItem ei = (EntityItem)iter.next();
            ItemStack item = ei.func_92059_d();
            if (!HandlerSoulBound.isSoulBound(item) || !HandlerSoulBound.addToPlayerInventory(evt.getEntityPlayer(), item)) continue;
            iter.remove();
        }
        IInventory baubles = BaublesUtil.instance().getBaubles(evt.getEntityPlayer());
        if (baubles != null) {
            for (int i = 0; i < baubles.func_70302_i_(); ++i) {
                ItemStack item = baubles.func_70301_a(i);
                if (!HandlerSoulBound.isSoulBound(item) || !HandlerSoulBound.addToPlayerInventory(evt.getEntityPlayer(), item)) continue;
                baubles.func_70299_a(i, Prep.getEmpty());
            }
        }
        if (evt.getEntityPlayer() instanceof EntityPlayerMP && (galacticraft = GalacticraftUtil.getGCInventoryForPlayer((EntityPlayerMP)evt.getEntityPlayer())) != null) {
            for (int i = 0; i < galacticraft.func_70302_i_(); ++i) {
                ItemStack item = galacticraft.func_70301_a(i);
                if (!HandlerSoulBound.isSoulBound(item) || !HandlerSoulBound.addToPlayerInventory(evt.getEntityPlayer(), item)) continue;
                galacticraft.func_70299_a(i, Prep.getEmpty());
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onPlayerDeathLate(PlayerDropsEvent evt) {
        if (evt.getEntityPlayer() == null || evt.getEntityPlayer() instanceof FakePlayer || evt.isCanceled()) {
            return;
        }
        if (evt.getEntityPlayer().field_70170_p.func_82736_K().func_82766_b("keepInventory")) {
            return;
        }
        Log.debug("Running onPlayerDeathLate logic for " + evt.getEntityPlayer().func_70005_c_());
        ListIterator iter = evt.getDrops().listIterator();
        while (iter.hasNext()) {
            EntityItem ei = (EntityItem)iter.next();
            ItemStack item = ei.func_92059_d();
            if (!HandlerSoulBound.isSoulBound(item) || !HandlerSoulBound.addToPlayerInventory(evt.getEntityPlayer(), item)) continue;
            iter.remove();
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onPlayerClone(PlayerEvent.Clone evt) {
        ItemStack item;
        int i;
        if (!evt.isWasDeath() || evt.isCanceled()) {
            return;
        }
        if (evt.getOriginal() == null || evt.getEntityPlayer() == null || evt.getEntityPlayer() instanceof FakePlayer) {
            return;
        }
        if (evt.getEntityPlayer().field_70170_p.func_82736_K().func_82766_b("keepInventory")) {
            return;
        }
        if (evt.getOriginal() == evt.getEntityPlayer() || evt.getOriginal().field_71071_by == evt.getEntityPlayer().field_71071_by || evt.getOriginal().field_71071_by.field_70460_b == evt.getEntityPlayer().field_71071_by.field_70460_b && evt.getOriginal().field_71071_by.field_70462_a == evt.getEntityPlayer().field_71071_by.field_70462_a) {
            Log.warn("Player " + evt.getEntityPlayer().func_70005_c_() + " just died and respawned in their old body. Did someone fire a PlayerEvent.Clone(death=true) for a teleportation? Supressing Soulbound enchantment for zombie player.");
            return;
        }
        Log.debug("Running onPlayerCloneEarly logic for " + evt.getEntityPlayer().func_70005_c_());
        for (i = 0; i < evt.getOriginal().field_71071_by.field_70460_b.size(); ++i) {
            item = (ItemStack)evt.getOriginal().field_71071_by.field_70460_b.get(i);
            if (!HandlerSoulBound.isSoulBound(item) || !HandlerSoulBound.addToPlayerInventory(evt.getEntityPlayer(), item)) continue;
            evt.getOriginal().field_71071_by.field_70460_b.set(i, (Object)Prep.getEmpty());
        }
        for (i = 0; i < evt.getOriginal().field_71071_by.field_70462_a.size(); ++i) {
            item = (ItemStack)evt.getOriginal().field_71071_by.field_70462_a.get(i);
            if (!HandlerSoulBound.isSoulBound(item) || !HandlerSoulBound.addToPlayerInventory(evt.getEntityPlayer(), item)) continue;
            evt.getOriginal().field_71071_by.field_70462_a.set(i, (Object)Prep.getEmpty());
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onPlayerCloneLast(PlayerEvent.Clone evt) {
        ItemStack item;
        int i;
        if (!evt.isWasDeath() || evt.isCanceled()) {
            return;
        }
        if (evt.getOriginal() == null || evt.getEntityPlayer() == null || evt.getEntityPlayer() instanceof FakePlayer) {
            return;
        }
        if (evt.getEntityPlayer().field_70170_p.func_82736_K().func_82766_b("keepInventory")) {
            return;
        }
        if (evt.getOriginal() == evt.getEntityPlayer() || evt.getOriginal().field_71071_by == evt.getEntityPlayer().field_71071_by || evt.getOriginal().field_71071_by.field_70460_b == evt.getEntityPlayer().field_71071_by.field_70460_b && evt.getOriginal().field_71071_by.field_70462_a == evt.getEntityPlayer().field_71071_by.field_70462_a) {
            return;
        }
        Log.debug("Running onPlayerCloneLate logic for " + evt.getEntityPlayer().func_70005_c_());
        for (i = 0; i < evt.getOriginal().field_71071_by.field_70460_b.size(); ++i) {
            item = (ItemStack)evt.getOriginal().field_71071_by.field_70460_b.get(i);
            if (!HandlerSoulBound.isSoulBound(item) || !HandlerSoulBound.addToPlayerInventory(evt.getEntityPlayer(), item) && !HandlerSoulBound.tryToSpawnItemInWorld(evt.getOriginal(), item)) continue;
            evt.getOriginal().field_71071_by.field_70460_b.set(i, (Object)Prep.getEmpty());
        }
        for (i = 0; i < evt.getOriginal().field_71071_by.field_70462_a.size(); ++i) {
            item = (ItemStack)evt.getOriginal().field_71071_by.field_70462_a.get(i);
            if (!HandlerSoulBound.isSoulBound(item) || !HandlerSoulBound.addToPlayerInventory(evt.getEntityPlayer(), item) && !HandlerSoulBound.tryToSpawnItemInWorld(evt.getOriginal(), item)) continue;
            evt.getOriginal().field_71071_by.field_70462_a.set(i, (Object)Prep.getEmpty());
        }
        if (evt.getEntityPlayer().func_70005_c_().equals("Bacon_Donut")) {
            HandlerSoulBound.addToPlayerInventory(evt.getEntityPlayer(), new ItemStack(Items.field_151157_am));
        } else if (evt.getEntityPlayer().func_70005_c_().equals("wyld")) {
            HandlerSoulBound.addToPlayerInventory(evt.getEntityPlayer(), new ItemStack(Items.field_151110_aK));
        } else if (evt.getEntityPlayer().func_70005_c_().equals("Soaryn")) {
            HandlerSoulBound.addToPlayerInventory(evt.getEntityPlayer(), new ItemStack((Block)Blocks.field_150486_ae));
        } else if (evt.getEntityPlayer().func_70005_c_().equals("Henry_Loenwind")) {
            ItemStack stack = new ItemStack(ModObject.itemColdFireIgniter.getItemNN());
            NbtValue.FLUIDAMOUNT.setInt(stack, 1000);
            HandlerSoulBound.addToPlayerInventory(evt.getEntityPlayer(), stack);
        }
    }

    private static boolean tryToSpawnItemInWorld(EntityPlayer entityPlayer, @Nonnull ItemStack item) {
        if (entityPlayer != null) {
            EntityItem entityitem = new EntityItem(entityPlayer.field_70170_p, entityPlayer.field_70165_t, entityPlayer.field_70163_u + 0.5, entityPlayer.field_70161_v, item);
            entityitem.func_174867_a(40);
            entityitem.lifespan *= 5;
            entityitem.field_70159_w = 0.0;
            entityitem.field_70179_y = 0.0;
            entityPlayer.field_70170_p.func_72838_d((Entity)entityitem);
            Log.debug("Running tryToSpawnItemInWorld logic for " + entityPlayer.func_70005_c_() + ": " + item);
            return true;
        }
        return false;
    }

    private static boolean isSoulBound(@Nonnull ItemStack item) {
        return EnchantmentHelper.func_77506_a((Enchantment)((Enchantment)NullHelper.notnullF((Object)SOULBOUND, (String)"Soulbound went unbound")), (ItemStack)item) > 0;
    }

    private static boolean addToPlayerInventory(EntityPlayer entityPlayer, ItemStack item) {
        if (item == null || entityPlayer == null) {
            return false;
        }
        if (item.func_77973_b() instanceof ItemArmor) {
            ItemArmor arm = (ItemArmor)item.func_77973_b();
            int index = arm.field_77881_a.func_188454_b();
            if (Prep.isInvalid((ItemStack)entityPlayer.field_71071_by.field_70460_b.get(index))) {
                entityPlayer.field_71071_by.field_70460_b.set(index, (Object)item);
                Log.debug("Running addToPlayerInventory/armor logic for " + entityPlayer.func_70005_c_() + ": " + item);
                return true;
            }
        }
        InventoryPlayer inv = entityPlayer.field_71071_by;
        for (int i = 0; i < inv.field_70462_a.size(); ++i) {
            if (!Prep.isInvalid((ItemStack)inv.field_70462_a.get(i))) continue;
            inv.field_70462_a.set(i, (Object)item.func_77946_l());
            Log.debug("Running addToPlayerInventory/main logic for " + entityPlayer.func_70005_c_() + ": " + item);
            return true;
        }
        Log.debug("Running addToPlayerInventory/fail logic for " + entityPlayer.func_70005_c_() + ": " + item);
        return false;
    }
}

