/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.farming.farmers;

import crazypants.enderio.api.farm.FarmNotification;
import crazypants.enderio.api.farm.FarmingAction;
import crazypants.enderio.api.farm.IFarmer;
import crazypants.enderio.api.farm.IFarmerJoe;
import crazypants.enderio.api.farm.IHarvestResult;
import crazypants.enderio.base.farming.FarmersRegistry;
import crazypants.enderio.base.farming.FarmingTool;
import crazypants.enderio.base.farming.farmers.HarvestResult;
import crazypants.enderio.base.farming.farmers.TreeFarmer;
import crazypants.enderio.base.farming.harvesters.FarmHarvestingTarget;
import crazypants.enderio.base.farming.harvesters.IHarvestingTarget;
import crazypants.enderio.base.farming.harvesters.TreeHarvester;
import crazypants.enderio.util.Prep;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public abstract class RubberTreeFarmer
extends TreeFarmer {
    @Nonnull
    protected final ItemStack stickyResin;
    protected boolean hasTap;

    public RubberTreeFarmer(@Nonnull Block sapling, @Nonnull Block wood, @Nonnull ItemStack resin) {
        super(sapling, wood);
        this.stickyResin = resin;
        FarmersRegistry.slotItemsProduce.add(this.stickyResin);
    }

    public boolean isValid() {
        return !this.saplings.isEmpty() && !this.woods.isEmpty() && Prep.isValid(this.stickyResin);
    }

    @Override
    public IFarmerJoe.Result tryPrepareBlock(@Nonnull IFarmer farm, @Nonnull BlockPos pos, @Nonnull IBlockState state) {
        if (this.canPlant(farm.getSeedTypeInSuppliesFor(pos))) {
            if (Math.abs(farm.getLocation().func_177958_n() - pos.func_177958_n()) % 2 == 0) {
                return IFarmerJoe.Result.CLAIM;
            }
            if (Math.abs(farm.getLocation().func_177952_p() - pos.func_177952_p()) % 2 == 0) {
                return IFarmerJoe.Result.CLAIM;
            }
            World world = farm.getWorld();
            for (int x = -1; x < 2; ++x) {
                for (int z = -1; z < 2; ++z) {
                    BlockPos pos2 = pos.func_177982_a(x, 0, z);
                    IBlockState state2 = world.func_180495_p(pos2);
                    Block block = state2.func_177230_c();
                    if (block.isLeaves(state2, (IBlockAccess)world, pos2) || block.isAir(state2, (IBlockAccess)world, pos2) || block.canBeReplacedByLeaves(state2, (IBlockAccess)world, pos2)) continue;
                    return IFarmerJoe.Result.CLAIM;
                }
            }
            return super.tryPrepareBlock(farm, pos, state);
        }
        return IFarmerJoe.Result.NEXT;
    }

    @Override
    protected void setupHarvesting(@Nonnull IFarmer farm, @Nonnull BlockPos harvestLocation) {
        this.hasTap = farm.hasTool(FarmingTool.TREETAP);
        if (this.hasTap) {
            this.hasAxe = farm.hasTool(FarmingTool.AXE);
            this.fortune = farm.getLootingValue(FarmingTool.AXE);
            this.hasShears = farm.hasTool(FarmingTool.SHEARS);
            this.hasHoe = farm.hasTool(FarmingTool.HOE);
            this.noShearingPercentage = farm.isLowOnSaplings(harvestLocation);
            this.shearCount = 0;
        }
    }

    @Override
    public IHarvestResult harvestBlock(@Nonnull IFarmer farm, @Nonnull BlockPos bc, @Nonnull IBlockState meta) {
        this.setupHarvesting(farm, bc);
        if (!this.hasTap) {
            farm.setNotification(FarmNotification.NO_TREETAP);
            return null;
        }
        World world = farm.getWorld();
        HarvestResult res = new HarvestResult();
        FarmHarvestingTarget target = new FarmHarvestingTarget(this, farm);
        TreeHarvester.harvest(world, bc, res, target);
        Collections.sort(res.getHarvestedBlocks(), comp);
        ArrayList<BlockPos> actualHarvests = new ArrayList<BlockPos>();
        boolean harvesting = true;
        for (int i = 0; i < res.getHarvestedBlocks().size() && harvesting; ++i) {
            BlockPos pos = (BlockPos)res.getHarvestedBlocks().get(i);
            IBlockState state = world.func_180495_p(pos);
            if (this.isWood(state.func_177230_c())) {
                if (this.hasResin(state)) {
                    if (farm.checkAction(FarmingAction.HARVEST, FarmingTool.TREETAP)) {
                        this.harvest(res, world, pos, state);
                        actualHarvests.add(pos);
                        farm.registerAction(FarmingAction.HARVEST, FarmingTool.TREETAP, state, pos);
                        continue;
                    }
                    harvesting = false;
                    continue;
                }
                if (this.canHaveResin(state) || !world.func_175623_d(pos.func_177984_a()) || !this.harvestSingleBlock(farm, world, res, pos)) continue;
                actualHarvests.add(pos);
                continue;
            }
            if (!IHarvestingTarget.isDefaultLeaves(state)) continue;
            if (this.harvestSingleBlock(farm, world, res, pos)) {
                actualHarvests.add(pos);
                continue;
            }
            harvesting = false;
        }
        res.getHarvestedBlocks().clear();
        res.getHarvestedBlocks().addAll(actualHarvests);
        return res;
    }

    private void harvest(@Nonnull HarvestResult res, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull IBlockState state) {
        world.func_180501_a(pos, this.removeResin(state), 3);
        ItemStack drop = this.makeResin(world.field_73012_v);
        EntityItem dropEnt = new EntityItem(world, (double)pos.func_177958_n() + 0.5, (double)(pos.func_177956_o() + 1), (double)pos.func_177952_p() + 0.5, drop);
        res.getDrops().add((Object)dropEnt);
    }

    @Nonnull
    protected ItemStack makeResin(@Nonnull Random rand) {
        return this.stickyResin.func_77946_l();
    }

    protected abstract boolean hasResin(@Nonnull IBlockState var1);

    protected boolean canHaveResin(@Nonnull IBlockState state) {
        return true;
    }

    @Nonnull
    protected abstract IBlockState removeResin(@Nonnull IBlockState var1);
}

