/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.gui;

import com.enderio.core.api.client.render.IWidgetIcon;
import com.enderio.core.client.gui.GuiContainerBase;
import com.enderio.core.client.render.RenderUtil;
import com.enderio.core.common.util.NNList;
import com.enderio.core.common.util.NullHelper;
import crazypants.enderio.base.EnderIO;
import crazypants.enderio.base.gui.IconEIO;
import crazypants.enderio.base.network.IRemoteExec;
import crazypants.enderio.base.sound.IModSound;
import crazypants.enderio.base.sound.SoundHelper;
import crazypants.enderio.base.sound.SoundRegistry;
import crazypants.enderio.util.Prep;
import java.awt.Rectangle;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public abstract class GuiContainerBaseEIO
extends GuiContainerBase
implements IRemoteExec.IGui {
    @Nonnull
    private final NNList<ResourceLocation> guiTextures = new NNList();
    @Nonnull
    private final List<Rectangle> tabAreas = new ArrayList<Rectangle>();
    @Nonnull
    private static final Rectangle NO_TAB = new Rectangle(0, 0, 0, 0);

    public GuiContainerBaseEIO(@Nonnull Container par1Container, String ... guiTexture) {
        super(par1Container);
        for (String string : guiTexture) {
            this.guiTextures.add((Object)EnderIO.proxy.getGuiTexture((String)NullHelper.notnull((Object)string, (String)"invalid gui texture name")));
        }
    }

    public void bindGuiTexture() {
        this.bindGuiTexture(0);
    }

    public void bindGuiTexture(int id) {
        RenderUtil.bindTexture((ResourceLocation)this.getGuiTexture(id));
    }

    @Nonnull
    protected ResourceLocation getGuiTexture(int id) {
        return this.guiTextures.size() > id ? (ResourceLocation)this.guiTextures.get(id) : new ResourceLocation("enderio", "texture_missing");
    }

    @Nonnull
    protected ResourceLocation getGuiTexture() {
        return this.getGuiTexture(0);
    }

    public List<Rectangle> getBlockingAreas() {
        return new ArrayList<Rectangle>(this.tabAreas);
    }

    @Nullable
    public Object getIngredientUnderMouse(int mouseX, int mouseY) {
        return null;
    }

    public void startTabs() {
        this.tabAreas.clear();
    }

    public int getTabFromCoords(int x, int y) {
        for (int i = 0; i < this.tabAreas.size(); ++i) {
            if (!this.tabAreas.get(i).contains(x, y)) continue;
            return i;
        }
        return -1;
    }

    protected void func_73864_a(int x, int y, int button) throws IOException {
        int tabFromCoords;
        if (button == 0 && (tabFromCoords = this.getTabFromCoords(x, y)) >= 0 && this.doSwitchTab(tabFromCoords)) {
            SoundHelper.playSound((World)this.field_146297_k.field_71441_e, (Entity)this.field_146297_k.field_71439_g, (IModSound)SoundRegistry.TAB_SWITCH, 1.0f, 1.0f);
            return;
        }
        super.func_73864_a(x, y, button);
    }

    protected boolean doSwitchTab(int tab) {
        return false;
    }

    @Nonnull
    public Rectangle renderStdTab(int sx, int sy, int tabNo, boolean isActive) {
        return this.renderStdTab(sx, sy, tabNo, Prep.getEmpty(), null, null, isActive);
    }

    @Nonnull
    public Rectangle renderStdTab(int sx, int sy, int tabNo, @Nonnull ItemStack stack, boolean isActive) {
        return this.renderStdTab(sx, sy, tabNo, stack, null, null, isActive);
    }

    @Nonnull
    public Rectangle renderStdTab(int sx, int sy, int tabNo, @Nullable IWidgetIcon icon, boolean isActive) {
        return this.renderStdTab(sx, sy, tabNo, Prep.getEmpty(), icon, null, isActive);
    }

    @Nonnull
    public Rectangle renderStdTab(int sx, int sy, int tabNo, @Nullable GuiButton button, boolean isActive) {
        return this.renderStdTab(sx, sy, tabNo, Prep.getEmpty(), null, button, isActive);
    }

    @Nonnull
    public Rectangle renderStdTab(int sx, int sy, int tabNo, @Nonnull ItemStack stack, @Nullable GuiButton button, boolean isActive) {
        return this.renderStdTab(sx, sy, tabNo, stack, null, button, isActive);
    }

    @Nonnull
    public Rectangle renderStdTab(int sx, int sy, int tabNo, @Nullable IWidgetIcon icon, @Nullable GuiButton button, boolean isActive) {
        return this.renderStdTab(sx, sy, tabNo, Prep.getEmpty(), icon, button, isActive);
    }

    @Nonnull
    public Rectangle renderStdTab(int sx, int sy, int tabNo, @Nonnull ItemStack stack, @Nullable IWidgetIcon icon, @Nullable GuiButton button, boolean isActive) {
        int tabX = sx + this.field_146999_f + -3;
        int tabY = sy + 4 + 24 * tabNo;
        Rectangle result = this.renderTab(tabX, tabY, 24, stack, icon, isActive);
        while (this.tabAreas.size() <= tabNo) {
            this.tabAreas.add(NO_TAB);
        }
        this.tabAreas.set(tabNo, result);
        if (button != null) {
            button.field_146128_h = result.x;
            button.field_146129_i = result.y;
            button.field_146120_f = result.width;
            button.field_146121_g = result.height;
            button.field_146124_l = !isActive;
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        return result;
    }

    @Nonnull
    public Rectangle renderTab(int x, int y, int w, @Nonnull ItemStack stack, @Nullable IWidgetIcon icon, boolean isActive) {
        int bg_x = isActive ? 0 : 3;
        int bg_w = w - 3 - bg_x;
        int l_x = isActive ? 0 : 3;
        int l_w = w - 3 - l_x;
        int r_x = 3;
        int r_w = w - r_x;
        int r_u = IconEIO.TAB_FRAME_LEFT.width - r_w;
        if (isActive) {
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        } else {
            GlStateManager.func_179131_c((float)0.9f, (float)0.9f, (float)0.9f, (float)1.0f);
        }
        BufferBuilder tes = Tessellator.func_178181_a().func_178180_c();
        RenderUtil.bindTexture((ResourceLocation)IconEIO.map.getTexture());
        tes.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        this.renderTabPart(tes, x + bg_x, y, IconEIO.TAB_BG.getX() + bg_x, IconEIO.TAB_BG.getY(), bg_w, IconEIO.TAB_BG.getHeight());
        this.renderTabPart(tes, x + l_x, y, IconEIO.TAB_FRAME_LEFT.getX() + l_x, IconEIO.TAB_FRAME_LEFT.getY(), l_w, IconEIO.TAB_FRAME_LEFT.getHeight());
        this.renderTabPart(tes, x + r_x, y, IconEIO.TAB_FRAME_RIGHT.getX() + r_u, IconEIO.TAB_FRAME_RIGHT.getY(), r_w, IconEIO.TAB_FRAME_RIGHT.getHeight());
        if (icon != null) {
            icon.getMap().render(icon, (double)(x + w / 2 - 8), (double)(y + IconEIO.TAB_BG.getHeight() / 2 - 8), false);
        }
        Tessellator.func_178181_a().func_78381_a();
        if (Prep.isValid(stack)) {
            RenderHelper.func_74520_c();
            this.field_146296_j.func_175042_a(stack, x + w / 2 - 8, y + IconEIO.TAB_BG.getHeight() / 2 - 8);
            RenderHelper.func_74518_a();
        }
        return new Rectangle(x + bg_x, y - 1, bg_w + 3 + 1, IconEIO.TAB_BG.getHeight() + 2);
    }

    private void renderTabPart(@Nonnull BufferBuilder tes, int x, int y, int u, int v, int w, int h) {
        double minU = (double)u / (double)IconEIO.map.getSize();
        double maxU = (double)(u + w) / (double)IconEIO.map.getSize();
        double minV = (double)v / (double)IconEIO.map.getSize();
        double maxV = (double)(v + h) / (double)IconEIO.map.getSize();
        tes.func_181662_b((double)x, (double)(y + h), 0.0).func_187315_a(minU, maxV).func_181675_d();
        tes.func_181662_b((double)(x + w), (double)(y + h), 0.0).func_187315_a(maxU, maxV).func_181675_d();
        tes.func_181662_b((double)(x + w), (double)(y + 0), 0.0).func_187315_a(maxU, minV).func_181675_d();
        tes.func_181662_b((double)x, (double)(y + 0), 0.0).func_187315_a(minU, minV).func_181675_d();
    }

    @Override
    public void setGuiID(int id) {
        if (this.field_147002_h instanceof IRemoteExec.IContainer) {
            ((IRemoteExec.IContainer)this.field_147002_h).setGuiID(id);
        }
    }

    @Override
    public int getGuiID() {
        if (this.field_147002_h instanceof IRemoteExec.IContainer) {
            return ((IRemoteExec.IContainer)this.field_147002_h).getGuiID();
        }
        return -1;
    }

    public void func_73733_a(int left, int top, int right, int bottom, int startColor, int endColor) {
        super.func_73733_a(left, top, right, bottom, startColor, endColor);
    }
}

