/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.init;

import crazypants.enderio.api.IModObject;
import crazypants.enderio.api.IModTileEntity;
import crazypants.enderio.base.gui.handler.GuiHelper;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public interface IModObjectBase
extends IModObject {
    default public IModObject setRegistryName(ResourceLocation name) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Nonnull
    default public ResourceLocation getRegistryName() {
        return new ResourceLocation("enderio", this.getUnlocalisedName());
    }

    default public Class<IModObject> getRegistryType() {
        return IModObject.class;
    }

    @Override
    @Nonnull
    default public <B extends Block> B apply(@Nonnull B block) {
        block.func_149663_c(this.getUnlocalisedName());
        block.setRegistryName(this.getRegistryName());
        return block;
    }

    @Override
    @Nonnull
    default public <I extends Item> I apply(@Nonnull I item) {
        item.func_77655_b(this.getUnlocalisedName());
        item.setRegistryName(this.getRegistryName());
        return item;
    }

    @Override
    @Nullable
    default public Class<? extends TileEntity> getTEClass() {
        IModTileEntity tileEntity = this.getTileEntity();
        if (tileEntity != null) {
            return tileEntity.getTileEntityClass();
        }
        return null;
    }

    @Override
    default public boolean openGui(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull EntityPlayer entityPlayer) {
        return this.openGui(world, pos, entityPlayer, null, 0);
    }

    @Override
    default public boolean openGui(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull EntityPlayer entityPlayer, @Nullable EnumFacing side) {
        return this.openGui(world, pos, entityPlayer, side, 0);
    }

    @Override
    default public boolean openGui(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull EntityPlayer entityPlayer, @Nullable EnumFacing side, int param) {
        return GuiHelper.openGui((IModObject)this, world, pos, entityPlayer, side, param);
    }

    @Override
    default public boolean openGui(@Nonnull World world, @Nonnull EntityPlayer entityPlayer, int a, int b, int c) {
        return GuiHelper.openGui((IModObject)this, world, entityPlayer, a, b, c);
    }

    @Override
    default public boolean openClientGui(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull EntityPlayer entityPlayer, @Nullable EnumFacing side, int param) {
        return GuiHelper.openClientGui((IModObject)this, world, pos, entityPlayer, side, param);
    }

    @Override
    default public boolean openClientGui(@Nonnull World world, @Nonnull EntityPlayer entityPlayer, int a, int b, int c) {
        return GuiHelper.openClientGui((IModObject)this, world, entityPlayer, a, b, c);
    }
}

