/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.integration.top;

import com.enderio.core.api.client.render.IWidgetIcon;
import com.enderio.core.api.common.util.IProgressTile;
import com.enderio.core.api.common.util.ITankAccess;
import com.enderio.core.client.render.BoundingBox;
import com.enderio.core.common.inventory.EnderInventory;
import com.enderio.core.common.inventory.InventorySlot;
import com.enderio.core.common.util.UserIdent;
import crazypants.enderio.api.ILocalizable;
import crazypants.enderio.base.block.painted.TileEntityTwicePaintedBlock;
import crazypants.enderio.base.conduit.IConduitBundle;
import crazypants.enderio.base.machine.base.te.AbstractCapabilityMachineEntity;
import crazypants.enderio.base.machine.base.te.AbstractCapabilityPoweredMachineEntity;
import crazypants.enderio.base.machine.base.te.AbstractMachineEntity;
import crazypants.enderio.base.machine.baselegacy.AbstractPoweredTaskEntity;
import crazypants.enderio.base.machine.interfaces.IHasFillLevel;
import crazypants.enderio.base.machine.interfaces.IIoConfigurable;
import crazypants.enderio.base.machine.interfaces.INotifier;
import crazypants.enderio.base.machine.interfaces.IRedstoneModeControlable;
import crazypants.enderio.base.machine.modes.EntityAction;
import crazypants.enderio.base.machine.modes.IoMode;
import crazypants.enderio.base.machine.modes.RedstoneControlMode;
import crazypants.enderio.base.machine.task.ContinuousTask;
import crazypants.enderio.base.paint.IPaintable;
import crazypants.enderio.base.paint.PaintUtil;
import crazypants.enderio.base.power.EnergyTank;
import crazypants.enderio.base.power.ILegacyPoweredTile;
import crazypants.enderio.base.power.IPowerStorage;
import crazypants.enderio.base.render.ranged.IRanged;
import crazypants.enderio.base.xp.ExperienceContainer;
import crazypants.enderio.base.xp.IHaveExperience;
import crazypants.enderio.util.CapturedMob;
import crazypants.enderio.util.Prep;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.annotation.Nonnull;
import mcjty.theoneprobe.api.IProbeHitData;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;

class TOPData {
    boolean hasStatus;
    boolean hasProgress;
    boolean hasRF;
    boolean hasRedstone;
    boolean hasIOMode;
    boolean hasRange;
    boolean hasMobs;
    boolean hasXP;
    boolean hasRFIO;
    boolean hasItemFillLevel;
    boolean isActive;
    boolean isPowered;
    boolean redstoneControlStatus;
    boolean isPainted;
    float progress;
    long rf;
    long maxrf;
    long fillMax;
    long fillCur;
    int experienceLevel;
    int xpBarScaled;
    int maxRFIn;
    int maxRFOut;
    int avgRF;
    String redstoneTooltip;
    String sideName;
    String mobAction;
    IWidgetIcon redstoneIcon;
    IoMode ioMode;
    BoundingBox bounds;
    List<CapturedMob> mobs;
    ProgressResult progressResult = ProgressResult.NONE;
    List<ITankAccess.ITankData> tankData = null;
    @Nonnull
    ItemStack paint1 = Prep.getEmpty();
    @Nonnull
    ItemStack paint2 = Prep.getEmpty();
    UserIdent owner = null;
    Set<? extends ILocalizable> notifications = null;

    TOPData(TileEntity tileEntity, IProbeHitData hitData) {
        Object te;
        if (tileEntity instanceof AbstractMachineEntity) {
            te = (AbstractMachineEntity)tileEntity;
            this.isActive = ((AbstractMachineEntity)te).isActive();
            this.hasStatus = true;
            this.owner = ((AbstractMachineEntity)te).getOwner();
        }
        if (tileEntity instanceof IPowerStorage) {
            te = (IPowerStorage)tileEntity;
            this.maxrf = te.getMaxEnergyStoredL();
            this.rf = te.getEnergyStoredL();
            te.getMaxInput();
            this.hasRF = this.maxrf > 0L;
            this.isPowered = this.hasRF;
            this.hasRFIO = this.hasRF;
            this.maxRFIn = te.getMaxInput();
            this.maxRFOut = te.getMaxOutput();
            this.avgRF = te.getAverageIOPerTick();
        } else if (tileEntity instanceof ILegacyPoweredTile) {
            te = (ILegacyPoweredTile)tileEntity;
            if (te.displayPower()) {
                this.maxrf = te.getMaxEnergyStored();
                this.rf = te.getEnergyStored();
                this.isPowered = this.rf > 0L;
                this.hasRF = this.maxrf > 0L;
            }
        } else if (tileEntity instanceof AbstractCapabilityPoweredMachineEntity) {
            EnergyTank energy = ((AbstractCapabilityPoweredMachineEntity)tileEntity).getEnergy();
            this.maxrf = energy.getMaxEnergyStored();
            this.rf = energy.getEnergyStored();
            this.isPowered = this.rf > 0L;
            boolean bl = this.hasRF = this.maxrf > 0L;
        }
        if (tileEntity instanceof IProgressTile) {
            IProgressTile progressTile = (IProgressTile)tileEntity;
            this.progress = progressTile.getProgress();
            this.hasProgress = true;
            if (tileEntity instanceof AbstractPoweredTaskEntity) {
                AbstractPoweredTaskEntity te2 = (AbstractPoweredTaskEntity)tileEntity;
                if (te2.getCurrentTask() instanceof ContinuousTask) {
                    this.hasProgress = false;
                }
            } else if (tileEntity instanceof IConduitBundle) {
                this.hasProgress = false;
            }
        }
        if (tileEntity instanceof IRedstoneModeControlable) {
            te = (IRedstoneModeControlable)tileEntity;
            RedstoneControlMode redstoneControlMode = te.getRedstoneControlMode();
            this.redstoneControlStatus = te.getRedstoneControlStatus();
            RedstoneControlMode.IconHolder iconHolder = RedstoneControlMode.IconHolder.getFromMode(redstoneControlMode);
            this.redstoneIcon = iconHolder.getIcon();
            this.redstoneTooltip = iconHolder.getUnlocalizedTooltip();
            this.hasRedstone = true;
        }
        if (tileEntity instanceof IIoConfigurable) {
            te = (IIoConfigurable)tileEntity;
            this.sideName = hitData.getSideHit().name().toLowerCase(Locale.US);
            this.ioMode = te.getIoMode(hitData.getSideHit());
            this.hasIOMode = true;
        }
        if (tileEntity instanceof IRanged) {
            te = (IRanged)tileEntity;
            this.bounds = te.getBounds();
            this.hasRange = true;
        }
        if (tileEntity instanceof EntityAction.Implementer) {
            te = (EntityAction.Implementer)tileEntity;
            this.mobs = te.getEntities();
            this.mobAction = te.getEntityAction().getActionString();
            boolean bl = this.hasMobs = !this.mobs.isEmpty();
        }
        if (tileEntity instanceof ITankAccess.IExtendedTankAccess) {
            this.tankData = ((ITankAccess.IExtendedTankAccess)tileEntity).getTankDisplayData();
        }
        if (tileEntity instanceof IHaveExperience) {
            ExperienceContainer experienceContainer = ((IHaveExperience)tileEntity).getContainer();
            this.hasXP = experienceContainer.getMaximumExperiance() > 0;
            this.experienceLevel = experienceContainer.getExperienceLevel();
            this.xpBarScaled = experienceContainer.getXpBarScaled(100);
        }
        if (tileEntity instanceof IPaintable.IPaintableTileEntity) {
            this.paint1 = PaintUtil.getPaintAsStack(((IPaintable.IPaintableTileEntity)tileEntity).getPaintSource());
            if (tileEntity instanceof TileEntityTwicePaintedBlock) {
                this.paint2 = PaintUtil.getPaintAsStack(((TileEntityTwicePaintedBlock)tileEntity).getPaintSource2());
            }
            boolean bl = this.isPainted = Prep.isValid(this.paint1) || Prep.isValid(this.paint2);
        }
        if (tileEntity instanceof IHasFillLevel) {
            this.fillCur = 0L;
            this.fillMax = 0L;
            for (InventorySlot slot : ((AbstractCapabilityMachineEntity)tileEntity).getInventory().getView(EnderInventory.Type.INOUT)) {
                if (Prep.isValid(slot.getStackInSlot(0))) {
                    this.fillMax += (long)Math.min(slot.getMaxStackSize(), slot.getStackInSlot(0).func_77976_d());
                    this.fillCur += (long)slot.getStackInSlot(0).func_190916_E();
                    continue;
                }
                this.fillMax += (long)slot.getMaxStackSize();
            }
            this.hasItemFillLevel = true;
        }
        if (tileEntity instanceof INotifier) {
            this.notifications = ((INotifier)tileEntity).getNotification();
        }
        this.calculateProgress();
    }

    private void calculateProgress() {
        if (this.hasProgress) {
            this.progressResult = this.progress > 0.0f ? (this.hasRF && !this.isPowered ? ProgressResult.PROGRESS_NO_POWER : ProgressResult.PROGRESS) : (this.hasStatus && this.isActive ? ProgressResult.PROGRESS_ACTIVE : ProgressResult.PROGRESS_IDLE);
        } else if (this.hasStatus) {
            this.progressResult = this.isActive ? ProgressResult.NO_PROGRESS_ACTIVE : ProgressResult.NO_PROGRESS_IDLE;
        }
    }

    static enum ProgressResult {
        NONE,
        PROGRESS,
        PROGRESS_ACTIVE,
        PROGRESS_NO_POWER,
        PROGRESS_IDLE,
        NO_PROGRESS_ACTIVE,
        NO_PROGRESS_IDLE;

    }
}

