/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.item.conduitprobe;

import com.enderio.core.api.client.render.IWidgetIcon;
import crazypants.enderio.base.gui.IconEIO;
import crazypants.enderio.base.init.ModObject;
import crazypants.enderio.util.Prep;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.lwjgl.opengl.GL11;

public class ConduitProbeOverlayRenderer {
    @SubscribeEvent
    public void renderOverlay(@Nonnull RenderGameOverlayEvent.Post event) {
        ItemStack equippedProbe = this.getEquippedProbe();
        if (event.getType() == RenderGameOverlayEvent.ElementType.ALL && Prep.isValid(equippedProbe)) {
            this.doRenderOverlay((RenderGameOverlayEvent)event, equippedProbe);
        }
    }

    @Nonnull
    private ItemStack getEquippedProbe() {
        ItemStack equipped = Minecraft.func_71410_x().field_71439_g.func_184614_ca();
        if (equipped.func_77973_b() == ModObject.itemConduitProbe.getItem()) {
            return equipped;
        }
        return Prep.getEmpty();
    }

    private void doRenderOverlay(RenderGameOverlayEvent event, @Nonnull ItemStack equippedProbe) {
        IconEIO icon2;
        IconEIO icon1;
        if (equippedProbe.func_77952_i() == 0) {
            icon1 = IconEIO.PROBE_OVERLAY_PROBE;
            icon2 = IconEIO.PROBE_OVERLAY_COPY_OFF;
        } else {
            icon1 = IconEIO.PROBE_OVERLAY_PROBE_OFF;
            icon2 = IconEIO.PROBE_OVERLAY_COPY;
        }
        ScaledResolution res = event.getResolution();
        double offsetX = res.func_78326_a() - 48;
        double offsetY = res.func_78328_b() - 16;
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.75f);
        icon1.getMap().render((IWidgetIcon)icon1, offsetX - 32.0, offsetY - 32.0, 32.0, 32.0, 0.0, true);
        icon2.getMap().render((IWidgetIcon)icon2, offsetX, offsetY - 32.0, 32.0, 32.0, 0.0, true);
    }
}

