/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.item.darksteel;

import com.enderio.core.api.client.gui.IAdvancedTooltipProvider;
import com.enderio.core.client.handlers.SpecialTooltipHandler;
import com.enderio.core.common.transform.EnderCoreMethods;
import com.enderio.core.common.util.ItemUtil;
import com.enderio.core.common.util.NullHelper;
import com.enderio.core.common.util.OreDictionaryHelper;
import com.google.common.collect.Multimap;
import crazypants.enderio.api.IModObject;
import crazypants.enderio.api.capacitor.ICapacitorKey;
import crazypants.enderio.api.teleport.IItemOfTravel;
import crazypants.enderio.api.teleport.TravelSource;
import crazypants.enderio.api.upgrades.IDarkSteelItem;
import crazypants.enderio.api.upgrades.IDarkSteelUpgrade;
import crazypants.enderio.api.upgrades.IEquipmentData;
import crazypants.enderio.base.EnderIO;
import crazypants.enderio.base.EnderIOTab;
import crazypants.enderio.base.capacitor.CapacitorKey;
import crazypants.enderio.base.config.config.DarkSteelConfig;
import crazypants.enderio.base.config.config.TeleportConfig;
import crazypants.enderio.base.handler.darksteel.DarkSteelRecipeManager;
import crazypants.enderio.base.handler.darksteel.PlayerAOEAttributeHandler;
import crazypants.enderio.base.item.darksteel.attributes.EquipmentData;
import crazypants.enderio.base.item.darksteel.upgrade.energy.EnergyUpgrade;
import crazypants.enderio.base.item.darksteel.upgrade.energy.EnergyUpgradeManager;
import crazypants.enderio.base.item.darksteel.upgrade.explosive.ExplosiveCarpetUpgrade;
import crazypants.enderio.base.item.darksteel.upgrade.explosive.ExplosiveDepthUpgrade;
import crazypants.enderio.base.item.darksteel.upgrade.explosive.ExplosiveTargets;
import crazypants.enderio.base.item.darksteel.upgrade.explosive.ExplosiveUpgrade;
import crazypants.enderio.base.item.darksteel.upgrade.spoon.SpoonUpgrade;
import crazypants.enderio.base.item.darksteel.upgrade.travel.TravelUpgrade;
import crazypants.enderio.base.lang.Lang;
import crazypants.enderio.base.lang.LangPower;
import crazypants.enderio.base.network.PacketSpawnParticles;
import crazypants.enderio.base.render.itemoverlay.PowerBarOverlayRenderHelper;
import crazypants.enderio.base.teleport.TravelController;
import crazypants.enderio.util.Prep;
import info.loenwind.autoconfig.factory.IValue;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemPickaxe;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.GameType;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemDarkSteelPickaxe
extends ItemPickaxe
implements IAdvancedTooltipProvider,
IDarkSteelItem,
IItemOfTravel,
EnderCoreMethods.IOverlayRenderAware {
    private long lastBlickTick = -1L;
    @Nonnull
    private final IEquipmentData data;
    @Nonnull
    private static final Set<String> TOOL_CLASS_PICK = Collections.singleton("pickaxe");
    @Nonnull
    private static final Set<String> TOOL_CLASS_INTERNAL = new HashSet<String>(TOOL_CLASS_PICK);
    @Nonnull
    private static final Set<String> TOOL_CLASS_SPOON;

    public static int getStoredPower(EntityPlayer player) {
        return EnergyUpgradeManager.getEnergyStored(player.func_184614_ca());
    }

    public static ItemDarkSteelPickaxe createEndSteel(@Nonnull IModObject modObject) {
        ItemDarkSteelPickaxe res = new ItemDarkSteelPickaxe(modObject, EquipmentData.END_STEEL);
        MinecraftForge.EVENT_BUS.register((Object)res);
        return res;
    }

    public static ItemDarkSteelPickaxe createDarkSteel(@Nonnull IModObject modObject) {
        ItemDarkSteelPickaxe res = new ItemDarkSteelPickaxe(modObject, EquipmentData.DARK_STEEL);
        MinecraftForge.EVENT_BUS.register((Object)res);
        return res;
    }

    public static ItemDarkSteelPickaxe createStellarAlloy(@Nonnull IModObject modObject) {
        ItemDarkSteelPickaxe res = new ItemDarkSteelPickaxe(modObject, EquipmentData.STELLAR_ALLOY);
        MinecraftForge.EVENT_BUS.register((Object)res);
        return res;
    }

    public ItemDarkSteelPickaxe(@Nonnull IModObject modObject, @Nonnull IEquipmentData data) {
        super(data.getToolMaterial());
        this.func_77637_a(EnderIOTab.tabEnderIOItems);
        modObject.apply(this);
        this.data = data;
    }

    public void func_150895_a(@Nonnull CreativeTabs tab, @Nonnull NonNullList<ItemStack> list) {
        if (this.func_194125_a(tab)) {
            ItemStack is = new ItemStack((Item)this);
            list.add((Object)is);
            is = new ItemStack((Item)this);
            ((EnergyUpgrade)EnergyUpgrade.UPGRADES.get(3)).addToItem(is, this);
            EnergyUpgradeManager.setPowerFull(is, this);
            TravelUpgrade.INSTANCE.addToItem(is, this);
            SpoonUpgrade.INSTANCE.addToItem(is, this);
            ExplosiveUpgrade.INSTANCE.addToItem(is, this);
            list.add((Object)is);
            is = new ItemStack((Item)this);
            ((EnergyUpgrade)EnergyUpgrade.UPGRADES.get(3)).addToItem(is, this);
            EnergyUpgradeManager.setPowerFull(is, this);
            TravelUpgrade.INSTANCE.addToItem(is, this);
            SpoonUpgrade.INSTANCE.addToItem(is, this);
            ExplosiveUpgrade.INSTANCE5.addToItem(is, this);
            ExplosiveDepthUpgrade.INSTANCE.addToItem(is, this);
            ExplosiveCarpetUpgrade.INSTANCE.addToItem(is, this);
            list.add((Object)is);
        }
    }

    @Override
    public int getIngotsRequiredForFullRepair() {
        return 3;
    }

    @Override
    public boolean isItemForRepair(@Nonnull ItemStack right) {
        return OreDictionaryHelper.hasName((ItemStack)right, (String)this.data.getRepairIngotOredict());
    }

    public boolean func_179218_a(@Nonnull ItemStack item, @Nonnull World world, @Nonnull IBlockState bs, @Nonnull BlockPos pos, @Nonnull EntityLivingBase entityLiving) {
        if ((double)bs.func_185887_b(world, pos) != 0.0 && this.useObsidianEffeciency(item, bs)) {
            this.extractInternal(item, DarkSteelConfig.pickPowerUseObsidian);
        }
        if (!entityLiving.func_70093_af() && entityLiving instanceof EntityPlayerMP && PlayerAOEAttributeHandler.hasAOE((EntityPlayer)((EntityPlayerMP)entityLiving))) {
            this.doExplosiveAction(item, world, pos, (EntityPlayerMP)entityLiving);
        }
        return super.func_179218_a(item, world, bs, pos, entityLiving);
    }

    @Nullable
    public RayTraceResult func_77621_a(@Nonnull World worldIn, @Nonnull EntityPlayer playerIn, boolean useLiquids) {
        return super.func_77621_a(worldIn, playerIn, useLiquids);
    }

    @Nonnull
    public EnumActionResult func_180614_a(@Nonnull EntityPlayer player, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull EnumHand hand, @Nonnull EnumFacing side, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            if (((Boolean)DarkSteelConfig.rightClickPlaceEnabled_pick.get()).booleanValue()) {
                return ItemDarkSteelPickaxe.doRightClickItemPlace(player, world, pos, side, hand, hitX, hitX, hitX);
            }
            if (this.doTravelAction(player.func_184586_b(hand), world, player, hand) != null) {
                return EnumActionResult.SUCCESS;
            }
        }
        return EnumActionResult.PASS;
    }

    @SideOnly(value=Side.CLIENT)
    @Nonnull
    static EnumActionResult doRightClickItemPlace(@Nonnull EntityPlayer player, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull EnumFacing side, @Nonnull EnumHand hand, float par8, float par9, float par10) {
        int slot;
        if (hand != EnumHand.MAIN_HAND) {
            return EnumActionResult.PASS;
        }
        int current = player.field_71071_by.field_70461_c;
        int n = slot = current == 0 && (Boolean)DarkSteelConfig.slotZeroPlacesEight.get() != false ? 8 : current + 1;
        if (slot < InventoryPlayer.func_70451_h() && !(((ItemStack)player.field_71071_by.field_70462_a.get(slot)).func_77973_b() instanceof IDarkSteelItem)) {
            player.field_71071_by.field_70461_c = slot;
            Minecraft mc = Minecraft.func_71410_x();
            EnumActionResult result = mc.field_71442_b.func_187099_a(mc.field_71439_g, mc.field_71441_e, pos, side, new Vec3d((double)par8, (double)par9, (double)par10), hand);
            player.field_71071_by.field_70461_c = current;
            return result;
        }
        return EnumActionResult.PASS;
    }

    public void setDamage(@Nonnull ItemStack stack, int newDamage) {
        int oldDamage = this.getDamage(stack);
        if (newDamage <= oldDamage) {
            super.setDamage(stack, newDamage);
        } else {
            int damage = newDamage - oldDamage;
            if (!this.absorbDamageWithEnergy(stack, damage * (Integer)DarkSteelConfig.pickPowerUsePerDamagePoint.get())) {
                super.setDamage(stack, newDamage);
            }
        }
    }

    private boolean absorbDamageWithEnergy(@Nonnull ItemStack stack, int amount) {
        EnergyUpgrade.EnergyUpgradeHolder eu = EnergyUpgradeManager.loadFromItem(stack);
        if (eu != null && eu.isAbsorbDamageWithPower() && eu.getEnergy() > 0) {
            eu.extractEnergy(amount, false);
            eu.writeToItem();
            return true;
        }
        return false;
    }

    public boolean canHarvestBlock(@Nonnull IBlockState block, @Nonnull ItemStack item) {
        if (this.hasSpoonUpgrade(item) && this.getEnergyStored(item) > 0) {
            return block.func_177230_c() == Blocks.field_150431_aC || block.func_177230_c() == Blocks.field_150433_aE || super.canHarvestBlock(block, item);
        }
        return super.canHarvestBlock(block, item);
    }

    private boolean hasSpoonUpgrade(@Nonnull ItemStack item) {
        return SpoonUpgrade.INSTANCE.hasUpgrade(item);
    }

    public float func_150893_a(@Nonnull ItemStack stack, @Nonnull IBlockState state) {
        if (state.func_185904_a() == Material.field_151592_s) {
            return this.field_77862_b.func_77998_b();
        }
        if (this.useObsidianEffeciency(stack, state)) {
            return this.field_77862_b.func_77998_b() + ((Float)DarkSteelConfig.pickEfficiencyBoostWhenPowered.get()).floatValue() + (float)((Integer)DarkSteelConfig.pickEfficiencyObsidian.get()).intValue();
        }
        if (ItemDarkSteelPickaxe.isToolEffective(state, stack)) {
            if ((Integer)DarkSteelConfig.pickPowerUsePerDamagePoint.get() <= 0 ? EnergyUpgradeManager.itemHasAnyPowerUpgrade(stack) : EnergyUpgradeManager.getEnergyStored(stack) > 0) {
                return this.field_77862_b.func_77998_b() + ((Float)DarkSteelConfig.pickEfficiencyBoostWhenPowered.get()).floatValue();
            }
            return this.field_77862_b.func_77998_b();
        }
        return super.func_150893_a(stack, state);
    }

    public static boolean isToolEffective(@Nonnull IBlockState state, @Nonnull ItemStack stack) {
        for (String type : stack.func_77973_b().getToolClasses(stack)) {
            if (!state.func_177230_c().isToolEffective((String)NullHelper.notnull((Object)type, (String)"getToolClasses() derped"), state)) continue;
            return true;
        }
        return false;
    }

    private boolean useObsidianEffeciency(@Nonnull ItemStack item, @Nonnull IBlockState blockState) {
        boolean useObsidianSpeed = false;
        int energy = this.getEnergyStored(item);
        if (energy > (Integer)DarkSteelConfig.pickPowerUseObsidian.get()) {
            boolean bl = useObsidianSpeed = blockState.func_177230_c() == Blocks.field_150343_Z;
            if (!useObsidianSpeed && ((Float)DarkSteelConfig.pickApplyObsidianEfficiencyAtHardness.get()).floatValue() > 0.0f) {
                try {
                    useObsidianSpeed = blockState.func_185887_b(null, new BlockPos(-1, -1, -1)) >= ((Float)DarkSteelConfig.pickApplyObsidianEfficiencyAtHardness.get()).floatValue();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return useObsidianSpeed;
    }

    @Nonnull
    public Set<String> getToolClasses(@Nonnull ItemStack stack) {
        return this.hasSpoonUpgrade(stack) ? TOOL_CLASS_SPOON : TOOL_CLASS_PICK;
    }

    @Override
    public int getEnergyStored(@Nonnull ItemStack container) {
        return EnergyUpgradeManager.getEnergyStored(container);
    }

    public boolean func_82789_a(@Nonnull ItemStack i1, @Nonnull ItemStack i2) {
        return false;
    }

    public void addCommonEntries(@Nonnull ItemStack itemstack, @Nullable EntityPlayer entityplayer, @Nonnull List<String> list, boolean flag) {
        DarkSteelRecipeManager.addCommonTooltipEntries(itemstack, entityplayer, list, flag);
    }

    public void addBasicEntries(@Nonnull ItemStack itemstack, @Nullable EntityPlayer entityplayer, @Nonnull List<String> list, boolean flag) {
        DarkSteelRecipeManager.addBasicTooltipEntries(itemstack, entityplayer, list, flag);
    }

    public void addDetailedEntries(@Nonnull ItemStack itemstack, @Nullable EntityPlayer entityplayer, @Nonnull List<String> list, boolean flag) {
        String str;
        if (!SpecialTooltipHandler.showDurability((boolean)flag)) {
            list.add(ItemUtil.getDurabilityString((ItemStack)itemstack));
        }
        if ((str = EnergyUpgradeManager.getStoredEnergyString(itemstack)) != null) {
            list.add(str);
        }
        if (EnergyUpgradeManager.itemHasAnyPowerUpgrade(itemstack)) {
            list.add(Lang.PICK_POWERED.get(TextFormatting.WHITE, DarkSteelConfig.pickEfficiencyBoostWhenPowered.get()));
            list.add(Lang.PICK_OBSIDIAN.get(TextFormatting.WHITE, DarkSteelConfig.pickEfficiencyObsidian.get()));
            list.add(Lang.PICK_OBSIDIAN_COST.get(TextFormatting.WHITE, LangPower.RF((Integer)DarkSteelConfig.pickPowerUseObsidian.get())));
        }
        DarkSteelRecipeManager.addAdvancedTooltipEntries(itemstack, entityplayer, list, flag);
    }

    @Override
    public boolean isActive(@Nonnull EntityPlayer ep, @Nonnull ItemStack equipped) {
        return this.isTravelUpgradeActive(ep, equipped, EnumHand.MAIN_HAND) || this.isTravelUpgradeActive(ep, equipped, EnumHand.OFF_HAND);
    }

    @Override
    public void extractInternal(@Nonnull ItemStack equipped, int power) {
        EnergyUpgradeManager.extractEnergy(equipped, (IDarkSteelItem)this, power, false);
    }

    @Override
    public void extractInternal(@Nonnull ItemStack equipped, IValue<Integer> power) {
        EnergyUpgradeManager.extractEnergy(equipped, (IDarkSteelItem)this, power, false);
    }

    private boolean isTravelUpgradeActive(@Nonnull EntityPlayer ep, @Nonnull ItemStack equipped, @Nonnull EnumHand hand) {
        return ep.func_70093_af() && TravelUpgrade.INSTANCE.hasUpgrade(equipped);
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(@Nonnull World world, @Nonnull EntityPlayer player, @Nonnull EnumHand hand) {
        ActionResult doTravelAction = this.doTravelAction(player.func_184586_b(hand), world, player, hand);
        return doTravelAction != null ? doTravelAction : super.func_77659_a(world, player, hand);
    }

    protected ActionResult<ItemStack> doTravelAction(@Nonnull ItemStack stack, @Nonnull World world, @Nonnull EntityPlayer player, @Nonnull EnumHand hand) {
        if (this.isTravelUpgradeActive(player, stack, hand)) {
            if (world.field_72995_K && TravelController.instance.activateTravelAccessable(stack, hand, world, player, TravelSource.STAFF)) {
                player.func_184609_a(hand);
                return new ActionResult(EnumActionResult.PASS, (Object)stack);
            }
            long ticksSinceBlink = EnderIO.proxy.getTickCount() - this.lastBlickTick;
            if (ticksSinceBlink < 0L) {
                this.lastBlickTick = -1L;
            }
            if (((Boolean)TeleportConfig.enableBlink.get()).booleanValue() && world.field_72995_K && ticksSinceBlink >= (long)((Integer)TeleportConfig.blinkDelay.get()).intValue() && TravelController.instance.doBlink(stack, hand, player)) {
                player.func_184609_a(hand);
                this.lastBlickTick = EnderIO.proxy.getTickCount();
            }
            return new ActionResult(EnumActionResult.PASS, (Object)stack);
        }
        return null;
    }

    public void renderItemOverlayIntoGUI(@Nonnull ItemStack stack, int xPosition, int yPosition) {
        PowerBarOverlayRenderHelper.instance_upgradeable.render(stack, xPosition, yPosition);
    }

    public boolean shouldCauseReequipAnimation(@Nonnull ItemStack oldStack, @Nonnull ItemStack newStack, boolean slotChanged) {
        return slotChanged || Prep.isInvalid(oldStack) || Prep.isInvalid(newStack) || oldStack.func_77973_b() != newStack.func_77973_b();
    }

    private static final float notBedrock(float i) {
        return i >= 0.0f ? i : Float.MAX_VALUE;
    }

    private void doExplosiveAction(@Nonnull ItemStack item, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull EntityPlayerMP player) {
        boolean hasDoneSomething = false;
        float referenceHardness = world.func_180495_p(pos).func_185887_b(world, pos);
        boolean withSpoon = this.hasSpoonUpgrade(item);
        GameType gameType = player.field_71134_c.func_73081_b();
        int cost = (Integer)DarkSteelConfig.explosiveUpgradeEnergyPerBlock.get();
        PacketSpawnParticles effect = new PacketSpawnParticles();
        Iterator<BlockPos> itr = PlayerAOEAttributeHandler.getAOE(pos, (EntityPlayer)player);
        while (this.getEnergyStored(item) >= cost && itr.hasNext()) {
            int exp;
            BlockPos target = itr.next();
            if (target == null) continue;
            IBlockState blockstate = world.func_180495_p(target);
            Block block = blockstate.func_177230_c();
            if (!((ExplosiveTargets)((Object)DarkSteelConfig.explosiveUpgradeTargets.get())).matches(block, withSpoon) || !(referenceHardness >= ItemDarkSteelPickaxe.notBedrock(blockstate.func_185887_b(world, target))) || !ItemDarkSteelPickaxe.isToolEffective(blockstate, item) && !ForgeHooks.canHarvestBlock((Block)block, (EntityPlayer)player, (IBlockAccess)world, (BlockPos)target) || (exp = ForgeHooks.onBlockBreakEvent((World)world, (GameType)gameType, (EntityPlayerMP)player, (BlockPos)target)) == -1 || !block.canHarvestBlock((IBlockAccess)world, target, (EntityPlayer)player) || !block.removedByPlayer(blockstate, world, target, (EntityPlayer)player, true)) continue;
            block.func_176206_d(world, target, blockstate);
            block.func_180657_a(world, (EntityPlayer)player, target, blockstate, null, item);
            if (!gameType.func_77145_d() && exp > 0) {
                block.func_180637_b(world, target, exp);
            }
            this.extractInternal(item, cost);
            if (field_77697_d.nextFloat() < ((Float)DarkSteelConfig.explosiveUpgradeDurabilityChance.get()).floatValue()) {
                super.func_179218_a(item, world, blockstate, target, (EntityLivingBase)player);
            }
            hasDoneSomething = true;
            if (field_77697_d.nextFloat() < 0.3f) {
                effect.add(target, 1, EnumParticleTypes.EXPLOSION_NORMAL, EnumParticleTypes.SMOKE_NORMAL);
                continue;
            }
            if (!(field_77697_d.nextFloat() < 0.5f)) continue;
            effect.add(target, 1, EnumParticleTypes.SMOKE_NORMAL);
        }
        if (hasDoneSomething) {
            effect.add(pos, 1, EnumParticleTypes.EXPLOSION_LARGE);
            effect.send(world, pos);
        }
    }

    public boolean shouldCauseBlockBreakReset(@Nonnull ItemStack oldStack, @Nonnull ItemStack newStack) {
        if (!super.shouldCauseBlockBreakReset(oldStack, newStack)) {
            return false;
        }
        if (oldStack.func_190926_b() != newStack.func_190926_b() || oldStack.func_77942_o() != newStack.func_77942_o() || newStack.func_77973_b() != oldStack.func_77973_b() || newStack.func_77984_f() && newStack.func_77960_j() != oldStack.func_77960_j()) {
            return true;
        }
        if (!oldStack.func_77942_o() && !newStack.func_77942_o()) {
            return false;
        }
        return !EnergyUpgradeManager.compareNbt(oldStack.func_77978_p(), newStack.func_77978_p());
    }

    @Override
    public boolean isForSlot(@Nonnull EntityEquipmentSlot slot) {
        return slot == EntityEquipmentSlot.MAINHAND;
    }

    @Override
    public boolean isPickaxe() {
        return true;
    }

    @Override
    public boolean hasUpgradeCallbacks(@Nonnull IDarkSteelUpgrade upgrade) {
        return upgrade == ExplosiveUpgrade.INSTANCE || upgrade == SpoonUpgrade.INSTANCE || upgrade == TravelUpgrade.INSTANCE;
    }

    @Override
    @Nonnull
    public IEquipmentData getEquipmentData() {
        return this.data;
    }

    @Override
    @Nonnull
    public ICapacitorKey getEnergyStorageKey(@Nonnull ItemStack stack) {
        return CapacitorKey.DARK_STEEL_PICKAXE_ENERGY_BUFFER;
    }

    @Override
    @Nonnull
    public ICapacitorKey getEnergyInputKey(@Nonnull ItemStack stack) {
        return CapacitorKey.DARK_STEEL_PICKAXE_ENERGY_INPUT;
    }

    @Override
    @Nonnull
    public ICapacitorKey getEnergyUseKey(@Nonnull ItemStack stack) {
        return CapacitorKey.DARK_STEEL_PICKAXE_ENERGY_USE;
    }

    @Override
    @Nonnull
    public ICapacitorKey getAbsorptionRatioKey(@Nonnull ItemStack stack) {
        return CapacitorKey.DARK_STEEL_PICKAXE_ABSORPTION_RATIO;
    }

    @Nonnull
    public Multimap<String, AttributeModifier> getAttributeModifiers(@Nonnull EntityEquipmentSlot slot, @Nonnull ItemStack stack) {
        return this.addAttributeModifiers(slot, stack, super.getAttributeModifiers(slot, stack));
    }

    static {
        TOOL_CLASS_INTERNAL.add("shovel");
        TOOL_CLASS_SPOON = Collections.unmodifiableSet(TOOL_CLASS_INTERNAL);
    }
}

