/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.item.darksteel.upgrade.direct;

import com.enderio.core.common.util.NullHelper;
import crazypants.enderio.api.upgrades.IDarkSteelItem;
import crazypants.enderio.api.upgrades.IDarkSteelUpgrade;
import crazypants.enderio.base.config.config.DarkSteelConfig;
import crazypants.enderio.base.handler.darksteel.AbstractUpgrade;
import crazypants.enderio.base.item.darksteel.upgrade.energy.EnergyUpgradeManager;
import crazypants.enderio.base.material.alloy.Alloy;
import java.util.Iterator;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber(modid="enderio")
public class DirectUpgrade
extends AbstractUpgrade {
    @Nonnull
    private static final String UPGRADE_NAME = "direct";
    private static final Random random = new Random();
    @Nonnull
    public static final DirectUpgrade INSTANCE = new DirectUpgrade();

    @SubscribeEvent
    public static void registerDarkSteelUpgrades(@Nonnull RegistryEvent.Register<IDarkSteelUpgrade> event) {
        event.getRegistry().register((IForgeRegistryEntry)INSTANCE);
    }

    public DirectUpgrade() {
        super(UPGRADE_NAME, 0, "enderio.darksteel.upgrade.direct", Alloy.VIBRANT_ALLOY.getStackBlock(), DarkSteelConfig.directCost);
    }

    @Override
    public boolean canAddToItem(@Nonnull ItemStack stack, @Nonnull IDarkSteelItem item) {
        return item.isForSlot(EntityEquipmentSlot.MAINHAND) && EnergyUpgradeManager.itemHasAnyPowerUpgrade(stack) && !this.hasAnyUpgradeVariant(stack);
    }

    @Override
    public boolean canOtherBeRemoved(@Nonnull ItemStack stack, @Nonnull IDarkSteelItem item, @Nonnull IDarkSteelUpgrade other) {
        return !EnergyUpgradeManager.isLowestPowerUpgrade(other);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void blockDropEvent(BlockEvent.HarvestDropsEvent event) {
        if (event.getHarvester() == null) {
            return;
        }
        for (EnumHand hand : EnumHand.values()) {
            ItemStack stack = event.getHarvester().func_184586_b((EnumHand)NullHelper.notnullJ((Object)hand, (String)"EnumHand.values()"));
            if (!this.hasAnyUpgradeVariant(stack) || EnergyUpgradeManager.getEnergyStored(stack) <= 0) continue;
            EnergyUpgradeManager.extractEnergy(stack, DirectUpgrade.doDirect(event) * (Integer)DarkSteelConfig.directEnergyCost.get(), false);
            return;
        }
    }

    public static int doDirect(BlockEvent.HarvestDropsEvent event) {
        int count = 0;
        InventoryPlayer inventory = event.getHarvester().field_71071_by;
        Iterator iterator = event.getDrops().iterator();
        while (iterator.hasNext()) {
            ItemStack next = (ItemStack)NullHelper.notnullF(iterator.next(), (String)"null stack in HarvestDropsEvent");
            if (random.nextFloat() < event.getDropChance()) {
                if (!inventory.func_70441_a(next)) continue;
                ++count;
                iterator.remove();
                continue;
            }
            iterator.remove();
        }
        event.setDropChance(1.0f);
        return count;
    }
}

