/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.item.magnet;

import com.enderio.core.common.util.MagnetUtil;
import com.enderio.core.common.util.stackable.Things;
import crazypants.enderio.base.config.config.ItemConfig;
import crazypants.enderio.base.init.ModObject;
import crazypants.enderio.base.integration.baubles.BaublesUtil;
import crazypants.enderio.base.integration.botania.BotaniaUtil;
import crazypants.enderio.base.item.magnet.ItemMagnet;
import crazypants.enderio.base.item.magnet.PacketMagnetState;
import crazypants.enderio.util.Prep;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ClassInheritanceMultiMap;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;

@Mod.EventBusSubscriber(modid="enderio")
public class MagnetController {
    private static final double collisionDistanceSq = 1.5625;
    private static final double speed = 0.035;
    private static final double speed4 = 0.14;

    private MagnetController() {
    }

    @SubscribeEvent
    public static void onPlayerTick(@Nonnull TickEvent.PlayerTickEvent event) {
        if (event.phase != TickEvent.Phase.END || event.player.func_110143_aJ() <= 0.0f || event.player.func_175149_v()) {
            return;
        }
        ActiveMagnet mag = MagnetController.getMagnet(event.player, true);
        if (mag != null) {
            MagnetController.doHoover(event.player);
            if (event.side == Side.SERVER && event.player.field_70170_p.func_82737_E() % 20L == 0L) {
                ((ItemMagnet)mag.item.func_77973_b()).drainPerSecondPower(mag.item);
                event.player.field_71071_by.func_70299_a(mag.slot, mag.item);
                event.player.field_71071_by.func_70296_d();
            }
        }
    }

    public static ActiveMagnet getMagnet(EntityPlayer player, boolean activeOnly) {
        NonNullList inv = player.field_71071_by.field_70462_a;
        int maxSlot = (Boolean)ItemConfig.magnetAllowInMainInventory.get() != false ? inv.size() : InventoryPlayer.func_70451_h();
        for (int i = 0; i < maxSlot; ++i) {
            ItemStack item = (ItemStack)inv.get(i);
            if (!ItemMagnet.isMagnet(item) || activeOnly && (!ItemMagnet.isActive(item) || !ItemMagnet.hasPower(item))) continue;
            return new ActiveMagnet(item, i);
        }
        ItemStack item = (ItemStack)player.field_71071_by.field_184439_c.get(0);
        if (ItemMagnet.isMagnet(item) && (!activeOnly || ItemMagnet.isActive(item) && ItemMagnet.hasPower(item))) {
            return new ActiveMagnet(item, player.field_71071_by.field_70462_a.size() + player.field_71071_by.field_70460_b.size());
        }
        return null;
    }

    public static void doHoover(EntityPlayer player) {
        Integer range = (Integer)ItemConfig.magnetRange.get();
        AxisAlignedBB aabb = new AxisAlignedBB(player.field_70165_t - (double)range.intValue(), player.field_70163_u - (double)range.intValue(), player.field_70161_v - (double)range.intValue(), player.field_70165_t + (double)range.intValue(), player.field_70163_u + (double)range.intValue(), player.field_70161_v + (double)range.intValue());
        List<Entity> interestingItems = MagnetController.selectEntitiesWithinAABB(player.field_70170_p, aabb);
        if (interestingItems != null) {
            for (Entity entity : interestingItems) {
                double x = player.field_70165_t - entity.field_70165_t;
                double y = player.field_70163_u + (double)(player.eyeHeight * 0.75f) - entity.field_70163_u;
                double z = player.field_70161_v - entity.field_70161_v;
                double distance = x * x + y * y + z * z;
                if (distance < 1.5625) {
                    entity.func_70100_b_(player);
                    continue;
                }
                double distancespeed = 0.14 / distance;
                entity.field_70159_w += x * distancespeed;
                entity.field_70181_x = y > 0.0 ? 0.12 : (entity.field_70181_x += y * 0.035);
                entity.field_70179_y += z * distancespeed;
            }
        }
    }

    private static boolean isBlackListed(EntityItem entity) {
        return ((Things)ItemConfig.magnetBlacklist.get()).contains(entity.func_92059_d());
    }

    private static List<Entity> selectEntitiesWithinAABB(World world, AxisAlignedBB bb) {
        ArrayList<Entity> arraylist = null;
        int itemsRemaining = (Integer)ItemConfig.magnetMaxItems.get();
        if (itemsRemaining <= 0) {
            itemsRemaining = Integer.MAX_VALUE;
        }
        int minChunkX = MathHelper.func_76128_c((double)(bb.field_72340_a / 16.0));
        int maxChunkX = MathHelper.func_76128_c((double)(bb.field_72336_d / 16.0));
        int minChunkZ = MathHelper.func_76128_c((double)(bb.field_72339_c / 16.0));
        int maxChunkZ = MathHelper.func_76128_c((double)(bb.field_72334_f / 16.0));
        int minChunkY = MathHelper.func_76128_c((double)(bb.field_72338_b / 16.0));
        int maxChunkY = MathHelper.func_76128_c((double)(bb.field_72337_e / 16.0));
        for (int chunkX = minChunkX; chunkX <= maxChunkX; ++chunkX) {
            for (int chunkZ = minChunkZ; chunkZ <= maxChunkZ; ++chunkZ) {
                Chunk chunk = world.func_72964_e(chunkX, chunkZ);
                ClassInheritanceMultiMap[] entityLists = chunk.func_177429_s();
                int minChunkYClamped = MathHelper.func_76125_a((int)minChunkY, (int)0, (int)(entityLists.length - 1));
                int maxChunkYClamped = MathHelper.func_76125_a((int)maxChunkY, (int)0, (int)(entityLists.length - 1));
                for (int chunkY = minChunkYClamped; chunkY <= maxChunkYClamped; ++chunkY) {
                    for (Entity entity : entityLists[chunkY]) {
                        if (entity.field_70128_L) continue;
                        boolean isValidTarget = false;
                        if (entity.func_174813_aQ().func_72326_a(bb)) {
                            if (entity instanceof EntityItem) {
                                isValidTarget = !BotaniaUtil.hasSolegnoliaAround(entity) && !MagnetController.isBlackListed((EntityItem)entity);
                            } else if (entity instanceof EntityXPOrb) {
                                isValidTarget = true;
                            }
                        }
                        if (!(isValidTarget = isValidTarget && !MagnetUtil.isReserved((Entity)entity))) continue;
                        if (arraylist == null) {
                            arraylist = new ArrayList<Entity>((Integer)ItemConfig.magnetMaxItems.get() > 0 ? (Integer)ItemConfig.magnetMaxItems.get() : 20);
                        }
                        arraylist.add(entity);
                        if (itemsRemaining-- > 0) continue;
                        return arraylist;
                    }
                }
            }
        }
        return arraylist;
    }

    public static void setMagnetActive(EntityPlayerMP player, PacketMagnetState.SlotType type, int slot, boolean isActive) {
        ItemStack stack = Prep.getEmpty();
        IInventory baubles = null;
        int dropOff = -1;
        switch (type) {
            case INVENTORY: {
                stack = player.field_71071_by.func_70301_a(slot);
                break;
            }
            case ARMOR: {
                return;
            }
            case BAUBLES: {
                baubles = BaublesUtil.instance().getBaubles((EntityPlayer)player);
                if (baubles == null || !Prep.isValid(stack = baubles.func_70301_a(slot))) break;
                stack = stack.func_77946_l();
            }
        }
        if (stack.func_77973_b() != ModObject.itemMagnet.getItem() || ItemMagnet.isActive(stack) == isActive) {
            return;
        }
        if (!((Boolean)ItemConfig.magnetAllowDeactivatedInBaublesSlot.get()).booleanValue() && type == PacketMagnetState.SlotType.BAUBLES && !isActive && (dropOff = player.field_71071_by.func_70447_i()) < 0) {
            return;
        }
        ItemMagnet.setActive(stack, isActive);
        switch (type) {
            case INVENTORY: {
                player.field_71071_by.func_70299_a(slot, stack);
                player.field_71071_by.func_70296_d();
                break;
            }
            case ARMOR: {
                return;
            }
            case BAUBLES: {
                if (baubles == null) break;
                if (dropOff < 0) {
                    baubles.func_70299_a(slot, stack);
                } else {
                    baubles.func_70299_a(slot, Prep.getEmpty());
                    player.field_71071_by.func_70299_a(dropOff, stack);
                }
                player.field_71071_by.func_70296_d();
            }
        }
    }

    public static class ActiveMagnet {
        @Nonnull
        final ItemStack item;
        final int slot;

        ActiveMagnet(@Nonnull ItemStack item, int slot) {
            this.item = item;
            this.slot = slot;
        }

        @Nonnull
        public ItemStack getItem() {
            return this.item;
        }

        public int getSlot() {
            return this.slot;
        }
    }
}

