/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.power.forge;

import crazypants.enderio.base.EnderIO;
import crazypants.enderio.base.config.config.DiagnosticsConfig;
import crazypants.enderio.base.power.ILegacyPowerReceiver;
import crazypants.enderio.base.power.forge.InternalPoweredTileWrapper;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;

public class InternalRecieverTileWrapper
extends InternalPoweredTileWrapper {
    @Nonnull
    protected final ILegacyPowerReceiver tile;

    public InternalRecieverTileWrapper(@Nonnull ILegacyPowerReceiver tile, @Nonnull EnumFacing facing) {
        super(tile, facing);
        this.tile = tile;
    }

    @Override
    public int receiveEnergy(int maxReceive, boolean simulate) {
        return this.tile.receiveEnergy(this.from, maxReceive, simulate);
    }

    @Override
    public boolean canReceive() {
        return true;
    }

    public static class LimitingRecieverTileCapabilityProvider
    extends InternalRecieverTileWrapper {
        private long lastTick = -1L;
        private int recv = 0;

        public LimitingRecieverTileCapabilityProvider(@Nonnull ILegacyPowerReceiver tile, @Nonnull EnumFacing facing) {
            super(tile, facing);
        }

        @Override
        public int receiveEnergy(int maxReceive, boolean simulate) {
            int max;
            int receivedEnergy;
            long serverTickCount = EnderIO.proxy.getServerTickCount();
            if (serverTickCount != this.lastTick) {
                this.lastTick = serverTickCount;
                this.recv = 0;
            }
            int n = receivedEnergy = (max = Math.min(maxReceive, this.tile.getMaxEnergyRecieved(this.from) - this.recv)) > 0 ? super.receiveEnergy(max, simulate) : 0;
            if (!simulate) {
                this.recv += receivedEnergy;
            }
            return receivedEnergy;
        }
    }

    public static class ValidatingRecieverTileCapabilityProvider
    extends InternalRecieverTileWrapper {
        private long lastTick = -1L;
        private int recv = 0;
        private int cooldown = 0;

        public ValidatingRecieverTileCapabilityProvider(@Nonnull ILegacyPowerReceiver tile, @Nonnull EnumFacing facing) {
            super(tile, facing);
        }

        @Override
        public int receiveEnergy(int maxReceive, boolean simulate) {
            int receivedEnergy = super.receiveEnergy(maxReceive, simulate);
            if (!simulate) {
                long serverTickCount = EnderIO.proxy.getServerTickCount();
                if (serverTickCount != this.lastTick) {
                    this.lastTick = serverTickCount;
                    this.recv = receivedEnergy;
                } else {
                    this.recv += receivedEnergy;
                    int maxEnergyRecieved = this.tile.getMaxEnergyRecieved(this.from);
                    if (this.recv > maxEnergyRecieved) {
                        if (this.cooldown <= 0) {
                            BlockPos pos = this.tile.getLocation().func_177972_a(this.from);
                            ((TileEntity)this.tile).func_145831_w().func_72876_a(null, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, 1.0f, this.recv / 2 > maxEnergyRecieved);
                            this.cooldown = 30;
                        } else {
                            --this.cooldown;
                        }
                    }
                }
            }
            return receivedEnergy;
        }
    }

    public static class RecieverTileCapabilityProvider
    extends InternalPoweredTileWrapper.PoweredTileCapabilityProvider {
        @Nonnull
        private final ILegacyPowerReceiver tile;

        public RecieverTileCapabilityProvider(@Nonnull ILegacyPowerReceiver tile) {
            super(tile);
            this.tile = tile;
        }

        @Override
        public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
            if (capability == CapabilityEnergy.ENERGY && facing != null && this.tile.canConnectEnergy(facing)) {
                switch ((DiagnosticsConfig.Protection)((Object)DiagnosticsConfig.protectEnergyOverflow.get())) {
                    case NONE: {
                        return (T)new InternalRecieverTileWrapper(this.tile, facing);
                    }
                    case SOFT: {
                        return (T)new LimitingRecieverTileCapabilityProvider(this.tile, facing);
                    }
                    case HARD: {
                        return (T)new ValidatingRecieverTileCapabilityProvider(this.tile, facing);
                    }
                }
            }
            return null;
        }
    }
}

