/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.recipe;

import com.enderio.core.common.util.NNList;
import crazypants.enderio.base.recipe.IMachineRecipe;
import crazypants.enderio.base.recipe.IRecipe;
import crazypants.enderio.base.recipe.IRecipeInput;
import crazypants.enderio.base.recipe.MachineRecipeInput;
import crazypants.enderio.base.recipe.RecipeBonusType;
import crazypants.enderio.base.recipe.RecipeLevel;
import crazypants.enderio.base.recipe.RecipeOutput;
import crazypants.enderio.util.Prep;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public abstract class AbstractMachineRecipe
implements IMachineRecipe {
    @Override
    public int getEnergyRequired(@Nonnull NNList<MachineRecipeInput> inputs) {
        if (inputs.size() <= 0) {
            return 0;
        }
        IRecipe recipe = this.getRecipeForInputs(RecipeLevel.IGNORE, inputs);
        return recipe == null ? 0 : recipe.getEnergyRequired();
    }

    @Override
    @Nonnull
    public RecipeBonusType getBonusType(@Nonnull NNList<MachineRecipeInput> inputs) {
        if (inputs.size() <= 0) {
            return RecipeBonusType.NONE;
        }
        IRecipe recipe = this.getRecipeForInputs(RecipeLevel.IGNORE, inputs);
        if (recipe == null) {
            return RecipeBonusType.NONE;
        }
        return recipe.getBonusType();
    }

    public abstract IRecipe getRecipeForInputs(@Nonnull RecipeLevel var1, @Nonnull NNList<MachineRecipeInput> var2);

    @Nonnull
    public NNList<MachineRecipeInput> getQuantitiesConsumed(@Nonnull NNList<MachineRecipeInput> inputs) {
        IRecipe recipe = this.getRecipeForInputs(RecipeLevel.IGNORE, inputs);
        NNList result = new NNList();
        MachineRecipeInput[] availableInputs = new MachineRecipeInput[inputs.size()];
        int i = 0;
        for (MachineRecipeInput available : inputs) {
            availableInputs[i] = available.copy();
            ++i;
        }
        IRecipeInput[] requiredIngredients = new IRecipeInput[recipe.getInputs().length];
        i = 0;
        for (IRecipeInput ri : recipe.getInputs()) {
            requiredIngredients[i] = ri.copy();
            ++i;
        }
        block2: for (IRecipeInput required : requiredIngredients) {
            for (MachineRecipeInput available : availableInputs) {
                if (required != null && available != null && this.isValid(available) && this.consume(required, available, (List<MachineRecipeInput>)result)) continue block2;
            }
        }
        return result;
    }

    protected boolean consume(@Nonnull IRecipeInput required, @Nonnull MachineRecipeInput available, @Nonnull List<MachineRecipeInput> consumedInputs) {
        if (required.isInput(available.fluid)) {
            consumedInputs.add(new MachineRecipeInput(available.slotNumber, required.getFluidInput().copy()));
            return true;
        }
        if (required.isInput(available.item) && (required.getSlotNumber() == -1 || required.getSlotNumber() == available.slotNumber)) {
            ItemStack availableStack = available.item;
            ItemStack requiredStack = required.getInput();
            ItemStack consumedStack = requiredStack.func_77946_l();
            consumedStack.func_190920_e(Math.min(requiredStack.func_190916_E(), availableStack.func_190916_E()));
            requiredStack.func_190918_g(consumedStack.func_190916_E());
            availableStack.func_190918_g(consumedStack.func_190916_E());
            consumedInputs.add(new MachineRecipeInput(available.slotNumber, consumedStack));
            if (Prep.isInvalid(requiredStack)) {
                return true;
            }
        }
        return false;
    }

    protected boolean isValid(@Nonnull MachineRecipeInput input) {
        if (Prep.isValid(input.item)) {
            return true;
        }
        return input.fluid != null && input.fluid.amount > 0;
    }

    @Override
    public float getExperienceForOutput(@Nonnull ItemStack output) {
        return 0.0f;
    }

    @Override
    public boolean isRecipe(@Nonnull RecipeLevel machineLevel, @Nonnull NNList<MachineRecipeInput> inputs) {
        if (inputs.size() <= 0) {
            return false;
        }
        IRecipe recipe = this.getRecipeForInputs(machineLevel, inputs);
        return recipe != null;
    }

    @Override
    @Nonnull
    public IMachineRecipe.ResultStack[] getCompletedResult(long nextSeed, float chanceMultiplier, @Nonnull NNList<MachineRecipeInput> inputs) {
        if (inputs.size() <= 0) {
            return new IMachineRecipe.ResultStack[0];
        }
        IRecipe recipe = this.getRecipeForInputs(RecipeLevel.IGNORE, inputs);
        if (recipe == null) {
            return new IMachineRecipe.ResultStack[0];
        }
        RecipeOutput[] outputs = recipe.getOutputs();
        if (outputs.length == 0) {
            return new IMachineRecipe.ResultStack[0];
        }
        NNList result = new NNList();
        Random rand = new Random(nextSeed);
        for (RecipeOutput output : outputs) {
            if (output.isFluid()) {
                FluidStack fluidOutput = output.getFluidOutput();
                if (fluidOutput == null || !(rand.nextFloat() < output.getChance() * chanceMultiplier)) continue;
                fluidOutput = fluidOutput.copy();
                result.add((Object)new IMachineRecipe.ResultStack(fluidOutput));
                continue;
            }
            ItemStack stack = output.getOutput().func_77946_l();
            int stackSize = 0;
            for (int i = 0; i < stack.func_190916_E(); ++i) {
                if (!(rand.nextFloat() < output.getChance() * chanceMultiplier)) continue;
                ++stackSize;
            }
            stack.func_190920_e(stackSize);
            if (!Prep.isValid(stack)) continue;
            result.add((Object)new IMachineRecipe.ResultStack(stack));
        }
        return (IMachineRecipe.ResultStack[])result.toArray((Object[])new IMachineRecipe.ResultStack[0]);
    }
}

