/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.recipe.spawner;

import com.enderio.core.common.util.NNList;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.util.ResourceLocation;

public class PoweredSpawnerRecipeRegistry {
    private static final PoweredSpawnerRecipeRegistry instance = new PoweredSpawnerRecipeRegistry();
    private double defaultCostMultiplier = 1.0;
    private boolean allowUnconfiguredMobs = true;
    @Nonnull
    private final Map<ResourceLocation, Double> costs = new HashMap<ResourceLocation, Double>();
    @Nonnull
    private final NNList<ResourceLocation> blackList = new NNList();

    public static PoweredSpawnerRecipeRegistry getInstance() {
        return instance;
    }

    public double getCostMultiplierFor(@Nonnull ResourceLocation entity) {
        Double val = this.costs.get(entity);
        if (val == null) {
            return this.defaultCostMultiplier;
        }
        return val;
    }

    public boolean isBlackListed(@Nonnull ResourceLocation entity) {
        return this.blackList.contains((Object)entity) || !this.allowUnconfiguredMobs && !this.costs.containsKey(entity);
    }

    private PoweredSpawnerRecipeRegistry() {
    }

    public void setDefaultCostMultiplier(double defaultCostMultiplier) {
        this.defaultCostMultiplier = defaultCostMultiplier;
    }

    public void setAllowUnconfiguredMobs(boolean allowUnconfiguredMobs) {
        this.allowUnconfiguredMobs = allowUnconfiguredMobs;
    }

    public void addToBlacklist(@Nonnull ResourceLocation value) {
        this.blackList.add((Object)value);
    }

    public void addEntityCost(@Nonnull ResourceLocation entityName, double costMultiplier) {
        if (costMultiplier > 0.0) {
            this.costs.put(entityName, costMultiplier);
        }
    }
}

