/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduits.network;

import crazypants.enderio.conduits.conduit.redstone.IRedstoneConduit;
import crazypants.enderio.conduits.network.AbstractConduitPacket;
import io.netty.buffer.ByteBuf;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketRedstoneConduitOutputStrength
extends AbstractConduitPacket<IRedstoneConduit> {
    private EnumFacing dir;
    private boolean isStrong;

    public PacketRedstoneConduitOutputStrength() {
    }

    public PacketRedstoneConduitOutputStrength(IRedstoneConduit con, EnumFacing dir) {
        super(con.getBundle().getEntity(), con);
        this.dir = dir;
        this.isStrong = con.isOutputStrong(dir);
    }

    @Override
    public void toBytes(ByteBuf buf) {
        super.toBytes(buf);
        if (this.dir == null) {
            buf.writeShort(-1);
        } else {
            buf.writeShort(this.dir.ordinal());
        }
        buf.writeBoolean(this.isStrong);
    }

    @Override
    public void fromBytes(ByteBuf buf) {
        super.fromBytes(buf);
        short ord = buf.readShort();
        this.dir = ord < 0 ? null : EnumFacing.values()[ord];
        this.isStrong = buf.readBoolean();
    }

    public static class Handler
    implements IMessageHandler<PacketRedstoneConduitOutputStrength, IMessage> {
        public IMessage onMessage(PacketRedstoneConduitOutputStrength message, MessageContext ctx) {
            IRedstoneConduit tile = (IRedstoneConduit)message.getConduit(ctx);
            if (tile != null) {
                tile.setOutputStrength(message.dir, message.isStrong);
            }
            return null;
        }
    }
}

