/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduits.network;

import com.enderio.core.common.util.DyeColor;
import crazypants.enderio.conduits.conduit.redstone.IRedstoneConduit;
import crazypants.enderio.conduits.network.AbstractConduitPacket;
import io.netty.buffer.ByteBuf;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketRedstoneConduitSignalColor
extends AbstractConduitPacket<IRedstoneConduit> {
    private EnumFacing dir;
    private DyeColor col;
    private boolean isInput;

    public PacketRedstoneConduitSignalColor() {
    }

    public PacketRedstoneConduitSignalColor(@Nonnull IRedstoneConduit con, EnumFacing dir, boolean isInput) {
        super(con);
        this.dir = dir;
        this.col = isInput ? con.getInputSignalColor(dir) : con.getOutputSignalColor(dir);
        this.isInput = isInput;
    }

    @Override
    public void toBytes(ByteBuf buf) {
        super.toBytes(buf);
        if (this.dir == null) {
            buf.writeShort(-1);
        } else {
            buf.writeShort(this.dir.ordinal());
        }
        buf.writeShort(this.col.ordinal());
        buf.writeBoolean(this.isInput);
    }

    @Override
    public void fromBytes(ByteBuf buf) {
        super.fromBytes(buf);
        short ord = buf.readShort();
        this.dir = ord < 0 ? null : EnumFacing.values()[ord];
        this.col = DyeColor.values()[buf.readShort()];
        this.isInput = buf.readBoolean();
    }

    public static class Handler
    implements IMessageHandler<PacketRedstoneConduitSignalColor, IMessage> {
        public IMessage onMessage(PacketRedstoneConduitSignalColor message, MessageContext ctx) {
            IRedstoneConduit conduit = (IRedstoneConduit)message.getConduit(ctx);
            if (conduit != null) {
                if (message.isInput) {
                    conduit.setInputSignalColor(message.dir, message.col);
                } else {
                    conduit.setOutputSignalColor(message.dir, message.col);
                }
                IBlockState bs = message.getWorld(ctx).func_180495_p(message.getPos());
                message.getWorld(ctx).func_184138_a(message.getPos(), bs, bs, 3);
            }
            return null;
        }
    }
}

