/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machines.machine.generator.combustion;

import com.enderio.core.common.network.MessageTileEntity;
import com.enderio.core.common.network.NetworkUtil;
import crazypants.enderio.base.EnderIO;
import crazypants.enderio.machines.machine.generator.combustion.TileCombustionGenerator;
import io.netty.buffer.ByteBuf;
import javax.annotation.Nonnull;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketCombustionTank
extends MessageTileEntity<TileCombustionGenerator> {
    public NBTTagCompound nbtRoot;

    public PacketCombustionTank() {
    }

    public PacketCombustionTank(@Nonnull TileCombustionGenerator tile) {
        super((TileEntity)tile);
        NBTTagCompound tankRoot;
        this.nbtRoot = new NBTTagCompound();
        if (tile.getCoolantTank().getFluidAmount() > 0) {
            tankRoot = new NBTTagCompound();
            tile.getCoolantTank().writeToNBT(tankRoot);
            this.nbtRoot.func_74782_a("coolantTank", (NBTBase)tankRoot);
        }
        if (tile.getFuelTank().getFluidAmount() > 0) {
            tankRoot = new NBTTagCompound();
            tile.getFuelTank().writeToNBT(tankRoot);
            this.nbtRoot.func_74782_a("fuelTank", (NBTBase)tankRoot);
        }
    }

    public void toBytes(ByteBuf buf) {
        super.toBytes(buf);
        NetworkUtil.writeNBTTagCompound((NBTTagCompound)this.nbtRoot, (ByteBuf)buf);
    }

    public void fromBytes(ByteBuf buf) {
        super.fromBytes(buf);
        this.nbtRoot = NetworkUtil.readNBTTagCompound((ByteBuf)buf);
    }

    public static class Handler
    implements IMessageHandler<PacketCombustionTank, IMessage> {
        public IMessage onMessage(PacketCombustionTank message, MessageContext ctx) {
            TileCombustionGenerator tile = (TileCombustionGenerator)message.getTileEntity(EnderIO.proxy.getClientWorld());
            if (tile != null) {
                NBTTagCompound tankRoot;
                if (message.nbtRoot.func_74764_b("coolantTank")) {
                    tankRoot = message.nbtRoot.func_74775_l("coolantTank");
                    tile.getCoolantTank().readFromNBT(tankRoot);
                } else {
                    tile.getCoolantTank().setFluid(null);
                }
                if (message.nbtRoot.func_74764_b("fuelTank")) {
                    tankRoot = message.nbtRoot.func_74775_l("fuelTank");
                    tile.getFuelTank().readFromNBT(tankRoot);
                } else {
                    tile.getFuelTank().setFluid(null);
                }
            }
            return null;
        }
    }
}

