/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machines.machine.obelisk.relocator;

import com.enderio.core.client.render.BoundingBox;
import com.enderio.core.common.vecmath.Vector4f;
import crazypants.enderio.base.machine.baselegacy.SlotDefinition;
import crazypants.enderio.base.machine.modes.EntityAction;
import crazypants.enderio.base.network.PacketSpawnParticles;
import crazypants.enderio.base.render.ranged.RangeParticle;
import crazypants.enderio.machines.capacitor.CapacitorKey;
import crazypants.enderio.machines.init.MachineObject;
import crazypants.enderio.machines.machine.obelisk.base.AbstractRangedObeliskEntity;
import crazypants.enderio.machines.machine.obelisk.base.AbstractSpawningObeliskEntity;
import crazypants.enderio.machines.machine.obelisk.base.ISpawnCallback;
import info.loenwind.autosave.annotations.Storable;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.WeakHashMap;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Storable
public class TileRelocatorObelisk
extends AbstractSpawningObeliskEntity {
    private final Map<EntityLivingBase, Integer> relocationQueue = new WeakHashMap<EntityLivingBase, Integer>();
    private final Random rand = new Random();
    @Nonnull
    private static final Vector4f color = new Vector4f(0.94f, 0.11f, 0.11f, 0.4f);

    public TileRelocatorObelisk() {
        super(new SlotDefinition(12, 0), CapacitorKey.RELOCATOR_POWER_INTAKE, CapacitorKey.RELOCATOR_POWER_BUFFER, CapacitorKey.RELOCATOR_POWER_USE);
    }

    @Override
    public float getRange() {
        return CapacitorKey.RELOCATOR_RANGE.get(this.getCapacitorData());
    }

    @Override
    @Nonnull
    public String getMachineName() {
        return MachineObject.block_relocator_obelisk.getUnlocalisedName();
    }

    @Override
    @Nonnull
    public ISpawnCallback.Result isSpawnPrevented(EntityLivingBase mob) {
        if (this.redstoneCheckPassed && this.hasPower() && this.isMobInRange(mob) && this.isMobInFilter(mob)) {
            this.relocationQueue.put(mob, null);
            return ISpawnCallback.Result.DONE;
        }
        return ISpawnCallback.Result.NEXT;
    }

    @Override
    protected boolean processTasks(boolean redstoneCheck) {
        if (!this.relocationQueue.isEmpty()) {
            AxisAlignedBB targetBB = new AxisAlignedBB(this.func_174877_v(), this.func_174877_v().func_177982_a(1, 1, 1)).func_72321_a(4.0, 1.0, 4.0);
            Iterator<EntityLivingBase> iterator = this.relocationQueue.keySet().iterator();
            while (iterator.hasNext()) {
                double dy;
                double dz;
                double z;
                double y;
                double dx;
                EntityLivingBase mob = iterator.next();
                if (mob == null || mob.field_70128_L || this.field_145850_b.func_73045_a(mob.func_145782_y()) == null || mob.field_70173_aa > 2400 || this.relocationQueue.size() > 100) {
                    iterator.remove();
                    continue;
                }
                if (!this.hasPower() || !(this.rand.nextFloat() < 0.025f)) continue;
                AxisAlignedBB mobbb = mob.func_174813_aQ();
                if (targetBB.func_72326_a(mobbb)) {
                    iterator.remove();
                    continue;
                }
                double x = (double)this.func_174877_v().func_177958_n() + 0.5 + Math.random() * 8.0 - 4.0;
                AxisAlignedBB bb = new AxisAlignedBB(x - (dx = mobbb.field_72336_d - mobbb.field_72340_a) / 2.0, y = (double)this.func_174877_v().func_177956_o() + 0.5 + Math.random() * 3.0 - 1.5, (z = (double)this.func_174877_v().func_177952_p() + 0.5 + Math.random() * 8.0 - 4.0) - (dz = mobbb.field_72334_f - mobbb.field_72339_c) / 2.0, x + dx / 2.0, y + (dy = mobbb.field_72337_e - mobbb.field_72338_b), z + dz / 2.0);
                boolean spaceClear = this.field_145850_b.func_72917_a(bb, (Entity)mob) && this.field_145850_b.func_184144_a((Entity)mob, bb).isEmpty() && this.field_145850_b.func_72953_d(bb) == mob.isCreatureType(EnumCreatureType.WATER_CREATURE, false);
                if (!spaceClear) continue;
                PacketSpawnParticles.create((Entity)mob, EnumParticleTypes.PORTAL, EnumParticleTypes.PORTAL, EnumParticleTypes.PORTAL);
                mob.func_184185_a(SoundEvents.field_187534_aX, 1.0f, 1.0f);
                mob.func_70634_a(x - dx / 2.0, y + 0.05, z - dz / 2.0);
                mob.func_184185_a(SoundEvents.field_187534_aX, 1.0f, 1.0f);
                PacketSpawnParticles.create((Entity)mob, EnumParticleTypes.PORTAL, EnumParticleTypes.PORTAL, EnumParticleTypes.PORTAL);
                iterator.remove();
            }
        }
        return super.processTasks(redstoneCheck);
    }

    @Override
    @Nonnull
    public EntityAction getEntityAction() {
        return EntityAction.RELOCATE;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void setShowRange(boolean showRange) {
        if (this.showingRange == showRange) {
            return;
        }
        super.setShowRange(showRange);
        if (this.showingRange) {
            Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)new RangeParticle<AbstractRangedObeliskEntity>((AbstractRangedObeliskEntity)this, color){

                @Override
                @Nonnull
                protected BoundingBox getBounds() {
                    return new BoundingBox(TileRelocatorObelisk.this.func_174877_v()).expand(4.0, 1.0, 4.0);
                }
            });
        }
    }
}

