/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machines.machine.reservoir;

import com.enderio.core.api.common.util.ITankAccess;
import com.enderio.core.common.fluid.FluidWrapper;
import com.enderio.core.common.fluid.SmartTank;
import com.enderio.core.common.fluid.SmartTankFluidHandler;
import com.enderio.core.common.util.NNList;
import crazypants.enderio.base.TileEntityEio;
import crazypants.enderio.machines.machine.reservoir.BlockReservoirBase;
import info.loenwind.autosave.annotations.Storable;
import info.loenwind.autosave.annotations.Store;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;

@Storable
public abstract class TileReservoirBase
extends TileEntityEio
implements ITankAccess.IExtendedTankAccess {
    @Store
    @Nonnull
    protected final SmartTank tank;
    @Store
    protected boolean autoEject = false;
    protected boolean tankDirty = false;
    private static final int IO_MB_TICK = 100;
    protected static final int WORK_TICKS = 5;
    private SmartTankFluidHandler smartTankFluidHandler;

    private TileReservoirBase(@Nullable Fluid fluid) {
        this.tank = new SmartTank(fluid, 1000);
        this.tank.setTileEntity((TileEntity)this);
    }

    protected void doPush(int ticks) {
        if (!this.tank.isEmpty()) {
            NNList.NNIterator itr = NNList.FACING.fastIterator();
            while (itr.hasNext() && !this.tank.isEmpty()) {
                EnumFacing dir = (EnumFacing)itr.next();
                BlockPos neighbor = this.func_174877_v().func_177972_a(dir);
                if (this.field_145850_b.func_180495_p(neighbor).func_177230_c() == this.field_145854_h || FluidWrapper.transfer((FluidTank)this.tank, (IBlockAccess)this.field_145850_b, (BlockPos)neighbor, (EnumFacing)dir.func_176734_d(), (int)(100 * ticks)) <= 0) continue;
                this.setTanksDirty();
            }
        }
    }

    protected void doLeak() {
        BlockPos down = this.func_174877_v().func_177977_b();
        if (this.doLeak(down)) {
            NNList.NNIterator itr = NNList.FACING_HORIZONTAL.fastIterator();
            while (itr.hasNext() && !this.tank.isEmpty()) {
                this.doLeak(down.func_177972_a((EnumFacing)itr.next()));
            }
        }
    }

    protected boolean doLeak(@Nonnull BlockPos otherPos) {
        TileReservoirBase other = (TileReservoirBase)((Object)BlockReservoirBase.getAnyTileEntity((IBlockAccess)this.field_145850_b, (BlockPos)otherPos, ((Object)((Object)this)).getClass()));
        if (other != null) {
            FluidStack canDrain;
            if (!other.tank.isFull() && other.tank.canFillFluidType(this.tank.getFluidNN()) && (canDrain = this.tank.drainInternal(other.tank.getAvailableSpace(), false)) != null && canDrain.amount > 0) {
                int fill = other.tank.fill(canDrain, true);
                this.tank.drainInternal(fill, true);
                other.setTanksDirty();
                this.setTanksDirty();
            }
            return true;
        }
        return false;
    }

    protected void doEqualize() {
        NNList.NNIterator itr = NNList.FACING_HORIZONTAL.fastIterator();
        while (itr.hasNext() && !this.tank.isEmpty()) {
            FluidStack canDrain;
            int toMove;
            BlockPos pos1 = this.func_174877_v().func_177972_a((EnumFacing)itr.next());
            TileReservoirBase other = (TileReservoirBase)((Object)BlockReservoirBase.getAnyTileEntity((IBlockAccess)this.field_145850_b, (BlockPos)pos1, ((Object)((Object)this)).getClass()));
            if (other == null || (toMove = (this.tank.getFluidAmount() - other.tank.getFluidAmount()) / 2) <= 0 || (canDrain = this.tank.drainInternal(Math.min(toMove, 25), false)) == null || canDrain.amount <= 0) continue;
            int fill = other.tank.fill(canDrain, true);
            this.tank.drainInternal(fill, true);
            other.setTanksDirty();
            this.setTanksDirty();
        }
    }

    @Override
    public void doUpdate() {
        if (this.field_145850_b.field_72995_K) {
            this.disableTicking();
            return;
        }
        this.doInfiniteSource();
        if (this.shouldDoWorkThisTick(15, 1) && !this.tank.isEmpty()) {
            this.doLeak();
            if (!this.tank.isEmpty()) {
                this.doEqualize();
            }
        }
        if (this.shouldDoWorkThisTick(5)) {
            if (this.autoEject && this.allowExtracting()) {
                this.doPush(5);
            }
            if (this.tankDirty) {
                this.forceUpdatePlayers();
                this.tankDirty = false;
            }
        }
    }

    protected abstract void doInfiniteSource();

    protected abstract boolean allowExtracting();

    public void setAutoEject(boolean autoEject) {
        this.autoEject = autoEject;
        this.setTanksDirty();
    }

    public boolean isAutoEject() {
        return this.autoEject;
    }

    float getFilledRatio() {
        return this.tank.getFilledRatio();
    }

    public FluidTank getInputTank(FluidStack forFluidType) {
        if (this.tank.canFillFluidType(forFluidType)) {
            return this.tank;
        }
        return null;
    }

    @Nonnull
    public FluidTank[] getOutputTanks() {
        return new FluidTank[]{this.tank};
    }

    public void setTanksDirty() {
        if (!this.tankDirty) {
            this.tankDirty = true;
            this.func_70296_d();
        }
    }

    public boolean shouldRenderInPass(int pass) {
        return pass == 1 && !this.tank.isEmpty();
    }

    @Nonnull
    public List<ITankAccess.ITankData> getTankDisplayData() {
        return Collections.singletonList(new ITankAccess.ITankData(){

            @Nonnull
            public ITankAccess.ITankData.EnumTankType getTankType() {
                return ITankAccess.ITankData.EnumTankType.OUTPUT;
            }

            @Nullable
            public FluidStack getContent() {
                return TileReservoirBase.this.tank.getFluid();
            }

            public int getCapacity() {
                return TileReservoirBase.this.tank.getCapacity();
            }
        });
    }

    protected SmartTankFluidHandler getSmartTankFluidHandler() {
        if (this.smartTankFluidHandler == null) {
            this.smartTankFluidHandler = new SmartTankFluidHandler(new IFluidHandler[]{this.tank}){

                protected boolean canFill(@Nonnull EnumFacing from) {
                    return true;
                }

                protected boolean canDrain(@Nonnull EnumFacing from) {
                    return TileReservoirBase.this.allowExtracting();
                }

                protected boolean canAccess(@Nonnull EnumFacing from) {
                    return true;
                }
            };
        }
        return this.smartTankFluidHandler;
    }

    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facingIn) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)this.getSmartTankFluidHandler().get(facingIn);
        }
        return (T)super.getCapability(capability, facingIn);
    }

    @Nonnull
    protected SmartTank getTank() {
        return this.tank;
    }

    public boolean hasFastRenderer() {
        return true;
    }

    public static class TileReservoir
    extends TileReservoirBase {
        protected boolean canRefill = false;

        public TileReservoir() {
            super(FluidRegistry.WATER);
        }

        @Override
        protected void doInfiniteSource() {
            if (this.shouldDoWorkThisTick(10)) {
                if (this.tankDirty || !this.tank.isFull() || !this.canRefill) {
                    this.canRefill = this.hasEnoughLiquid();
                }
            } else if (this.canRefill && !this.tank.isFull() && this.shouldDoWorkThisTick(10, -1) && this.tank.getFluid() != null) {
                this.tank.addFluidAmount(500);
                this.setTanksDirty();
            }
        }

        private boolean hasEnoughLiquid() {
            HashSet<TileReservoirBase> seen = new HashSet<TileReservoirBase>();
            seen.add(this);
            int got = this.tank.getFluidAmount();
            NNList.NNIterator itr = NNList.FACING.fastIterator();
            while (itr.hasNext()) {
                BlockPos pos1 = this.func_174877_v().func_177972_a((EnumFacing)itr.next());
                TileReservoirBase other = (TileReservoirBase)((Object)BlockReservoirBase.getAnyTileEntity((IBlockAccess)this.field_145850_b, (BlockPos)pos1, ((Object)((Object)this)).getClass()));
                if (other == null || seen.contains((Object)other)) continue;
                seen.add(other);
                if ((got += other.tank.getFluidAmount()) >= 2000) {
                    return true;
                }
                NNList.NNIterator itr2 = NNList.FACING.fastIterator();
                while (itr2.hasNext()) {
                    BlockPos pos2 = pos1.func_177972_a((EnumFacing)itr2.next());
                    TileReservoirBase other2 = (TileReservoirBase)((Object)BlockReservoirBase.getAnyTileEntity((IBlockAccess)this.field_145850_b, (BlockPos)pos2, ((Object)((Object)this)).getClass()));
                    if (other2 == null || seen.contains((Object)other2)) continue;
                    seen.add(other2);
                    if ((got += other2.tank.getFluidAmount()) < 2000) continue;
                    return true;
                }
            }
            return false;
        }

        @Override
        protected boolean allowExtracting() {
            return this.canRefill;
        }
    }

    public static class TileOmniReservoir
    extends TileReservoirBase {
        public TileOmniReservoir() {
            super(null);
        }

        @Override
        protected void doInfiniteSource() {
        }

        @Override
        protected boolean allowExtracting() {
            return true;
        }
    }
}

