/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machines.machine.vat;

import com.enderio.core.common.network.MessageTileEntity;
import crazypants.enderio.machines.lang.Lang;
import crazypants.enderio.machines.machine.vat.PacketTanks;
import crazypants.enderio.machines.machine.vat.TileVat;
import io.netty.buffer.ByteBuf;
import javax.annotation.Nonnull;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketDumpTank
extends MessageTileEntity<TileVat> {
    private int tank;

    public PacketDumpTank() {
    }

    public PacketDumpTank(@Nonnull TileVat te, int tank) {
        super((TileEntity)te);
        this.tank = tank;
    }

    public void toBytes(ByteBuf buf) {
        super.toBytes(buf);
        buf.writeByte(this.tank);
    }

    public void fromBytes(ByteBuf buf) {
        super.fromBytes(buf);
        this.tank = buf.readByte();
    }

    public static class Handler
    implements IMessageHandler<PacketDumpTank, IMessage> {
        public IMessage onMessage(PacketDumpTank message, MessageContext ctx) {
            TileVat te = (TileVat)message.getTileEntity(ctx.getServerHandler().field_147369_b.field_70170_p);
            if (te != null) {
                if (message.tank == 2) {
                    te.outputTank.setFluid(null);
                } else if (!te.inputTank.isEmpty()) {
                    if (te.isActive()) {
                        ctx.getServerHandler().field_147369_b.func_145747_a((ITextComponent)Lang.GUI_VAT_DUMP_ACTIVE.toChatServer());
                    } else if (te.outputTank.isEmpty()) {
                        te.outputTank.setFluid(te.inputTank.getFluid());
                        te.inputTank.setFluid(null);
                    } else {
                        FluidStack fluidInOutput = te.outputTank.getFluid();
                        if (fluidInOutput != null && fluidInOutput.isFluidEqual(te.inputTank.getFluid()) && !te.outputTank.isFull()) {
                            FluidStack drain = te.inputTank.drainInternal(te.outputTank.getAvailableSpace(), true);
                            te.outputTank.fill(drain, true);
                        } else {
                            ctx.getServerHandler().field_147369_b.func_145747_a((ITextComponent)Lang.GUI_VAT_DUMP_FAIL.toChatServer());
                        }
                    }
                }
                te.func_70296_d();
                return new PacketTanks(te);
            }
            return null;
        }
    }
}

