/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.tile;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import micdoodle8.mods.galacticraft.api.GalacticraftRegistry;
import micdoodle8.mods.galacticraft.api.tile.ITileClientUpdates;
import micdoodle8.mods.galacticraft.api.vector.BlockVec3;
import micdoodle8.mods.galacticraft.core.blocks.BlockScreen;
import micdoodle8.mods.galacticraft.core.client.screen.DrawGameScreen;
import micdoodle8.mods.galacticraft.core.tick.TickHandlerClient;
import micdoodle8.mods.galacticraft.core.tile.TileEntityAdvanced;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityScreen
extends TileEntityAdvanced
implements ITileClientUpdates {
    public static float FRAMEBORDER = 0.098f;
    public int imageType;
    public DrawGameScreen screen;
    public boolean connectedUp;
    public boolean connectedDown;
    public boolean connectedLeft;
    public boolean connectedRight;
    public int connectionsUp;
    public int connectionsDown;
    public int connectionsLeft;
    public int connectionsRight;
    public boolean isMultiscreen;
    public int screenOffsetx = 0;
    public int screenOffsetz = 0;
    private int requiresUpdate = 0;
    private boolean doneClientUpdate = false;
    public boolean refreshOnUpdate = false;
    private AxisAlignedBB renderAABB;

    public void setConnectedUp(boolean connectedUpL) {
        this.connectedUp = connectedUpL;
    }

    public void setConnectedDown(boolean connectedDownL) {
        this.connectedDown = connectedDownL;
    }

    public void setConnectedLeft(boolean connectedLeftL) {
        this.connectedLeft = connectedLeftL;
    }

    public void setConnectedRight(boolean connectedRightL) {
        this.connectedRight = connectedRightL;
    }

    public void setVerifiedConnectedUp(BlockVec3 vec) {
        int meta = this.func_145832_p() & 7;
        TileEntity tileUp = vec.getTileEntityOnSide(this.field_145850_b, 1);
        this.setConnectedUp(tileUp instanceof TileEntityScreen && tileUp.func_145832_p() == meta && !tileUp.func_145837_r());
    }

    public void setVerifiedConnectedDown(BlockVec3 vec) {
        int meta = this.func_145832_p() & 7;
        TileEntity tileDown = vec.getTileEntityOnSide(this.field_145850_b, 0);
        this.setConnectedDown(tileDown instanceof TileEntityScreen && tileDown.func_145832_p() == meta && !tileDown.func_145837_r());
    }

    public void setVerifiedConnectedLeft(BlockVec3 vec) {
        int meta = this.func_145832_p() & 7;
        int side = this.getLeft(meta);
        TileEntity tileLeft = vec.getTileEntityOnSide(this.field_145850_b, side);
        this.setConnectedLeft(tileLeft instanceof TileEntityScreen && tileLeft.func_145832_p() == meta && !tileLeft.func_145837_r());
    }

    public void setVerifiedConnectedRight(BlockVec3 vec) {
        int meta = this.func_145832_p() & 7;
        int side = this.getRight(meta);
        TileEntity tileRight = vec.getTileEntityOnSide(this.field_145850_b, side);
        this.setConnectedRight(tileRight instanceof TileEntityScreen && tileRight.func_145832_p() == meta && !tileRight.func_145837_r());
    }

    public void onLoad() {
        if (this.field_145850_b.field_72995_K) {
            this.clientOnLoad();
            this.screen = new DrawGameScreen(1.0f, 1.0f, this);
        }
    }

    @Override
    public void buildDataPacket(int[] data) {
        data[0] = this.imageType;
        int connectedFlags = 0;
        if (this.connectedUp) {
            connectedFlags += 8;
        }
        if (this.connectedDown) {
            connectedFlags += 4;
        }
        if (this.connectedLeft) {
            connectedFlags += 2;
        }
        if (this.connectedRight) {
            // empty if block
        }
        data[1] = ++connectedFlags;
    }

    public EnumFacing getFront() {
        return this.getFacing(this.field_145850_b.func_180495_p(this.func_174877_v()));
    }

    private EnumFacing getFacing(IBlockState state) {
        return (EnumFacing)state.func_177229_b((IProperty)BlockScreen.FACING);
    }

    public void breakScreen(IBlockState state) {
        TileEntity tile;
        BlockVec3 vec = new BlockVec3(this);
        int meta = state.func_177230_c().func_176201_c(state);
        EnumFacing facingRight = this.getFacing(state).func_176746_e();
        int left = this.connectionsLeft;
        int right = this.connectionsRight;
        int up = this.connectionsUp;
        int down = this.connectionsDown;
        boolean doUp = this.connectedUp;
        boolean doDown = this.connectedDown;
        boolean doLeft = this.connectedLeft;
        boolean doRight = this.connectedRight;
        for (int x = -left; x <= right; ++x) {
            for (int z = -up; z <= down; ++z) {
                if (x == 0 && z == 0) {
                    this.resetToSingle();
                    continue;
                }
                BlockVec3 newVec = vec.clone().modifyPositionFromSide(facingRight, x).modifyPositionFromSide(EnumFacing.DOWN, z);
                tile = newVec.getTileEntity((IBlockAccess)this.field_145850_b);
                if (!(tile instanceof TileEntityScreen) || tile.func_145832_p() != meta) continue;
                ((TileEntityScreen)tile).resetToSingle();
            }
        }
        this.setConnectedDown(false);
        this.setConnectedUp(false);
        this.setConnectedLeft(false);
        this.setConnectedRight(false);
        if (doUp && (tile = vec.getTileEntityOnSide(this.field_145850_b, 1)) instanceof TileEntityScreen && tile.func_145832_p() == meta && !tile.func_145837_r()) {
            if (doLeft) {
                ((TileEntityScreen)tile).setConnectedLeft(true);
            }
            if (doRight) {
                ((TileEntityScreen)tile).setConnectedRight(true);
            }
            ((TileEntityScreen)tile).setConnectedUp(true);
            ((TileEntityScreen)tile).refreshConnections(true);
        }
        if (doDown && (tile = vec.getTileEntityOnSide(this.field_145850_b, 0)) instanceof TileEntityScreen && tile.func_145832_p() == meta && !tile.func_145837_r()) {
            if (doLeft) {
                ((TileEntityScreen)tile).setConnectedLeft(true);
            }
            if (doRight) {
                ((TileEntityScreen)tile).setConnectedRight(true);
            }
            ((TileEntityScreen)tile).setConnectedDown(true);
            ((TileEntityScreen)tile).refreshConnections(true);
        }
        if (doLeft && (tile = vec.getTileEntityOnSide(this.field_145850_b, this.getLeft(meta))) instanceof TileEntityScreen && tile.func_145832_p() == meta && !tile.func_145837_r()) {
            if (doUp) {
                ((TileEntityScreen)tile).setConnectedUp(true);
            }
            if (doDown) {
                ((TileEntityScreen)tile).setConnectedDown(true);
            }
            ((TileEntityScreen)tile).setConnectedLeft(true);
            ((TileEntityScreen)tile).refreshConnections(true);
        }
        if (doRight && (tile = vec.getTileEntityOnSide(this.field_145850_b, this.getRight(meta))) instanceof TileEntityScreen && tile.func_145832_p() == meta && !tile.func_145837_r()) {
            if (doUp) {
                ((TileEntityScreen)tile).setConnectedUp(true);
            }
            if (doDown) {
                ((TileEntityScreen)tile).setConnectedDown(true);
            }
            ((TileEntityScreen)tile).setConnectedRight(true);
            ((TileEntityScreen)tile).refreshConnections(true);
        }
    }

    public void refreshConnections(boolean doScreen) {
        this.log("Starting connection check");
        IBlockState iblockstate = this.field_145850_b.func_180495_p(this.field_174879_c);
        EnumFacing facing = (EnumFacing)iblockstate.func_177229_b((IProperty)BlockScreen.FACING);
        int meta = this.func_145832_p() & 7;
        if (meta < 2) {
            this.resetToSingle();
            return;
        }
        Object tileUp = null;
        Object tileDown = null;
        Object tileLeft = null;
        Object tileRight = null;
        BlockVec3 vec = new BlockVec3(this);
        if (this.connectedUp) {
            this.setVerifiedConnectedUp(vec);
        }
        if (this.connectedDown) {
            this.setVerifiedConnectedDown(vec);
        }
        if (this.connectedLeft) {
            this.setVerifiedConnectedLeft(vec);
        }
        if (this.connectedRight) {
            this.setVerifiedConnectedRight(vec);
        }
        if (this.connectedUp) {
            this.setConnectedUp(this.tryConnectUp(tileUp));
        }
        if (this.connectedDown) {
            this.setConnectedDown(this.tryConnectDown(tileDown));
        }
        if (this.connectedLeft) {
            this.setConnectedLeft(this.tryConnectLeft(tileLeft));
        }
        if (this.connectedRight) {
            this.setConnectedRight(this.tryConnectRight(tileRight));
        }
        this.log("Ending connection check");
        if (doScreen) {
            this.checkScreenSize();
            this.func_70296_d();
        }
    }

    public void changeChannel() {
        if (!this.field_145850_b.field_72995_K) {
            if (++this.imageType >= GalacticraftRegistry.getMaxScreenTypes()) {
                this.imageType = 0;
            }
            boolean flag = false;
            if (!this.connectedRight && this.canJoinRight()) {
                this.joinRight();
                flag = true;
            } else if (!this.connectedLeft && this.canJoinLeft()) {
                this.joinLeft();
                flag = true;
            } else if (!this.connectedUp && this.canJoinUp()) {
                this.joinUp();
                flag = true;
            } else if (!this.connectedDown && this.canJoinDown()) {
                this.joinDown();
                flag = true;
            }
            this.doneClientUpdate = false;
            this.refreshConnections(true);
            this.func_70296_d();
            if (!this.doneClientUpdate) {
                this.updateAllInDimension();
            }
        }
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.imageType = nbt.func_74762_e("type");
        this.connectionsDown = nbt.func_74762_e("connectionsDown");
        this.connectionsUp = nbt.func_74762_e("connectionsUp");
        this.connectionsLeft = nbt.func_74762_e("connectionsLeft");
        this.connectionsRight = nbt.func_74762_e("connectionsRight");
        this.isMultiscreen = nbt.func_74767_n("multiscreen");
        this.setConnectedUp(this.connectionsUp > 0);
        this.setConnectedDown(this.connectionsDown > 0);
        this.setConnectedLeft(this.connectionsLeft > 0);
        this.setConnectedRight(this.connectionsRight > 0);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74768_a("type", this.imageType);
        nbt.func_74768_a("connectionsDown", this.connectionsDown);
        nbt.func_74768_a("connectionsUp", this.connectionsUp);
        nbt.func_74768_a("connectionsLeft", this.connectionsLeft);
        nbt.func_74768_a("connectionsRight", this.connectionsRight);
        nbt.func_74757_a("multiscreen", this.isMultiscreen);
        return nbt;
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public void checkScreenSize() {
        TileEntityScreen tileRight;
        TileEntity newTile;
        int up;
        this.log("Checking screen size");
        int down = 0;
        int left = 0;
        int right = 0;
        int meta = this.func_145832_p() & 7;
        BlockVec3 vec = new BlockVec3(this);
        TileEntityScreen tile = this;
        for (up = 0; up < 8 && tile.connectedUp; ++up) {
            newTile = vec.getTileEntityOnSide(this.field_145850_b, 1);
            if (newTile instanceof TileEntityScreen) {
                tile = (TileEntityScreen)newTile;
                vec.translate(0, 1, 0);
                continue;
            }
            System.out.println("Debug - connected up to a non-screen tile");
            this.setConnectedUp(false);
            tile.func_70296_d();
            --up;
            break;
        }
        vec = new BlockVec3(this);
        tile = this;
        while (down < 8 - up && tile.connectedDown) {
            ++down;
            newTile = vec.getTileEntityOnSide(this.field_145850_b, 0);
            if (newTile instanceof TileEntityScreen) {
                tile = (TileEntityScreen)newTile;
                vec.translate(0, -1, 0);
                continue;
            }
            System.out.println("Debug - connected down to a non-screen tile");
            this.setConnectedDown(false);
            tile.func_70296_d();
            --down;
            break;
        }
        vec = new BlockVec3(this);
        tile = this;
        int leftside = this.getLeft(meta);
        while (left < (up + down == 0 ? 1 : 8) && tile.connectedLeft) {
            ++left;
            TileEntity newTile2 = vec.getTileEntityOnSide(this.field_145850_b, leftside);
            if (newTile2 instanceof TileEntityScreen) {
                tile = (TileEntityScreen)newTile2;
                vec = vec.newVecSide(leftside);
                continue;
            }
            System.out.println("Debug - connected left to a non-screen tile");
            this.setConnectedLeft(false);
            tile.func_70296_d();
            --left;
            break;
        }
        vec = new BlockVec3(this);
        tile = this;
        int rightside = this.getRight(meta);
        while (right < (up + down == 0 ? 1 : 8) - left && tile.connectedRight) {
            ++right;
            TileEntity newTile3 = vec.getTileEntityOnSide(this.field_145850_b, rightside);
            if (newTile3 instanceof TileEntityScreen) {
                tile = (TileEntityScreen)newTile3;
                vec = vec.newVecSide(rightside);
                continue;
            }
            System.out.println("Debug - connected right to a non-screen tile");
            this.setConnectedRight(false);
            tile.func_70296_d();
            --right;
            break;
        }
        this.log("Screen size check midpoint " + up + " " + down + " " + left + " " + right + " ");
        vec = new BlockVec3(this);
        TileEntity newtile = vec.getTileEntityOnSide(this.field_145850_b, 1);
        TileEntityScreen tileUp = newtile instanceof TileEntityScreen ? (TileEntityScreen)newtile : null;
        newtile = vec.getTileEntityOnSide(this.field_145850_b, 0);
        TileEntityScreen tileDown = newtile instanceof TileEntityScreen ? (TileEntityScreen)newtile : null;
        newtile = vec.getTileEntityOnSide(this.field_145850_b, leftside);
        TileEntityScreen tileLeft = newtile instanceof TileEntityScreen ? (TileEntityScreen)newtile : null;
        newtile = vec.getTileEntityOnSide(this.field_145850_b, rightside);
        TileEntityScreen tileEntityScreen = tileRight = newtile instanceof TileEntityScreen ? (TileEntityScreen)newtile : null;
        if (left + right == 0 && up + down >= 1) {
            if (up > 0 && !tileUp.connectedUp) {
                up = 1;
                down = 0;
            } else {
                up = 0;
                down = tileDown != null && !tileDown.connectedDown ? 1 : 0;
            }
        }
        if (up + down == 0 && left + right >= 1) {
            if (left > 0 && !tileLeft.connectedLeft) {
                if (right == 0 || tileRight == null || tileRight.connectionsLeft == 0) {
                    left = 1;
                    right = 0;
                } else {
                    left = 0;
                    right = 1;
                }
            } else {
                left = 0;
                right = tileRight != null && !tileRight.connectedRight ? 1 : 0;
            }
        }
        if (up == 0) {
            this.setConnectedUp(false);
            if (tileUp != null) {
                tileUp.setConnectedDown(false);
            }
        }
        if (down == 0) {
            this.setConnectedDown(false);
            if (tileUp != null) {
                tileUp.setConnectedUp(false);
            }
        }
        if (left == 0) {
            this.setConnectedLeft(false);
            if (tileUp != null) {
                tileUp.setConnectedRight(false);
            }
        }
        if (right == 0) {
            this.setConnectedRight(false);
            if (tileUp != null) {
                tileUp.setConnectedLeft(false);
            }
        }
        this.log("Finished screen size check");
        this.checkWholeScreen(up, down, left, right);
    }

    private boolean checkWholeScreen(int up, int down, int left, int right) {
        if (up + down + left + right == 0 || up < 0 || down < 0 || left < 0 || right < 0) {
            this.doneClientUpdate = true;
            this.resetToSingle();
            return true;
        }
        boolean screenWhole = true;
        boolean existingScreen = false;
        int barrierUp = up;
        int barrierDown = down;
        int barrierLeft = left;
        int barrierRight = right;
        int meta = this.func_145832_p() & 7;
        BlockVec3 vec = new BlockVec3(this);
        ArrayList<TileEntityScreen> screenList = new ArrayList<TileEntityScreen>();
        EnumFacing side = this.getFront().func_176746_e();
        for (int x = -left; x <= right; ++x) {
            for (int z = -up; z <= down; ++z) {
                BlockVec3 newVec = vec.clone().modifyPositionFromSide(side, x).modifyPositionFromSide(EnumFacing.DOWN, z);
                TileEntity tile = newVec.getTileEntity((IBlockAccess)this.field_145850_b);
                if (tile instanceof TileEntityScreen && tile.func_145832_p() == meta && !tile.func_145837_r()) {
                    TileEntityScreen screenTile = (TileEntityScreen)tile;
                    screenList.add(screenTile);
                    if (!screenTile.isMultiscreen) continue;
                    if (screenTile.connectionsUp > z + up) {
                        barrierUp = -z - 1;
                        existingScreen = true;
                    }
                    if (screenTile.connectionsDown > down - z) {
                        barrierDown = z - 1;
                        existingScreen = true;
                    }
                    if (screenTile.connectionsLeft > x + left) {
                        barrierLeft = -x - 1;
                        existingScreen = true;
                    }
                    if (screenTile.connectionsRight <= right - x) continue;
                    barrierRight = x - 1;
                    existingScreen = true;
                    continue;
                }
                screenWhole = false;
            }
        }
        if (!screenWhole) {
            for (TileEntityScreen scr : screenList) {
                scr.resetToSingle();
            }
            return false;
        }
        if (existingScreen) {
            return this.checkWholeScreen(barrierUp, barrierDown, barrierLeft, barrierRight);
        }
        DrawGameScreen newScreen = null;
        boolean serverside = true;
        TileEntity bottomLeft = vec.clone().modifyPositionFromSide(side, -left).modifyPositionFromSide(EnumFacing.DOWN, down).getTileEntity((IBlockAccess)this.field_145850_b);
        if (this.field_145850_b.field_72995_K) {
            if (bottomLeft instanceof TileEntityScreen && !(newScreen = ((TileEntityScreen)bottomLeft).screen).check(1.0f + (float)left + (float)right, 1.0f + (float)up + (float)down)) {
                newScreen = new DrawGameScreen(1.0f + (float)left + (float)right, 1.0f + (float)up + (float)down, bottomLeft);
            }
            serverside = false;
        }
        Iterator it = screenList.iterator();
        for (int x = -left; x <= right; ++x) {
            for (int z = -up; z <= down; ++z) {
                TileEntityScreen screenTile = (TileEntityScreen)it.next();
                screenTile.screenOffsetx = x + left;
                screenTile.screenOffsetz = z + up;
                screenTile.screen = newScreen;
                screenTile.connectionsLeft = x + left;
                screenTile.connectionsRight = right - x;
                screenTile.connectionsUp = z + up;
                screenTile.connectionsDown = down - z;
                screenTile.isMultiscreen = true;
                screenTile.refreshOnUpdate = false;
                if (serverside) {
                    screenTile.imageType = this.imageType;
                    screenTile.func_70296_d();
                    screenTile.updateAllInDimension();
                }
                screenTile.refreshConnections(false);
            }
        }
        this.connectionsUp = up;
        this.connectionsDown = down;
        this.connectionsLeft = left;
        this.connectionsRight = right;
        return true;
    }

    public void resetToSingle() {
        this.screenOffsetx = 0;
        this.screenOffsetz = 0;
        this.connectionsUp = 0;
        this.connectionsDown = 0;
        this.connectionsLeft = 0;
        this.connectionsRight = 0;
        this.isMultiscreen = false;
        this.setConnectedLeft(false);
        this.setConnectedRight(false);
        this.setConnectedUp(false);
        this.setConnectedDown(false);
        this.refreshOnUpdate = false;
        this.func_70296_d();
        if (this.field_145850_b.field_72995_K) {
            this.screen = new DrawGameScreen(1.0f, 1.0f, this);
        } else {
            this.updateAllInDimension();
        }
    }

    private int getLeft(int meta) {
        switch (meta) {
            case 2: {
                return 4;
            }
            case 3: {
                return 5;
            }
            case 4: {
                return 3;
            }
            case 5: {
                return 2;
            }
        }
        return 4;
    }

    private int getRight(int meta) {
        switch (meta) {
            case 2: {
                return 5;
            }
            case 3: {
                return 4;
            }
            case 4: {
                return 2;
            }
            case 5: {
                return 3;
            }
        }
        return 5;
    }

    private boolean canJoinRight() {
        int meta = this.func_145832_p();
        TileEntity te = new BlockVec3(this).getTileEntityOnSide(this.field_145850_b, this.getRight(meta));
        if (!(te instanceof TileEntityScreen)) {
            return false;
        }
        TileEntityScreen screenTile = (TileEntityScreen)te;
        if (screenTile.func_145832_p() != meta) {
            return false;
        }
        if (screenTile.connectionsUp != this.connectionsUp) {
            return false;
        }
        if (screenTile.connectionsDown != this.connectionsDown) {
            return false;
        }
        if (this.connectionsUp + this.connectionsDown > 0) {
            return true;
        }
        if (this.connectionsLeft > 0) {
            return false;
        }
        return screenTile.connectionsRight <= 0;
    }

    private boolean canJoinLeft() {
        int meta = this.func_145832_p();
        TileEntity te = new BlockVec3(this).getTileEntityOnSide(this.field_145850_b, this.getLeft(meta));
        if (!(te instanceof TileEntityScreen)) {
            return false;
        }
        TileEntityScreen screenTile = (TileEntityScreen)te;
        if (screenTile.func_145832_p() != meta) {
            return false;
        }
        if (screenTile.connectionsUp != this.connectionsUp) {
            return false;
        }
        if (screenTile.connectionsDown != this.connectionsDown) {
            return false;
        }
        if (this.connectionsUp + this.connectionsDown > 0) {
            return true;
        }
        if (this.connectionsRight > 0) {
            return false;
        }
        return screenTile.connectionsLeft <= 0;
    }

    private boolean canJoinUp() {
        int meta = this.func_145832_p();
        TileEntity te = new BlockVec3(this).getTileEntityOnSide(this.field_145850_b, 1);
        if (!(te instanceof TileEntityScreen)) {
            return false;
        }
        TileEntityScreen screenTile = (TileEntityScreen)te;
        if (screenTile.func_145832_p() != meta) {
            return false;
        }
        if (screenTile.connectionsLeft != this.connectionsLeft) {
            return false;
        }
        if (screenTile.connectionsRight != this.connectionsRight) {
            return false;
        }
        if (this.connectionsLeft + this.connectionsRight > 0) {
            return true;
        }
        if (this.connectionsDown > 0) {
            return false;
        }
        return screenTile.connectionsUp <= 0;
    }

    private boolean canJoinDown() {
        int meta = this.func_145832_p();
        TileEntity te = new BlockVec3(this).getTileEntityOnSide(this.field_145850_b, 0);
        if (!(te instanceof TileEntityScreen)) {
            return false;
        }
        TileEntityScreen screenTile = (TileEntityScreen)te;
        if (screenTile.func_145832_p() != meta) {
            return false;
        }
        if (screenTile.connectionsLeft != this.connectionsLeft) {
            return false;
        }
        if (screenTile.connectionsRight != this.connectionsRight) {
            return false;
        }
        if (this.connectionsLeft + this.connectionsRight > 0) {
            return true;
        }
        if (this.connectionsUp > 0) {
            return false;
        }
        return screenTile.connectionsDown <= 0;
    }

    private void joinRight() {
        int meta = this.func_145832_p();
        int side = this.getRight(meta);
        BlockVec3 vec = new BlockVec3(this);
        for (int z = -this.connectionsUp; z <= this.connectionsDown; ++z) {
            BlockVec3 newVec = vec.clone().modifyPositionFromSide(EnumFacing.DOWN, z);
            TileEntityScreen tile = z == 0 ? this : newVec.getTileEntity((IBlockAccess)this.field_145850_b);
            if (!(tile instanceof TileEntityScreen) || tile.func_145832_p() != meta || tile.func_145837_r()) continue;
            TileEntityScreen screenTile = tile;
            screenTile.setConnectedRight(true);
            TileEntity te2 = newVec.getTileEntityOnSide(this.field_145850_b, side);
            if (!(te2 instanceof TileEntityScreen) || te2.func_145832_p() != meta || te2.func_145837_r()) continue;
            screenTile.tryConnectRight((TileEntityScreen)te2);
        }
    }

    private void joinLeft() {
        int meta = this.func_145832_p();
        int side = this.getLeft(meta);
        BlockVec3 vec = new BlockVec3(this);
        for (int z = -this.connectionsUp; z <= this.connectionsDown; ++z) {
            BlockVec3 newVec = vec.clone().modifyPositionFromSide(EnumFacing.DOWN, z);
            TileEntityScreen tile = z == 0 ? this : newVec.getTileEntity((IBlockAccess)this.field_145850_b);
            if (!(tile instanceof TileEntityScreen) || tile.func_145832_p() != meta || tile.func_145837_r()) continue;
            TileEntityScreen screenTile = tile;
            screenTile.setConnectedLeft(true);
            TileEntity te2 = newVec.getTileEntityOnSide(this.field_145850_b, side);
            if (!(te2 instanceof TileEntityScreen) || te2.func_145832_p() != meta || te2.func_145837_r()) continue;
            screenTile.tryConnectLeft((TileEntityScreen)te2);
        }
    }

    private void joinUp() {
        int meta = this.func_145832_p();
        EnumFacing side = this.getFront().func_176746_e();
        BlockVec3 vec = new BlockVec3(this);
        for (int x = -this.connectionsLeft; x <= this.connectionsRight; ++x) {
            BlockVec3 newVec = vec.clone().modifyPositionFromSide(side, x);
            TileEntityScreen tile = x == 0 ? this : newVec.getTileEntity((IBlockAccess)this.field_145850_b);
            if (!(tile instanceof TileEntityScreen) || tile.func_145832_p() != meta || tile.func_145837_r()) continue;
            TileEntityScreen screenTile = tile;
            screenTile.setConnectedUp(true);
            TileEntity te2 = newVec.getTileEntityOnSide(this.field_145850_b, 1);
            if (!(te2 instanceof TileEntityScreen) || te2.func_145832_p() != meta || te2.func_145837_r()) continue;
            screenTile.tryConnectUp((TileEntityScreen)te2);
        }
    }

    private void joinDown() {
        int meta = this.func_145832_p();
        EnumFacing side = this.getFront().func_176746_e();
        BlockVec3 vec = new BlockVec3(this);
        for (int x = -this.connectionsLeft; x <= this.connectionsRight; ++x) {
            BlockVec3 newVec = vec.clone().modifyPositionFromSide(side, x);
            TileEntityScreen tile = x == 0 ? this : newVec.getTileEntity((IBlockAccess)this.field_145850_b);
            if (!(tile instanceof TileEntityScreen) || tile.func_145832_p() != meta || tile.func_145837_r()) continue;
            TileEntityScreen screenTile = tile;
            screenTile.setConnectedDown(true);
            TileEntity te2 = newVec.getTileEntityOnSide(this.field_145850_b, 0);
            if (!(te2 instanceof TileEntityScreen) || te2.func_145832_p() != meta || te2.func_145837_r()) continue;
            screenTile.tryConnectDown((TileEntityScreen)te2);
        }
    }

    private boolean tryConnectUp(TileEntityScreen screenTile) {
        if (screenTile.connectedDown) {
            return true;
        }
        screenTile.setConnectedDown(true);
        BlockVec3 vec = null;
        if (this.connectedLeft) {
            vec = new BlockVec3(screenTile);
            screenTile.setVerifiedConnectedLeft(vec);
        }
        if (this.connectedRight) {
            if (vec == null) {
                vec = new BlockVec3(screenTile);
            }
            screenTile.setVerifiedConnectedRight(vec);
        }
        screenTile.refreshConnections(false);
        if (this.connectedLeft ^ screenTile.connectedLeft || this.connectedRight ^ screenTile.connectedRight) {
            screenTile.setConnectedDown(false);
            return false;
        }
        return true;
    }

    private boolean tryConnectDown(TileEntityScreen screenTile) {
        if (screenTile.connectedUp) {
            return true;
        }
        screenTile.setConnectedUp(true);
        BlockVec3 vec = null;
        if (this.connectedLeft) {
            vec = new BlockVec3(screenTile);
            screenTile.setVerifiedConnectedLeft(vec);
        }
        if (this.connectedRight) {
            if (vec == null) {
                vec = new BlockVec3(screenTile);
            }
            screenTile.setVerifiedConnectedRight(vec);
        }
        screenTile.refreshConnections(false);
        if (this.connectedLeft ^ screenTile.connectedLeft || this.connectedRight ^ screenTile.connectedRight) {
            screenTile.setConnectedUp(false);
            return false;
        }
        return true;
    }

    private boolean tryConnectLeft(TileEntityScreen screenTile) {
        if (screenTile.connectedRight) {
            return true;
        }
        if (screenTile.connectedUp && !this.connectedUp || screenTile.connectedDown && !this.connectedDown) {
            return false;
        }
        screenTile.setConnectedRight(true);
        BlockVec3 vec = null;
        if (this.connectedUp) {
            vec = new BlockVec3(screenTile);
            screenTile.setVerifiedConnectedUp(vec);
        }
        if (this.connectedDown) {
            if (vec == null) {
                vec = new BlockVec3(screenTile);
            }
            screenTile.setVerifiedConnectedDown(vec);
        }
        screenTile.refreshConnections(false);
        if (this.connectedUp ^ screenTile.connectedUp || this.connectedDown ^ screenTile.connectedDown) {
            screenTile.setConnectedRight(false);
            return false;
        }
        return true;
    }

    private boolean tryConnectRight(TileEntityScreen screenTile) {
        if (screenTile.connectedLeft) {
            return true;
        }
        if (screenTile.connectedUp && !this.connectedUp || screenTile.connectedDown && !this.connectedDown) {
            return false;
        }
        screenTile.setConnectedLeft(true);
        BlockVec3 vec = null;
        if (this.connectedUp) {
            vec = new BlockVec3(screenTile);
            screenTile.setVerifiedConnectedUp(vec);
        }
        if (this.connectedDown) {
            if (vec == null) {
                vec = new BlockVec3(screenTile);
            }
            screenTile.setVerifiedConnectedDown(vec);
        }
        screenTile.refreshConnections(false);
        if (this.connectedUp ^ screenTile.connectedUp || this.connectedDown ^ screenTile.connectedDown) {
            screenTile.setConnectedLeft(false);
            return false;
        }
        return true;
    }

    private void log(String msg) {
        String connections = "";
        String strSide = "S";
        if (this.connectedUp) {
            connections = "U";
        }
        if (this.connectedDown) {
            connections = connections + "D";
        }
        if (this.connectedLeft) {
            connections = connections + "L";
        }
        if (this.connectedRight) {
            connections = connections + "R";
        }
        if (this.field_145850_b.field_72995_K) {
            strSide = "C";
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void refreshNextTick(boolean b) {
        this.refreshOnUpdate = true;
        TickHandlerClient.screenConnectionsUpdateList.add(this);
    }

    @Override
    public double getPacketRange() {
        return 0.0;
    }

    @Override
    public int getPacketCooldown() {
        return 0;
    }

    @Override
    public boolean isNetworkedTile() {
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void updateClient(List<Object> data) {
        int screenType = (Integer)data.get(1);
        int flags = (Integer)data.get(2);
        this.imageType = screenType;
        this.connectedUp = (flags & 8) != 0;
        this.connectedDown = (flags & 4) != 0;
        this.connectedLeft = (flags & 2) != 0;
        this.connectedRight = (flags & 1) != 0;
        this.refreshNextTick(true);
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        if (this.renderAABB == null) {
            this.renderAABB = new AxisAlignedBB(this.field_174879_c, this.field_174879_c.func_177982_a(1, 1, 1));
        }
        return this.renderAABB;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }
}

