/*
 * Decompiled with CFR 0.152.
 */
package cubex2.cs4.plugins.vanilla;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import cubex2.cs4.api.BlockTint;
import cubex2.cs4.api.Color;
import cubex2.cs4.plugins.vanilla.BlockTintRegistry;
import java.lang.reflect.Type;

class BlockTintDeserializer
implements JsonDeserializer<BlockTint> {
    private final BlockTintRegistry registry;

    BlockTintDeserializer(BlockTintRegistry registry) {
        this.registry = registry;
    }

    public BlockTint deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        JsonPrimitive primitive;
        if (json.isJsonPrimitive() && (primitive = json.getAsJsonPrimitive()).isString()) {
            String string = primitive.getAsString();
            BlockTint tint = this.registry.getBlockTint(string);
            if (tint != null) {
                return tint;
            }
            Color color = (Color)context.deserialize(json, Color.class);
            if (color != null) {
                int rgb = color.getRGB();
                return (world, pos) -> rgb;
            }
        }
        throw new JsonParseException("Invalid block tint: " + json);
    }
}

