/*
 * Decompiled with CFR 0.152.
 */
package cubex2.cs4.plugins.vanilla.block;

import cubex2.cs4.plugins.vanilla.ContentBlockSlab;
import cubex2.cs4.plugins.vanilla.block.CSBlock;
import cubex2.cs4.plugins.vanilla.block.StateMetaMapper;
import java.util.Collections;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeModContainer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class BlockSlab
extends Block
implements CSBlock<ContentBlockSlab> {
    public static final PropertyEnum<BlockSlab.EnumBlockHalf> HALF = PropertyEnum.func_177709_a((String)"half", BlockSlab.EnumBlockHalf.class);
    protected static final AxisAlignedBB AABB_BOTTOM_HALF = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.5, 1.0);
    protected static final AxisAlignedBB AABB_TOP_HALF = new AxisAlignedBB(0.0, 0.5, 0.0, 1.0, 1.0, 1.0);
    private final ContentBlockSlab content;
    protected StateMetaMapper<BlockSlab> mapper;

    public BlockSlab(Material material, ContentBlockSlab content) {
        super(material, MapColor.field_151660_b);
        this.content = content;
        this.mapper = StateMetaMapper.create(Collections.singleton(HALF));
        this.field_149783_u = true;
    }

    public int func_176201_c(IBlockState state) {
        return this.mapper.getMetaFromState(state);
    }

    public IBlockState func_176203_a(int meta) {
        return this.mapper.getStateFromMeta(this, meta);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return state.func_177229_b(HALF) == BlockSlab.EnumBlockHalf.TOP ? AABB_TOP_HALF : AABB_BOTTOM_HALF;
    }

    public boolean isFullyOpaque(IBlockState state) {
        return state.func_177229_b(HALF) == BlockSlab.EnumBlockHalf.TOP;
    }

    public boolean doesSideBlockRendering(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing face) {
        if (ForgeModContainer.disableStairSlabCulling) {
            return super.doesSideBlockRendering(state, world, pos, face);
        }
        if (state.func_185914_p()) {
            return true;
        }
        BlockSlab.EnumBlockHalf side = (BlockSlab.EnumBlockHalf)state.func_177229_b(HALF);
        return side == BlockSlab.EnumBlockHalf.TOP && face == EnumFacing.UP || side == BlockSlab.EnumBlockHalf.BOTTOM && face == EnumFacing.DOWN;
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        IBlockState iblockstate = this.func_176223_P().func_177226_a(HALF, (Comparable)BlockSlab.EnumBlockHalf.BOTTOM);
        return facing != EnumFacing.DOWN && (facing == EnumFacing.UP || (double)hitY <= 0.5) ? iblockstate : iblockstate.func_177226_a(HALF, (Comparable)BlockSlab.EnumBlockHalf.TOP);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        if (side != EnumFacing.UP && side != EnumFacing.DOWN && !super.func_176225_a(blockState, blockAccess, pos, side)) {
            return false;
        }
        return super.func_176225_a(blockState, blockAccess, pos, side);
    }

    @Deprecated
    @SideOnly(value=Side.CLIENT)
    public int func_185484_c(IBlockState state, IBlockAccess source, BlockPos pos) {
        int i = source.func_175626_b(pos, state.getLightValue(source, pos));
        if (i == 0 && (state.func_177230_c() instanceof net.minecraft.block.BlockSlab || state.func_177230_c() instanceof BlockSlab)) {
            pos = pos.func_177977_b();
            state = source.func_180495_p(pos);
            return source.func_175626_b(pos, state.getLightValue(source, pos));
        }
        return i;
    }

    public boolean isSideSolid(IBlockState base_state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        IBlockState state = this.func_176221_a(base_state, world, pos);
        return base_state.func_185913_b() || state.func_177229_b((IProperty)net.minecraft.block.BlockSlab.field_176554_a) == BlockSlab.EnumBlockHalf.TOP && side == EnumFacing.UP || state.func_177229_b((IProperty)net.minecraft.block.BlockSlab.field_176554_a) == BlockSlab.EnumBlockHalf.BOTTOM && side == EnumFacing.DOWN;
    }

    @Override
    public int getSubtype(IBlockState state) {
        return 0;
    }

    @Override
    public ContentBlockSlab getContent() {
        return this.content;
    }

    @Override
    public int[] getSubtypes() {
        return this.content.subtypes;
    }

    @Override
    public IProperty<?>[] getProperties() {
        return new IProperty[]{HALF};
    }
}

