/*
 * Decompiled with CFR 0.152.
 */
package cubex2.cs4.plugins.vanilla.network;

import cubex2.cs4.CustomStuff4;
import cubex2.cs4.plugins.vanilla.gui.ContainerCS4;
import cubex2.cs4.util.NetworkHelper;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IThreadListener;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketSyncContainerFluid
implements IMessage {
    private int windowId;
    private int tank;
    private FluidStack fluid;

    public PacketSyncContainerFluid(int windowId, int tank, FluidStack fluid) {
        this.windowId = windowId;
        this.tank = tank;
        this.fluid = fluid;
    }

    public PacketSyncContainerFluid() {
    }

    public void fromBytes(ByteBuf buf) {
        this.windowId = buf.readByte();
        this.tank = buf.readByte();
        NBTTagCompound fluidNbt = ByteBufUtils.readTag((ByteBuf)buf);
        this.fluid = FluidStack.loadFluidStackFromNBT((NBTTagCompound)fluidNbt);
    }

    public void toBytes(ByteBuf buf) {
        buf.writeByte(this.windowId);
        buf.writeByte(this.tank);
        NBTTagCompound fluidNbt = this.fluid == null ? null : this.fluid.writeToNBT(new NBTTagCompound());
        ByteBufUtils.writeTag((ByteBuf)buf, fluidNbt);
    }

    public static class Handler
    implements IMessageHandler<PacketSyncContainerFluid, IMessage> {
        public IMessage onMessage(PacketSyncContainerFluid message, MessageContext ctx) {
            EntityPlayer player = CustomStuff4.proxy.getClientPlayer();
            if (NetworkHelper.checkThreadAndEnqueue(message, this, ctx, (IThreadListener)Minecraft.func_71410_x())) {
                return null;
            }
            if (player.field_71070_bA.field_75152_c == message.windowId && player.field_71070_bA instanceof ContainerCS4) {
                ContainerCS4 container = (ContainerCS4)player.field_71070_bA;
                container.putFluidInTank(message.tank, message.fluid);
            }
            return null;
        }
    }
}

