/*
 * Decompiled with CFR 0.152.
 */
package cubex2.cs4.plugins.vanilla.tileentity;

import cubex2.cs4.api.TileEntityModule;
import cubex2.cs4.api.TileEntityModuleSupplier;
import cubex2.cs4.plugins.vanilla.gui.FluidSource;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import org.apache.commons.lang3.ArrayUtils;

public class TileEntityModuleTank
implements TileEntityModule,
FluidSource {
    private final Supplier supplier;
    private final Tank tank;

    public TileEntityModuleTank(Supplier supplier, TileEntity tile) {
        this.supplier = supplier;
        this.tank = new Tank(supplier.capacity);
        this.tank.setCanDrain(supplier.canDrain);
        this.tank.setCanFill(supplier.canFill);
        this.tank.setTileEntity(tile);
    }

    @Override
    public void readFromNBT(NBTTagCompound compound) {
        this.tank.readFromNBT(compound);
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound compound) {
        return this.tank.writeToNBT(compound);
    }

    @Override
    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return facing == null || ArrayUtils.contains((Object[])this.supplier.sides, (Object)facing);
        }
        return false;
    }

    @Override
    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY && (facing == null || ArrayUtils.contains((Object[])this.supplier.sides, (Object)facing))) {
            return (T)((Object)this.tank);
        }
        return null;
    }

    @Override
    @Nullable
    public IFluidTank getFluidTank(String name) {
        return this.tank;
    }

    public static class Supplier
    implements TileEntityModuleSupplier {
        public int capacity = 10000;
        public boolean canDrain = true;
        public boolean canFill = true;
        public EnumFacing[] sides = EnumFacing.values();

        @Override
        public TileEntityModule createModule(TileEntity tileEntity) {
            return new TileEntityModuleTank(this, tileEntity);
        }
    }

    private class Tank
    extends FluidTank {
        public Tank(int capacity) {
            super(capacity);
        }

        protected void onContentsChanged() {
            this.tile.func_70296_d();
        }
    }
}

