/*
 * Decompiled with CFR 0.152.
 */
package crafttweaker.api.data;

import crafttweaker.api.data.IData;
import crafttweaker.api.data.IDataConverter;
import java.util.List;
import java.util.Map;

public class DataInt
implements IData {
    private final int value;

    public DataInt(int value) {
        this.value = value;
    }

    @Override
    public boolean asBool() {
        throw new RuntimeException("Cannot cast an int to a bool");
    }

    @Override
    public byte asByte() {
        return (byte)this.value;
    }

    @Override
    public short asShort() {
        return (short)this.value;
    }

    @Override
    public int asInt() {
        return this.value;
    }

    @Override
    public long asLong() {
        return this.value;
    }

    @Override
    public float asFloat() {
        return this.value;
    }

    @Override
    public double asDouble() {
        return this.value;
    }

    @Override
    public String asString() {
        return Integer.toString(this.value);
    }

    @Override
    public List<IData> asList() {
        return null;
    }

    @Override
    public Map<String, IData> asMap() {
        return null;
    }

    @Override
    public byte[] asByteArray() {
        return null;
    }

    @Override
    public int[] asIntArray() {
        return null;
    }

    @Override
    public IData getAt(int i) {
        throw new RuntimeException("An int is not indexable");
    }

    @Override
    public void setAt(int i, IData value) {
        throw new RuntimeException("An int is not indexable");
    }

    @Override
    public IData memberGet(String name) {
        throw new RuntimeException("An int is not indexable");
    }

    @Override
    public void memberSet(String name, IData data) {
        throw new RuntimeException("An int is not indexable");
    }

    @Override
    public int length() {
        return 0;
    }

    @Override
    public boolean contains(IData data) {
        return data.asInt() == this.value;
    }

    @Override
    public boolean equals(IData data) {
        return this.value == data.asInt();
    }

    @Override
    public int compareTo(IData data) {
        return Integer.compare(this.value, data.asInt());
    }

    @Override
    public IData immutable() {
        return this;
    }

    @Override
    public IData update(IData data) {
        return data;
    }

    @Override
    public <T> T convert(IDataConverter<T> converter) {
        return converter.fromInt(this.value);
    }

    @Override
    public IData add(IData other) {
        return new DataInt(this.value + other.asInt());
    }

    @Override
    public IData sub(IData other) {
        return new DataInt(this.value - other.asInt());
    }

    @Override
    public IData mul(IData other) {
        return new DataInt(this.value * other.asInt());
    }

    @Override
    public IData div(IData other) {
        return new DataInt(this.value / other.asInt());
    }

    @Override
    public IData mod(IData other) {
        return new DataInt(this.value % other.asInt());
    }

    @Override
    public IData and(IData other) {
        return new DataInt(this.value & other.asInt());
    }

    @Override
    public IData or(IData other) {
        return new DataInt(this.value | other.asInt());
    }

    @Override
    public IData xor(IData other) {
        return new DataInt(this.value ^ other.asInt());
    }

    @Override
    public IData neg() {
        return new DataInt(-this.value);
    }

    @Override
    public IData not() {
        return new DataInt(~this.value);
    }

    @Override
    public String toString() {
        return this.asString();
    }
}

