/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.core.common;

import com.enderio.core.api.common.util.IProgressTile;
import com.enderio.core.common.NBTAction;
import com.enderio.core.common.config.ConfigHandler;
import com.enderio.core.common.network.EnderPacketHandler;
import com.enderio.core.common.network.PacketProgress;
import com.enderio.core.common.util.NullHelper;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.server.management.PlayerChunkMap;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public abstract class TileEntityBase
extends TileEntity
implements ITickable {
    private final int checkOffset = (int)(Math.random() * 20.0);
    protected final boolean isProgressTile = this instanceof IProgressTile;
    protected float lastProgressSent = -1.0f;
    protected long lastProgressUpdate;
    private long lastUpdate = 0L;

    public final void func_73660_a() {
        if (!this.func_145830_o() || this.func_145837_r() || !this.field_145850_b.func_175667_e(this.func_174877_v()) || this.field_145850_b.func_175625_s(this.func_174877_v()) != this) {
            return;
        }
        if (ConfigHandler.allowExternalTickSpeedup || this.field_145850_b.func_82737_E() != this.lastUpdate) {
            this.lastUpdate = this.field_145850_b.func_82737_E();
            this.doUpdate();
            this.sendProgressIf();
        }
    }

    public static int getProgressScaled(int scale, @Nonnull IProgressTile tile) {
        return (int)(tile.getProgress() * (float)scale);
    }

    private final void sendProgressIf() {
        if (this.isProgressTile && !this.field_145850_b.field_72995_K) {
            boolean send;
            float progress = ((IProgressTile)((Object)this)).getProgress();
            boolean bl = send = progress < this.lastProgressSent || this.lastProgressSent <= 0.0f && progress > 0.0f || this.lastUpdate - this.lastProgressUpdate > 1200L;
            if (send) {
                EnderPacketHandler.INSTANCE.sendToAllAround(((IProgressTile)((Object)this)).getProgressPacket(), this);
                this.lastProgressSent = progress;
                this.lastProgressUpdate = this.lastUpdate;
            }
        }
    }

    protected void doUpdate() {
    }

    @Nonnull
    public IMessage getProgressPacket() {
        return new PacketProgress((IProgressTile)((Object)this));
    }

    @Nonnull
    public final NBTTagCompound func_189515_b(@Nonnull NBTTagCompound root) {
        super.func_189515_b(root);
        this.writeCustomNBT(NBTAction.SAVE, root);
        return root;
    }

    public final void func_145839_a(@Nonnull NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.readCustomNBT(NBTAction.SAVE, tag);
    }

    @Nonnull
    public final NBTTagCompound func_189517_E_() {
        NBTTagCompound tag = super.func_189517_E_();
        this.writeCustomNBT(NBTAction.CLIENT, tag);
        if (this.isProgressTile) {
            tag.func_74776_a("tileprogress", ((IProgressTile)((Object)this)).getProgress());
        }
        return tag;
    }

    public final void handleUpdateTag(@Nonnull NBTTagCompound tag) {
        super.handleUpdateTag(tag);
        this.readCustomNBT(NBTAction.CLIENT, tag);
        if (this.isProgressTile) {
            ((IProgressTile)((Object)this)).setProgress(tag.func_74760_g("tileprogress"));
        }
    }

    public final SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound tag = new NBTTagCompound();
        this.writeCustomNBT(NBTAction.CLIENT, tag);
        if (this.isProgressTile) {
            tag.func_74776_a("tileprogress", ((IProgressTile)((Object)this)).getProgress());
        }
        return new SPacketUpdateTileEntity(this.func_174877_v(), 1, tag);
    }

    public final void onDataPacket(@Nonnull NetworkManager net, @Nonnull SPacketUpdateTileEntity pkt) {
        this.readCustomNBT(NBTAction.CLIENT, pkt.func_148857_g());
        if (this.isProgressTile) {
            ((IProgressTile)((Object)this)).setProgress(pkt.func_148857_g().func_74760_g("tileprogress"));
        }
    }

    protected void writeCustomNBT(@Nonnull ItemStack stack) {
        NBTTagCompound tag = new NBTTagCompound();
        this.writeCustomNBT(NBTAction.ITEM, tag);
        if (!tag.func_82582_d()) {
            stack.func_77982_d(tag);
        }
    }

    @Deprecated
    protected abstract void writeCustomNBT(@Nonnull NBTAction var1, @Nonnull NBTTagCompound var2);

    protected void readCustomNBT(@Nonnull ItemStack stack) {
        if (stack.func_77942_o()) {
            this.readCustomNBT(NBTAction.ITEM, NullHelper.notnullM(stack.func_77978_p(), "tag compound vanished"));
        }
    }

    @Deprecated
    protected abstract void readCustomNBT(@Nonnull NBTAction var1, @Nonnull NBTTagCompound var2);

    public boolean canPlayerAccess(EntityPlayer player) {
        return this.func_145830_o() && !this.func_145837_r() && player.func_174831_c(this.func_174877_v()) <= 64.0;
    }

    protected void updateBlock() {
        if (this.func_145830_o() && this.field_145850_b.func_175667_e(this.func_174877_v())) {
            IBlockState bs = this.field_145850_b.func_180495_p(this.func_174877_v());
            this.field_145850_b.func_184138_a(this.field_174879_c, bs, bs, 3);
        }
    }

    protected boolean isPoweredRedstone() {
        return this.func_145830_o() && this.field_145850_b.func_175667_e(this.func_174877_v()) ? this.field_145850_b.func_175687_A(this.func_174877_v()) > 0 : false;
    }

    public void init() {
    }

    protected boolean shouldDoWorkThisTick(int interval) {
        return this.shouldDoWorkThisTick(interval, 0);
    }

    protected boolean shouldDoWorkThisTick(int interval, int offset) {
        return (this.field_145850_b.func_82737_E() + (long)this.checkOffset + (long)offset) % (long)interval == 0L;
    }

    public boolean shouldRefresh(@Nonnull World worldIn, @Nonnull BlockPos posIn, @Nonnull IBlockState oldState, @Nonnull IBlockState newState) {
        return oldState.func_177230_c() != newState.func_177230_c();
    }

    public void setGhostSlotContents(int slot, @Nonnull ItemStack stack, int realsize) {
    }

    public void func_70296_d() {
        if (this.func_145830_o() && this.field_145850_b.func_175667_e(this.func_174877_v())) {
            this.field_145850_b.func_175646_b(this.field_174879_c, (TileEntity)this);
            IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
            if (state.func_185912_n()) {
                this.field_145850_b.func_175666_e(this.field_174879_c, state.func_177230_c());
            }
        }
    }

    public void forceUpdatePlayers() {
        if (!(this.field_145850_b instanceof WorldServer)) {
            return;
        }
        WorldServer worldServer = (WorldServer)this.field_145850_b;
        PlayerChunkMap playerManager = worldServer.func_184164_w();
        SPacketUpdateTileEntity updatePacket = null;
        int chunkX = this.field_174879_c.func_177958_n() >> 4;
        int chunkZ = this.field_174879_c.func_177952_p() >> 4;
        for (EntityPlayer playerObj : this.field_145850_b.field_73010_i) {
            EntityPlayerMP player;
            if (!(playerObj instanceof EntityPlayerMP) || !playerManager.func_72694_a(player = (EntityPlayerMP)playerObj, chunkX, chunkZ)) continue;
            if (updatePacket == null && (updatePacket = this.func_189518_D_()) == null) {
                return;
            }
            try {
                player.field_71135_a.func_147359_a((Packet)updatePacket);
            }
            catch (Exception exception) {}
        }
    }

    protected void func_190201_b(@Nonnull World worldIn) {
        this.func_145834_a(worldIn);
    }
}

